//+------------------------------------------------------------------+
//|                                             Text_OsMAOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 6
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_color1  clrAquamarine
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int               OsMAFastPeriod    =  12;
input int               OsMASlowPeriod    =  26;
input int               OsMASignalPeriod  =  9;
input ENUM_MA_METHOD    OsMAFastMetod     =  MODE_EMA;
input ENUM_MA_METHOD    OsMASlowMethod    =  MODE_EMA;
input ENUM_MA_METHOD    OsMASignalMethod  =  MODE_SMA;
//--- indicator buffers
double         OsMABuffer[];
double         MainBuffer[];
double         SignalBuffer[];
double         FMABuffer[];
double         SMABuffer[];
double         data[];
//---
#include <IncOnArray/IncOsMAOnArray.mqh>
COsMAOnArray osma;
//---
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
  osma.Init(OsMAFastPeriod,OsMASlowPeriod,OsMASignalPeriod,OsMAFastMetod,OsMASlowMethod,OsMASignalMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,OsMABuffer,INDICATOR_DATA); 
   SetIndexBuffer(1,MainBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,SignalBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,FMABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,SMABuffer,INDICATOR_CALCULATIONS);   
   SetIndexBuffer(5,data,INDICATOR_CALCULATIONS);   
   
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,osma.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,osma.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
      if(prev_calculated>0){
         start=prev_calculated-1;
      }
      else{
         start=0;
      } 
      for(int i=start;i<rates_total;i++){
         data[i]=price[i];
      }
      
   osma.Solve(rates_total,prev_calculated,data,FMABuffer,SMABuffer,MainBuffer,SignalBuffer,OsMABuffer);     
      
   return(rates_total);
  }
//+------------------------------------------------------------------+

