//+------------------------------------------------------------------+
//|                                 CalendarEventKindsByCurrency.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2022, MetaQuotes Ltd."
#property link        "https://www.mql5.com"
#property description "Output a table of calendar event kinds (groups) for a given currency."
#property script_show_inputs

#include <MQL5Book/PRTF.mqh>

input string Currency = "CNY";

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
   MqlCalendarEvent events[];
   if(PRTF(CalendarEventByCurrency(Currency, events)))
   {
      Print("Event kinds for currency: ", Currency);
      ArrayPrint(events);
   }
}
//+------------------------------------------------------------------+
/*

CalendarEventByCurrency(Currency,events)=40 / ok
Event kinds for currency: CNY
          [id] [type] [sector] [frequency] [time_mode] [country_id] [unit] [importance] [multiplier] [digits]                                      [source_url]                                 [event_code]                                       [name] [reserved]
[ 0] 156010001      1        4           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "cpi-mm"                                     "CPI m/m"                                           ...
[ 1] 156010002      1        4           2           0          156      1            1            0        1 "http://www.stats.gov.cn/english/"                "cpi-yy"                                     "CPI y/y"                                           ...
[ 2] 156010003      1        4           2           0          156      1            1            0        1 "http://www.stats.gov.cn/english/"                "ppi-yy"                                     "PPI y/y"                                           ...
[ 3] 156010004      1        2           3           0          156      1            3            0        1 "http://www.stats.gov.cn/english/"                "gdp-qq"                                     "GDP q/q"                                           ...
[ 4] 156010005      1        2           3           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "gdp-yy"                                     "GDP y/y"                                           ...
[ 5] 156010006      1        9           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "retail-sales-yy"                            "Retail Sales y/y"                                  ...
[ 6] 156010007      1        8           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "industrial-production-yy"                   "Industrial Production y/y"                         ...
[ 7] 156010008      1        8           2           0          156      0            3            0        1 "http://www.stats.gov.cn/english/"                "manufacturing-pmi"                          "Manufacturing PMI"                                 ...
[ 8] 156010009      1        8           2           0          156      0            3            0        1 "http://www.stats.gov.cn/english/"                "non-manufacturing-pmi"                      "Non-Manufacturing PMI"                             ...
[ 9] 156010010      1        8           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "fixed-asset-investment-yy"                  "Fixed Asset Investment y/y"                        ...
[10] 156010011      0        5           0           0          156      0            2            0        0 "http://www.stats.gov.cn/english/"                "nbs-press-conference-on-economic-situation" "NBS Press Conference on Economic Situation"        ...
[11] 156010012      1        3           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "unemployment-rate"                          "Unemployment Rate"                                 ...
[12] 156010013      1        8           2           0          156      1            1            0        1 "http://www.stats.gov.cn/english/"                "industrial-profit-yy"                       "Industrial Profit y/y"                             ...
[13] 156010014      1        8           2           0          156      1            1            0        1 "http://www.stats.gov.cn/english/"                "industrial-profit-ytd-yy"                   "Industrial Profit YTD y/y"                         ...
[14] 156010015      1        8           2           0          156      0            3            0        1 "http://www.stats.gov.cn/english/"                "composite-pmi"                              "Composite PMI"                                     ...
[15] 156010016      1        8           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "industrial-production-ytd-yy"               "Industrial Production YTD y/y"                     ...
[16] 156010017      1        9           2           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "retail-sales-ytd-yy"                        "Retail Sales YTD y/y"                              ...
[17] 156010018      1        2           3           0          156      1            2            0        1 "http://www.stats.gov.cn/english/"                "gdp-ytd-yy"                                 "GDP YTD y/y"                                       ...
[18] 156020001      1        6           2           3          156      6            2            3        2 "http://english.customs.gov.cn/"                  "trade-balance-usd"                          "Trade Balance USD"                                 ...
[19] 156020002      1        6           2           3          156      1            1            0        1 "http://english.customs.gov.cn/"                  "imports-usd-yy"                             "Imports USD y/y"                                   ...
[20] 156020003      1        6           2           3          156      1            1            0        1 "http://english.customs.gov.cn/"                  "exports-usd-yy"                             "Exports USD y/y"                                   ...
[21] 156020004      1        6           2           3          156      2            2            3        2 "http://english.customs.gov.cn/"                  "trade-balance"                              "Trade Balance"                                     ...
[22] 156020005      1        6           2           3          156      1            1            0        1 "http://english.customs.gov.cn/"                  "imports-yy"                                 "Imports y/y"                                       ...
[23] 156020006      1        6           2           3          156      1            1            0        1 "http://english.customs.gov.cn/"                  "exports-yy"                                 "Exports y/y"                                       ...
[24] 156030001      1        5           2           3          156      6            1            4        3 "http://www.pbc.gov.cn/english/130437/index.html" "foreign-exchange-reserves"                  "Foreign Exchange Reserves"                         ...
[25] 156030002      1        5           2           3          156      2            2            4        3 "http://www.pbc.gov.cn/english/130437/index.html" "pbc-new-loans"                              "PBC New Loans"                                     ...
[26] 156030003      1        5           2           3          156      1            1            0        1 "http://www.pbc.gov.cn/english/130437/index.html" "pbc-m2-money-stock-yy"                      "PBC M2 Money Stock y/y"                            ...
[27] 156030004      1        5           2           3          156      1            1            0        1 "http://www.pbc.gov.cn/english/130437/index.html" "pbc-outstanding-loan-growth-yy"             "PBC Outstanding Loan Growth y/y"                   ...
[28] 156030005      0        5           0           0          156      0            3            0        0 "http://www.pbc.gov.cn/english/130437/index.html" "pbc-governor-yi-speech"                     "PBC Governor Yi Gang Speech"                       ...
[29] 156040001      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "new-years-day"                              "New Year's Day"                                    ...
[30] 156040002      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "spring-festival"                            "Spring Festival"                                   ...
[31] 156040003      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "ching-ming-festival"                        "Ching Ming Festival"                               ...
[32] 156040004      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "labor-day"                                  "Labor Day"                                         ...
[33] 156040005      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "dragon-boat-festival"                       "Dragon Boat Festival"                              ...
[34] 156040006      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "mid-autumn-festival"                        "Mid-Autumn Festival"                               ...
[35] 156040007      2       12           0           1          156      0            0            0        0 "https://publicholidays.cn/"                      "national-day"                               "National Day"                                      ...
[36] 156050001      1        5           2           3          156      1            1            0        1 "http://english.mofcom.gov.cn/"                   "foreign-direct-investment-ytd-yy"           "Foreign Direct Investment YTD y/y"                 ...
[37] 156500001      1        8           2           0          156      0            2            0        1 "https://www.markiteconomics.com"                 "caixin-manufacturing-pmi"                   "Caixin Manufacturing PMI"                          ...
[38] 156500002      1        8           2           0          156      0            2            0        1 "https://www.markiteconomics.com"                 "caixin-services-pmi"                        "Caixin Services PMI"                               ...
[39] 156500003      1        8           2           0          156      0            2            0        1 "https://www.markiteconomics.com"                 "caixin-composite-pmi"                       "Caixin Composite PMI"                              ...

*/
//+------------------------------------------------------------------+
