//+------------------------------------------------------------------+
//|                                  CalendarEventKindsByCountry.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2022, MetaQuotes Ltd."
#property link        "https://www.mql5.com"
#property description "Output a table of calendar event kinds (groups) for a given country."
#property script_show_inputs

#include <MQL5Book/PRTF.mqh>

input string CountryCode = "HK";

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
   MqlCalendarEvent events[];
   if(PRTF(CalendarEventByCountry(CountryCode, events)))
   {
      Print("Event kinds for country: ", CountryCode);
      ArrayPrint(events);
   }
}
//+------------------------------------------------------------------+
/*

CalendarEventByCountry(CountryCode,events)=26 / ok
Event kinds for country: HK
          [id] [type] [sector] [frequency] [time_mode] [country_id] [unit] [importance] [multiplier] [digits]                      [source_url]                        [event_code]                                  [name] [reserved]
[ 0] 344010001      1        5           2           0          344      6            1            3        1 "https://www.hkma.gov.hk/eng/"    "foreign-exchange-reserves"         "Foreign Exchange Reserves"                    ...
[ 1] 344010002      1        5           2           0          344      1            1            0        1 "https://www.hkma.gov.hk/eng/"    "hkma-m3-money-supply-yy"           "HKMA M3 Money Supply y/y"                     ...
[ 2] 344020001      1        4           2           0          344      1            1            0        1 "https://www.censtatd.gov.hk/en/" "cpi-yy"                            "CPI y/y"                                      ...
[ 3] 344020002      1        2           3           0          344      1            3            0        1 "https://www.censtatd.gov.hk/en/" "gdp-qq"                            "GDP q/q"                                      ...
[ 4] 344020003      1        2           3           0          344      1            2            0        1 "https://www.censtatd.gov.hk/en/" "gdp-yy"                            "GDP y/y"                                      ...
[ 5] 344020004      1        6           2           0          344      1            1            0        1 "https://www.censtatd.gov.hk/en/" "exports-mm"                        "Exports y/y"                                  ...
[ 6] 344020005      1        6           2           0          344      1            1            0        1 "https://www.censtatd.gov.hk/en/" "imports-mm"                        "Imports y/y"                                  ...
[ 7] 344020006      1        6           2           0          344      2            2            3        3 "https://www.censtatd.gov.hk/en/" "trade-balance"                     "Trade Balance"                                ...
[ 8] 344020007      1        9           2           0          344      1            1            0        1 "https://www.censtatd.gov.hk/en/" "retail-sales-yy"                   "Retail Sales y/y"                             ...
[ 9] 344020008      1        3           2           0          344      1            2            0        1 "https://www.censtatd.gov.hk/en/" "unemployment-rate-3-months"        "Unemployment Rate 3-Months"                   ...
[10] 344030001      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "new-years-day"                     "New Year's Day"                               ...
[11] 344030002      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "lunar-new-year"                    "Lunar New Year"                               ...
[12] 344030003      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "ching-ming-festival"               "Ching Ming Festival"                          ...
[13] 344030004      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "good-friday"                       "Good Friday"                                  ...
[14] 344030005      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "easter-monday"                     "Easter Monday"                                ...
[15] 344030006      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "birthday-of-buddha"                "The Birthday of the Buddha"                   ...
[16] 344030007      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "labor-day"                         "Labor Day"                                    ...
[17] 344030008      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "tuen-ng-festival"                  "Tuen Ng Festival"                             ...
[18] 344030009      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "hksar-establishment-day"           "HKSAR Establishment Day"                      ...
[19] 344030010      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "day-following-mid-autumn-festival" "The Day Following Mid-Autumn Festival"        ...
[20] 344030011      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "national-day"                      "National Day"                                 ...
[21] 344030012      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "chung-yeung-festival"              "Chung Yeung Festival"                         ...
[22] 344030013      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "christmas-day"                     "Christmas Day"                                ...
[23] 344030014      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "first-weekday-after-christmas-day" "The First Weekday After Christmas Day"        ...
[24] 344030015      2       12           0           1          344      0            0            0        0 "https://publicholidays.hk/"      "day-following-good-friday"         "The Day Following Good Friday"                ...
[25] 344500001      1        8           2           0          344      0            1            0        1 "https://www.markiteconomics.com" "nikkei-pmi"                        "S&P Global PMI"                               ...

*/
//+------------------------------------------------------------------+
