//+------------------------------------------------------------------+
//|                                            CalendarCountries.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2022, MetaQuotes Ltd."
#property link        "https://www.mql5.com"
#property description "Output a table of countries supported by built-in economic calendar."

#include <MQL5Book/PRTF.mqh>

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
   MqlCalendarCountry countries[];
   PRTF(CalendarCountries(countries));
   ArrayPrint(countries);
}
//+------------------------------------------------------------------+
/*

   CalendarCountries(countries)=23 / ok
        [id]           [name] [code] [currency] [currency_symbol]       [url_name] [reserved]
   [ 0]  554 "New Zealand"    "NZ"   "NZD"      "$"               "new-zealand"           ...
   [ 1]  999 "European Union" "EU"   "EUR"      "€"               "european-union"        ...
   [ 2]  392 "Japan"          "JP"   "JPY"      "¥"               "japan"                 ...
   [ 3]  124 "Canada"         "CA"   "CAD"      "$"               "canada"                ...
   [ 4]   36 "Australia"      "AU"   "AUD"      "$"               "australia"             ...
   [ 5]  156 "China"          "CN"   "CNY"      "¥"               "china"                 ...
   [ 6]  380 "Italy"          "IT"   "EUR"      "€"               "italy"                 ...
   [ 7]  702 "Singapore"      "SG"   "SGD"      "R$"              "singapore"             ...
   [ 8]  276 "Germany"        "DE"   "EUR"      "€"               "germany"               ...
   [ 9]  250 "France"         "FR"   "EUR"      "€"               "france"                ...
   [10]   76 "Brazil"         "BR"   "BRL"      "R$"              "brazil"                ...
   [11]  484 "Mexico"         "MX"   "MXN"      "Mex$"            "mexico"                ...
   [12]  710 "South Africa"   "ZA"   "ZAR"      "R"               "south-africa"          ...
   [13]  344 "Hong Kong"      "HK"   "HKD"      "HK$"             "hong-kong"             ...
   [14]  356 "India"          "IN"   "INR"      "₹"               "india"                 ...
   [15]  578 "Norway"         "NO"   "NOK"      "Kr"              "norway"                ...
   [16]    0 "Worldwide"      "WW"   "ALL"      ""                "worldwide"             ...
   [17]  840 "United States"  "US"   "USD"      "$"               "united-states"         ...
   [18]  826 "United Kingdom" "GB"   "GBP"      "£"               "united-kingdom"        ...
   [19]  756 "Switzerland"    "CH"   "CHF"      "₣"               "switzerland"           ...
   [20]  410 "South Korea"    "KR"   "KRW"      "₩"               "south-korea"           ...
   [21]  724 "Spain"          "ES"   "EUR"      "€"               "spain"                 ...
   [22]  752 "Sweden"         "SE"   "SEK"      "Kr"              "sweden"                ...

*/
//+------------------------------------------------------------------+
