#include "OnTradeTransaction.mqh"
#include "ResourceData.mqh"

class TRADETRANSACTIONS : public RESOURCEDATA<ONTRADETRANSACTION>
{
private:
  const int handle;
  uint Pos;
  uint Total;

  static bool SetID( uint &RequestID[], const uint ID = 0 )
  {
    uint Sum = 0;

    for (int i = ::ArraySize(RequestID) - 1; i >= 0; i--)
      if (RequestID[i] == ID)
        RequestID[i] = 0;
      else
        Sum += RequestID[i];

    return(Sum);
  }

public:
  TRADETRANSACTIONS( const string sName = __FILE__, const string IndicatorName = "fxsaber\\TradeTransactions.ex5" ) : Pos(0), Total(0),
                     RESOURCEDATA((::MQLInfoInteger(MQL_PROGRAM_TYPE) == PROGRAM_INDICATOR) ? "::" + sName : "\\Indicators\\" + IndicatorName + "::" + (string)::ChartID()),
                     handle((::MQLInfoInteger(MQL_PROGRAM_TYPE) == PROGRAM_INDICATOR) ? INVALID_HANDLE : ::iCustom(::_Symbol, PERIOD_CURRENT, IndicatorName, ::ChartID()))
  {
  }

  ~TRADETRANSACTIONS( void )
  {
    if (this.handle != INVALID_HANDLE)
      ::IndicatorRelease(this.handle);
  }

  bool Select( const int iPos )
  {
    const bool Res = (iPos < this.Total());

    if (Res)
      this.Pos = iPos;

    return(Res);
  }

  ulong Get( MqlTradeTransaction &Trans, MqlTradeRequest &Request, MqlTradeResult &Result )
  {
    return(this[this.Pos].Get(Trans, Request, Result));
  }

  void Add( const MqlTradeTransaction &Trans, const MqlTradeRequest &Request, const MqlTradeResult &Result, const ulong Time = 0 )
  {
    ONTRADETRANSACTION OnTradeTrans;

    OnTradeTrans.Set(Trans, Request, Result, Time);

    this += OnTradeTrans;

    return;
  }

  bool Waiting( uint &RequestID[], const ulong MaxTimeWaiting = 1000000 )
  {
    const ulong StartTime = ::GetMicrosecondCount();
    bool Res = TRADETRANSACTIONS::SetID(RequestID);

    while (Res && !::IsStopped() && (::GetMicrosecondCount() - StartTime < MaxTimeWaiting))
    {
      ONTRADETRANSACTION OnTradeTrans[];
      const uint NewTotal = this.Get(OnTradeTrans);

      for (uint i = this.Total; i < NewTotal; i++)
      {
        MqlTradeTransaction Trans;
        MqlTradeRequest Request;
        MqlTradeResult Result;

        OnTradeTrans[i].Get(Trans, Request, Result);

        if (Result.request_id)
          Res = TRADETRANSACTIONS::SetID(RequestID, Result.request_id);
      }

      this.Total = NewTotal;
/*
      if (Res)
        ::Sleep(0); */
    }

    return(!Res);
  }
};