#include "String.mqh"

struct TRADETRANSACTION
{
  ulong                         deal;
  ulong                         order;
  STRING                        symbol;
  ENUM_TRADE_TRANSACTION_TYPE   type;
  ENUM_ORDER_TYPE               order_type;
  ENUM_ORDER_STATE              order_state;
  ENUM_DEAL_TYPE                deal_type;
  ENUM_ORDER_TYPE_TIME          time_type;
  datetime                      time_expiration;
  double                        price;
  double                        price_trigger;
  double                        price_sl;
  double                        price_tp;
  double                        volume;
  ulong                         position;
  ulong                         position_by;

  void operator =( const MqlTradeTransaction &Trans )
  {
    this.deal = Trans.deal;
    this.order = Trans.order;
    this.symbol = Trans.symbol;
    this.type = Trans.type;
    this.order_type = Trans.order_type;
    this.order_state = Trans.order_state;
    this.deal_type = Trans.deal_type;
    this.time_type = Trans.time_type;
    this.time_expiration = Trans.time_expiration;
    this.price = Trans.price;
    this.price_trigger = Trans.price_trigger;
    this.price_sl = Trans.price_sl;
    this.price_tp = Trans.price_tp;
    this.volume = Trans.volume;
    this.position = Trans.position;
    this.position_by = Trans.position_by;

    return;
  }

  void Get( MqlTradeTransaction &Trans ) const
  {
    Trans.deal = this.deal;
    Trans.order = this.order;
    Trans.symbol = this.symbol.Get();
    Trans.type = this.type;
    Trans.order_type = this.order_type;
    Trans.order_state = this.order_state;
    Trans.deal_type = this.deal_type;
    Trans.time_type = this.time_type;
    Trans.time_expiration = this.time_expiration;
    Trans.price = this.price;
    Trans.price_trigger = this.price_trigger;
    Trans.price_sl = this.price_sl;
    Trans.price_tp = this.price_tp;
    Trans.volume = this.volume;
    Trans.position = this.position;
    Trans.position_by = this.position_by;

    return;
  }
};