#include <TypeToBytes.mqh> // https://www.mql5.com/ru/code/16280
#include "Resource.mqh"

template <typename T>
class RESOURCEDATA : private RESOURCE
{
public:
  RESOURCEDATA( const string sName = __FILE__ ) : RESOURCE(sName)
  {
  }

  void Free( void ) const
  {
    ::ResourceFree(this.Name);

    return;
  }

  int Total( void ) const
  {
    uint Data[];

    return(this.Get(Data) * sizeof(uint) / sizeof(T));
  }

  int Get( T &Array[] ) const
  {
    uint Data[];
    const int Size = this.Get(Data);

    return(((::_ArrayCopy(Array, Data)) > 0) ? ::ArraySize(Array) : 0);
  }

  const T operator[]( const uint Pos ) const
  {
    T Res[1] = {0};
    uint Data[];

    this.Get(Data);

    ::_ArrayCopy(Res, Data, 0, sizeof(T) * Pos, sizeof(T));

    return(Res[0]);
  }

#define OPERATOR(A, B, C)                   \
  void operator A( const T &B ) const       \
  {                                         \
    uint Data[];                            \
                                            \
    ::_ArrayCopy(Data, _R(Value).Bytes, C); \
    this.Set(Data);                         \
                                            \
    return;                                 \
  }

  OPERATOR(+=, Value, this.Get(Data) * sizeof(uint))
  OPERATOR(+=, Value[], this.Get(Data) * sizeof(uint))

  OPERATOR(=, Value, 0)
  OPERATOR(=, Value[], 0)
#undef OPERATOR
};