//+------------------------------------------------------------------+
//|                                                     AvgRange.mq5 |
//|                 Copyright  2005, tageiger aka fxid10t@yahoo.com |
//|                                        http://www.metatrader.org |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, tageiger aka fxid10t@yahoo.com"
#property link      "http://www.metatrader.org"
//---   
#property version   "1.01"
//---  
#property description ""
//---     
#property indicator_chart_window  
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|     1          |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        
#property indicator_color1  clrBlue
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  2
#property indicator_width1  2
//---   
#property indicator_label1  "Upper"
//+----------------------------------------------+
//|    2                  |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---        
#property indicator_color2  clrRed
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  2
#property indicator_width2  2
//---   
#property indicator_label2  "Lover"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   RangePeriod=200;
input int    Shift=0;  //      
//+----------------------------------------------+
//---   ,   
//---      
double Ind1Buffer[];
double Ind2Buffer[];
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(RangePeriod)+2;
//---      
   SetIndexBuffer(0,Ind1Buffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Ind1Buffer,true);
//---      
   SetIndexBuffer(1,Ind2Buffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(Ind2Buffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"AvgRange(",RangePeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit,bar;
   double sum_rng,avg_rng;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-1-min_rates_total; //      
   else limit=rates_total-prev_calculated; //      
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//---    
   for(bar=0; bar<limit && !IsStopped(); bar++)
     {
      sum_rng=0;
      for(int iii=0; iii<int(RangePeriod); iii++) sum_rng+=high[bar+iii]-low[bar+iii];
      avg_rng=sum_rng/RangePeriod;
      avg_rng/=2.0;
      //---
      Ind1Buffer[bar]=close[bar]+avg_rng;
      Ind2Buffer[bar]=close[bar]-avg_rng;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+

   