//+------------------------------------------------------------------
//| LibraryTest.mq5
//| austrav
//+------------------------------------------------------------------
#property copyright "austrav"
#property version   "1.00"
#property script_show_inputs
#include <errordesc.mqh>
#property description "errordesc.mqh test script. "
#property description "   error_value=-1 'print all available error codes'"
#property description "   error_value=GetLastError code 'print description of error code'"

input int error_value = -1;

//+------------------------------------------------------------------
//| OnStart()
//+------------------------------------------------------------------
void OnStart()
{
   if (error_value == -1) AllErrorCodes();
   else Print(ErrorDescription(error_value));
}//void OnStart()

//+------------------------------------------------------------------
//| Print all available error codes
//+------------------------------------------------------------------
void AllErrorCodes()
{
   
   Print(ErrorDescription(ERR_SUCCESS, "Testing."));
   Print(ErrorDescription(ERR_INTERNAL_ERROR, "Testing."));
   Print(ErrorDescription(ERR_WRONG_INTERNAL_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_INVALID_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_NOT_ENOUGH_MEMORY, "Testing."));
   Print(ErrorDescription(ERR_STRUCT_WITHOBJECTS_ORCLASS, "Testing."));
   Print(ErrorDescription(ERR_INVALID_ARRAY, "Testing."));
   Print(ErrorDescription(ERR_ARRAY_RESIZE_ERROR, "Testing."));
   Print(ErrorDescription(ERR_STRING_RESIZE_ERROR, "Testing."));
   Print(ErrorDescription(ERR_NOTINITIALIZED_STRING, "Testing."));
   Print(ErrorDescription(ERR_INVALID_DATETIME, "Testing."));
   Print(ErrorDescription(ERR_ARRAY_BAD_SIZE, "Testing."));
   Print(ErrorDescription(ERR_INVALID_POINTER, "Testing."));
   Print(ErrorDescription(ERR_INVALID_POINTER_TYPE, "Testing."));
   Print(ErrorDescription(ERR_FUNCTION_NOT_ALLOWED, "Testing."));
   Print(ErrorDescription(ERR_RESOURCE_NAME_DUPLICATED, "Testing."));
   Print(ErrorDescription(ERR_RESOURCE_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_RESOURCE_UNSUPPOTED_TYPE, "Testing."));
   Print(ErrorDescription(ERR_RESOURCE_NAME_IS_TOO_LONG, "Testing."));
   Print(ErrorDescription(ERR_MATH_OVERFLOW, "Testing."));
   // Charts
   Print(ErrorDescription(ERR_CHART_WRONG_ID, "Testing."));
   Print(ErrorDescription(ERR_CHART_NO_REPLY, "Testing."));
   Print(ErrorDescription(ERR_CHART_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_CHART_NO_EXPERT, "Testing."));
   Print(ErrorDescription(ERR_CHART_CANNOT_OPEN, "Testing."));
   Print(ErrorDescription(ERR_CHART_CANNOT_CHANGE, "Testing."));
   Print(ErrorDescription(ERR_CHART_WRONG_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_CHART_CANNOT_CREATE_TIMER, "Testing."));
   Print(ErrorDescription(ERR_CHART_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_CHART_SCREENSHOT_FAILED, "Testing."));
   Print(ErrorDescription(ERR_CHART_NAVIGATE_FAILED, "Testing."));
   Print(ErrorDescription(ERR_CHART_TEMPLATE_FAILED, "Testing."));
   Print(ErrorDescription(ERR_CHART_WINDOW_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_CHART_INDICATOR_CANNOT_ADD, "Testing."));
   Print(ErrorDescription(ERR_CHART_INDICATOR_CANNOT_DEL, "Testing."));
   Print(ErrorDescription(ERR_CHART_INDICATOR_NOT_FOUND, "Testing."));
   // Graphical Objects
   Print(ErrorDescription(ERR_OBJECT_ERROR, "Testing."));
   Print(ErrorDescription(ERR_OBJECT_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_OBJECT_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_OBJECT_GETDATE_FAILED, "Testing."));
   Print(ErrorDescription(ERR_OBJECT_GETVALUE_FAILED, "Testing."));
   // MarketInfo
   Print(ErrorDescription(ERR_MARKET_UNKNOWN_SYMBOL, "Testing."));
   Print(ErrorDescription(ERR_MARKET_NOT_SELECTED, "Testing."));
   Print(ErrorDescription(ERR_MARKET_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_MARKET_LASTTIME_UNKNOWN, "Testing."));
   Print(ErrorDescription(ERR_MARKET_SELECT_ERROR, "Testing."));
   // History Access
   Print(ErrorDescription(ERR_HISTORY_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_HISTORY_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_HISTORY_TIMEOUT, "Testing."));
   Print(ErrorDescription(ERR_HISTORY_BARS_LIMIT, "Testing."));
   Print(ErrorDescription(ERR_HISTORY_LOAD_ERRORS, "Testing."));
   Print(ErrorDescription(ERR_HISTORY_SMALL_BUFFER, "Testing."));
   // Global_Variables
   Print(ErrorDescription(ERR_GLOBALVARIABLE_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_GLOBALVARIABLE_EXISTS, "Testing."));
   Print(ErrorDescription(ERR_GLOBALVARIABLE_NOT_MODIFIED, "Testing."));
   Print(ErrorDescription(ERR_GLOBALVARIABLE_CANNOTREAD, "Testing."));
   Print(ErrorDescription(ERR_GLOBALVARIABLE_CANNOTWRITE, "Testing."));
   Print(ErrorDescription(ERR_MAIL_SEND_FAILED, "Testing."));
   Print(ErrorDescription(ERR_PLAY_SOUND_FAILED, "Testing."));
   Print(ErrorDescription(ERR_MQL5_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_TERMINAL_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_FTP_SEND_FAILED, "Testing."));
   Print(ErrorDescription(ERR_NOTIFICATION_SEND_FAILED, "Testing."));
   Print(ErrorDescription(ERR_NOTIFICATION_WRONG_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_NOTIFICATION_WRONG_SETTINGS, "Testing."));
   Print(ErrorDescription(ERR_NOTIFICATION_TOO_FREQUENT, "Testing."));
   Print(ErrorDescription(ERR_FTP_NOSERVER, "Testing."));
   Print(ErrorDescription(ERR_FTP_NOLOGIN, "Testing."));
   Print(ErrorDescription(ERR_FTP_FILE_ERROR, "Testing."));
   Print(ErrorDescription(ERR_FTP_CONNECT_FAILED, "Testing."));
   Print(ErrorDescription(ERR_FTP_CHANGEDIR, "Testing."));
   Print(ErrorDescription(4524, "Testing."));
   // Custom Indicator Buffers
   Print(ErrorDescription(ERR_BUFFERS_NO_MEMORY, "Testing."));
   Print(ErrorDescription(ERR_BUFFERS_WRONG_INDEX, "Testing."));
   // Custom Indicator Properties
   Print(ErrorDescription(ERR_CUSTOM_WRONG_PROPERTY, "Testing."));
   // Account
   Print(ErrorDescription(ERR_ACCOUNT_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_TRADE_WRONG_PROPERTY, "Testing."));
   Print(ErrorDescription(ERR_TRADE_DISABLED, "Testing."));
   Print(ErrorDescription(ERR_TRADE_POSITION_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_TRADE_ORDER_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_TRADE_DEAL_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_TRADE_SEND_FAILED, "Testing."));
   Print(ErrorDescription(ERR_TRADE_CALC_FAILED, "Testing."));
   // Indicators
   Print(ErrorDescription(ERR_INDICATOR_UNKNOWN_SYMBOL, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_CANNOT_CREATE, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_NO_MEMORY, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_CANNOT_APPLY, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_CANNOT_ADD, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_DATA_NOT_FOUND, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_WRONG_HANDLE, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_WRONG_PARAMETERS, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_PARAMETERS_MISSING, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_CUSTOM_NAME, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_PARAMETER_TYPE, "Testing."));
   Print(ErrorDescription(ERR_INDICATOR_WRONG_INDEX, "Testing."));
   // Depth of Market
   Print(ErrorDescription(ERR_BOOKS_CANNOT_ADD, "Testing."));
   Print(ErrorDescription(ERR_BOOKS_CANNOT_DELETE, "Testing."));
   Print(ErrorDescription(ERR_BOOKS_CANNOT_GET, "Testing."));
   Print(ErrorDescription(ERR_BOOKS_CANNOT_SUBSCRIBE, "Testing."));
   // File Operations
   Print(ErrorDescription(ERR_TOO_MANY_FILES, "Testing."));
   Print(ErrorDescription(ERR_WRONG_FILENAME, "Testing."));
   Print(ErrorDescription(ERR_TOO_LONG_FILENAME, "Testing."));
   Print(ErrorDescription(ERR_CANNOT_OPEN_FILE, "Testing."));
   Print(ErrorDescription(ERR_FILE_CACHEBUFFER_ERROR, "Testing."));
   Print(ErrorDescription(ERR_CANNOT_DELETE_FILE, "Testing."));
   Print(ErrorDescription(ERR_INVALID_FILEHANDLE, "Testing."));
   Print(ErrorDescription(ERR_WRONG_FILEHANDLE, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTTOWRITE, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTTOREAD, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTBIN, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTTXT, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTTXTORCSV, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOTCSV, "Testing."));
   Print(ErrorDescription(ERR_FILE_READERROR, "Testing."));
   Print(ErrorDescription(ERR_FILE_BINSTRINGSIZE, "Testing."));
   Print(ErrorDescription(ERR_INCOMPATIBLE_FILE, "Testing."));
   Print(ErrorDescription(ERR_FILE_IS_DIRECTORY, "Testing."));
   Print(ErrorDescription(ERR_FILE_NOT_EXIST, "Testing."));
   Print(ErrorDescription(ERR_FILE_CANNOT_REWRITE, "Testing."));
   Print(ErrorDescription(ERR_WRONG_DIRECTORYNAME, "Testing."));
   Print(ErrorDescription(ERR_DIRECTORY_NOT_EXIST, "Testing."));
   Print(ErrorDescription(ERR_FILE_ISNOT_DIRECTORY, "Testing."));
   Print(ErrorDescription(ERR_CANNOT_DELETE_DIRECTORY, "Testing."));
   Print(ErrorDescription(ERR_CANNOT_CLEAN_DIRECTORY, "Testing."));
   Print(ErrorDescription(ERR_FILE_WRITEERROR, "Testing."));
   Print(ErrorDescription(ERR_FILE_ENDOFFILE, "Testing."));
   // String Casting
   Print(ErrorDescription(ERR_NO_STRING_DATE, "Testing."));
   Print(ErrorDescription(ERR_WRONG_STRING_DATE, "Testing."));
   Print(ErrorDescription(ERR_WRONG_STRING_TIME, "Testing."));
   Print(ErrorDescription(ERR_STRING_TIME_ERROR, "Testing."));
   Print(ErrorDescription(ERR_STRING_OUT_OF_MEMORY, "Testing."));
   Print(ErrorDescription(ERR_STRING_SMALL_LEN, "Testing."));
   Print(ErrorDescription(ERR_STRING_TOO_BIGNUMBER, "Testing."));
   Print(ErrorDescription(ERR_WRONG_FORMATSTRING, "Testing."));
   Print(ErrorDescription(ERR_TOO_MANY_FORMATTERS, "Testing."));
   Print(ErrorDescription(ERR_TOO_MANY_PARAMETERS, "Testing."));
   Print(ErrorDescription(ERR_WRONG_STRING_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_STRINGPOS_OUTOFRANGE, "Testing."));
   Print(ErrorDescription(ERR_STRING_ZEROADDED, "Testing."));
   Print(ErrorDescription(ERR_STRING_UNKNOWNTYPE, "Testing."));
   Print(ErrorDescription(ERR_WRONG_STRING_OBJECT, "Testing."));
   // Operations with Arrays
   Print(ErrorDescription(ERR_INCOMPATIBLE_ARRAYS, "Testing."));
   Print(ErrorDescription(ERR_SMALL_ASSERIES_ARRAY, "Testing."));
   Print(ErrorDescription(ERR_SMALL_ARRAY, "Testing."));
   Print(ErrorDescription(ERR_ZEROSIZE_ARRAY, "Testing."));
   Print(ErrorDescription(ERR_NUMBER_ARRAYS_ONLY, "Testing."));
   Print(ErrorDescription(ERR_ONEDIM_ARRAYS_ONLY, "Testing."));
   Print(ErrorDescription(ERR_SERIES_ARRAY, "Testing."));
   Print(ErrorDescription(ERR_DOUBLE_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_FLOAT_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_LONG_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_INT_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_SHORT_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_CHAR_ARRAY_ONLY, "Testing."));
   Print(ErrorDescription(ERR_STRING_ARRAY_ONLY, "Testing."));
   // Operations with OpenCL
   Print(ErrorDescription(ERR_OPENCL_NOT_SUPPORTED, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_INTERNAL, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_INVALID_HANDLE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_CONTEXT_CREATE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_QUEUE_CREATE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_PROGRAM_CREATE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_TOO_LONG_KERNEL_NAME, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_KERNEL_CREATE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_SET_KERNEL_PARAMETER, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_EXECUTE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_WRONG_BUFFER_SIZE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_WRONG_BUFFER_OFFSET, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_BUFFER_CREATE, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_TOO_MANY_OBJECTS, "Testing."));
   Print(ErrorDescription(ERR_OPENCL_SELECTDEVICE, "Testing."));
   // Operations with WebRequest
   Print(ErrorDescription(ERR_WEBREQUEST_INVALID_ADDRESS, "Testing."));
   Print(ErrorDescription(ERR_WEBREQUEST_CONNECT_FAILED, "Testing."));
   Print(ErrorDescription(ERR_WEBREQUEST_TIMEOUT, "Testing."));
   Print(ErrorDescription(ERR_WEBREQUEST_REQUEST_FAILED, "Testing."));
   // Custom Symbols
   Print(ErrorDescription(ERR_NOT_CUSTOM_SYMBOL, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_WRONG_NAME, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_NAME_LONG, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_PATH_LONG, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_EXIST, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_ERROR, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_SELECTED, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_PROPERTY_WRONG, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_PARAMETER_ERROR, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_SYMBOL_PARAMETER_LONG, "Testing."));
   Print(ErrorDescription(ERR_CUSTOM_TICKS_WRONG_ORDER, "Testing."));
   // Return Codes of the Trade Server
   Print(ErrorDescription(TRADE_RETCODE_REQUOTE, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_REJECT, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_CANCEL, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_PLACED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_DONE, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_DONE_PARTIAL, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_ERROR, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_TIMEOUT, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_VOLUME, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_PRICE, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_STOPS, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_TRADE_DISABLED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_MARKET_CLOSED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_NO_MONEY, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_PRICE_CHANGED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_PRICE_OFF, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_EXPIRATION, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_ORDER_CHANGED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_TOO_MANY_REQUESTS, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_NO_CHANGES, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_SERVER_DISABLES_AT, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_CLIENT_DISABLES_AT, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_LOCKED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_FROZEN, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_FILL, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_CONNECTION, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_ONLY_REAL, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_LIMIT_ORDERS, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_LIMIT_VOLUME, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_ORDER, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_POSITION_CLOSED, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_INVALID_CLOSE_VOLUME, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_CLOSE_ORDER_EXIST, "Testing."));


   Print(ErrorDescription(TRADE_RETCODE_LIMIT_POSITIONS, "Testing."));


   Print(ErrorDescription(TRADE_RETCODE_REJECT_CANCEL, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_LONG_ONLY, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_SHORT_ONLY, "Testing."));
   Print(ErrorDescription(TRADE_RETCODE_CLOSE_ONLY, "Testing."));

   // User-Defined Errors
   //for (int i=ERR_USER_ERROR_FIRST;i<=ERR_USER_ERROR_LAST;i++)
   Print(ErrorDescription(ERR_USER_ERROR_FIRST, "Testing."));
   Print(ErrorDescription(ERR_USER_ERROR_LAST, "Testing."));
   for (int i=0;i<5;i++)
      Print(ErrorDescription(ERR_USER_ERROR_FIRST+(int)MathRound((ERR_USER_ERROR_LAST - ERR_USER_ERROR_FIRST)*MathRand()/32767), "Testing."));
   for (int i=0;i<5;i++)
      Print(ErrorDescription((int)MathRound(10044*MathRand()/32767), "Testing."));
}//void AllErrorCodes()