//    Init/Deinit .
//      int OnInit(), OnDeinit, OnTimer  OnChartEvent.
//    -  .

#include <TypeToBytes.mqh> // https://www.mql5.com/ru/code/16280
#include <crc64.mqh>       // https://www.mql5.com/en/blogs/post/683577

template <typename T>
struct PTR
{
  T* Ptr;

  PTR( void ) : Ptr(NULL)
  {
  }

  PTR( T* ptr ) : Ptr(ptr)
  {
  }

  ~PTR( void )
  {
    if (this.Ptr)
      delete this.Ptr;
  }

  bool Set( T* ptr )
  {
    this.Ptr = ptr;

    return(true);
  }

  void operator =( bool )
  {
  }
};

class INIT_SYNC
{
private:
#define THIS INIT_SYNC::sPtr.Ptr

  static PTR<INIT_SYNC> sPtr;

  const string GlobalName;

  template <typename T>
  static ulong crc64( const T &Array[] )
  {
    ulong crc = 0;

    return(::crc64(crc, _R(Array).Bytes, ::ArraySize(Array) * sizeof(T)));
  }

  static int GetShortNames( string &ShortNames[], const long Chart_ID = 0, const int SubWindow = 0 )
  {
    const int Total = ::ChartIndicatorsTotal(Chart_ID, SubWindow);

    ::ArrayResize(ShortNames, Total);

    for (int i = 0; i < Total; i++)
      ShortNames[i] = ::ChartIndicatorName(Chart_ID, SubWindow, i);

    return(Total);
  }

  //   " " - ShortName
  static string GetMyShortName( void )
  {
    string Res = "";

    const int SubWindow = ::ChartWindowFind();

    string ShortNames[];

    INIT_SYNC::GetShortNames(ShortNames, 0, SubWindow);

    const string TmpShortName = __FUNCSIG__ + (string)::MathRand();

    ::IndicatorSetString(INDICATOR_SHORTNAME, TmpShortName);

    string NewShortNames[];

    const int Total = INIT_SYNC::GetShortNames(NewShortNames, 0, SubWindow);

    for (int i = 0; i < Total; i++)
      if (NewShortNames[i] == TmpShortName)
      {
        Res = ShortNames[i];

        ::IndicatorSetString(INDICATOR_SHORTNAME, Res);

        break;
      }

    return(Res);
  }

  //   
  static int GetMyHandle( void )
  {
    const string ShortName = INIT_SYNC::GetMyShortName();

    const string TmpShortName = __FUNCSIG__ + (string)::MathRand();

    ::IndicatorSetString(INDICATOR_SHORTNAME, TmpShortName);

    const int Res = ::ChartIndicatorGet(0, ::ChartWindowFind(), TmpShortName);

    ::IndicatorSetString(INDICATOR_SHORTNAME, ShortName);

    return(Res);
  }

  static string GetMyUniqueName( void )
  {
    const int handle = GetMyHandle();

    MqlParam Params[];
    ENUM_INDICATOR Type;

    const int Total = ::IndicatorParameters(handle, Type, Params);
    ::IndicatorRelease(handle);

    uchar Bytes[];

    for (int i = 1; i < Total; i++)
    {
      ::ArrayCopy(Bytes, _R(Params[i].double_value).Bytes, ::ArraySize(Bytes));
      ::ArrayCopy(Bytes, _R(Params[i].integer_value).Bytes, ::ArraySize(Bytes));
      ::ArrayCopy(Bytes, _R(Params[i].string_value).Bytes, ::ArraySize(Bytes));
    }

    return("::" + (string)::ChartID() + (string)INIT_SYNC::crc64(Bytes) + ::MQLInfoString(MQL_PROGRAM_NAME));
  }

  static bool ResourceCreate( const string Name )
  {
    const uint Data[] = {0};

    return(::ResourceCreate(Name, Data, 1, 1, 0, 0, 1, COLOR_FORMAT_XRGB_NOALPHA));
  }

  static bool ResourceCheck( const string Name )
  {
    uint Data[];

    uint Width, Height;

    return(::ResourceReadImage(Name, Data, Width, Height));
  }

  INIT_SYNC( void ) : GlobalName(::StringSubstr(INIT_SYNC::GetMyUniqueName(), 0, 65))
  {
  }

  static bool Set()
  {
    return(THIS ? false : INIT_SYNC::sPtr.Set(new INIT_SYNC));
  }

public:
  static bool Check( void )
  {
    if (INIT_SYNC::Set())
      return(true);

    static bool FirstRun = true;
    static bool FirstRunInit = true;

//    if (FirstRun && (!::GlobalVariableCheck(THIS.GlobalName)))
    if (FirstRun && (!INIT_SYNC::ResourceCheck(THIS.GlobalName)))
    {
//      FirstRun = (::GlobalVariableSet(THIS.GlobalName, 0) == 0);
      FirstRun = !INIT_SYNC::ResourceCreate(THIS.GlobalName);

      if (!FirstRun)
      {
        ::EventKillTimer();

        ::OnInit();
        FirstRunInit = false;
      }
    }
    else if (FirstRun)
      ::EventSetMillisecondTimer(1);
    else
      FirstRunInit = true;

    return(FirstRun || !FirstRunInit);
  }

  ~INIT_SYNC( void )
  {
//    ::GlobalVariableDel(THIS.GlobalName);
    ::ResourceFree(THIS.GlobalName);
  }

#undef THIS
};

//    INIT_SYNC   .
//   INIT_SYNC-,     
static PTR<INIT_SYNC> INIT_SYNC::sPtr = INIT_SYNC::Check();

#define CHECK_INIT_SYNC if (INIT_SYNC::Check()) return

int OnInit( void )
{
  CHECK_INIT_SYNC INIT_SUCCEEDED;

  return(::OldOnInit());
}

#define OnInit OldOnInit

void OnTimer( void )
{
  CHECK_INIT_SYNC;

  ::OldOnTimer();
}

#define OnTimer OldOnTimer

void OnDeinit( const int Reason )
{
  CHECK_INIT_SYNC;

  ::OldOnDeinit(Reason);
}

#define OnDeinit OldOnDeinit

void OnChartEvent( const int id,
                   const long& lparam,
                   const double& dparam,
                   const string& sparam )
{
  CHECK_INIT_SYNC;

  ::OldOnChartEvent(id, lparam, dparam, sparam);
}

#define OnChartEvent OldOnChartEvent

int OnCalculate( const int rates_total,
                 const int prev_calculated,
                 const datetime &time[],
                 const double &open[],
                 const double &high[],
                 const double &low[],
                 const double &close[],
                 const long &tick_volume[],
                 const long &volume[],
                 const int &spread[] )
{
  CHECK_INIT_SYNC prev_calculated;

  return(::OldOnCalculate(rates_total, prev_calculated, time, open, high, low, close, tick_volume, volume, spread));
}
/*
int OnCalculate( const int rates_total,
                 const int prev_calculated,
                 const int begin,
                 const double& price[] )
{
  CHECK_INIT_SYNC prev_calculated;

  return(::OldOnCalculate(rates_total, prev_calculated, begin, price));
}
*/
#define OnCalculate OldOnCalculate