//+---------------------------------------------------------------------+
//|                                                           XvaMA.mq5 | 
//|                                               Copyright  2013, J.B | 
//|                                                                     | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2013, J.B"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "XvaMA"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method1=MODE_EMA_;// 
input uint XLength1=15;                   //                     
input int XPhase1=15;                     // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method XMA_Method2=MODE_JJMA;// 
input uint XLength2=5;                   //                     
input int XPhase2=100;                   // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;    // 
input int Shift=0;                       //     
input int PriceShift=0;                  //c     
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[];

//----      
double dPriceShift;
//----      
int min_rates,min_rates_total,XLength4,XLength8,XLength12;
//----   
int Count[];
double Xma[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| XvaMA indicator initialization function                          | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates=GetStartBars(XMA_Method1,XLength1,XPhase1);
   min_rates_total=min_rates+GetStartBars(XMA_Method2,XLength2,XPhase2);
   XLength4=int(XLength1/4);
   XLength8=int(XLength1/8);
   XLength12=int(XLength1/12);
//----       
   XMA1.XMALengthCheck("XLength1",XLength1);
   XMA1.XMALengthCheck("XLength2",XLength2);
   XMA1.XMAPhaseCheck("XPhase1",XPhase1,XMA_Method1);
   XMA1.XMAPhaseCheck("XPhase2",XPhase2,XMA_Method2);
//----    
   dPriceShift=_Point*PriceShift;
//----       
   ArrayResize(Count,XLength1);
   ArrayResize(Xma,XLength1);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method1);
   StringConcatenate(shortname,"XvaMA(",XLength1,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| XvaMA iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price,vel,acc,aaa,vama,xvama;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      //----    
      ArrayInitialize(Count,0);
      ArrayInitialize(Xma,0.0);
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);                                                             // 
      Xma[Count[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method1,XPhase1,XLength1,price,bar,false);   //  
      vel=Xma[Count[0]]-Xma[Count[XLength4]];                                                                     //  
      acc=Xma[Count[0]]-2*Xma[Count[XLength4]]+Xma[Count[XLength8]];                                              //   
      aaa=Xma[Count[0]]-3*Xma[Count[XLength4]]+3*Xma[Count[XLength8]]-Xma[Count[XLength12]];                      //  ...                                                                                         
      vama=Xma[Count[0]]+vel+acc/2+aaa/6;                                                                         // 
      xvama=XMA2.XMASeries(min_rates,prev_calculated,rates_total,XMA_Method2,XPhase2,XLength2,vama,bar,false);    //     
      IndBuffer[bar]=xvama+dPriceShift;                                                                           //      
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,XLength1);                                                 //     
     }              
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
