//+---------------------------------------------------------------------+ 
//|                                                           OsHMA.mq5 |
//|                                            Copyright  2009, sealdo |
//|                                                    sealdo@yandex.ru |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property  copyright "Copyright  2009, sealdo"
#property  link      "sealdo@yandex.ru" 
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrBlue,clrDodgerBlue,clrDarkOrange,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "OsHMA"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int FastHMA=13; //   HMA
input int SlowHMA=26; //   HMA
//+-----------------------------------+
//----      
int min_rates_total;
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//----   
int fHma2_Period,fSqrt_Period,sHma2_Period,sSqrt_Period;
//+------------------------------------------------------------------+    
//| OsHMA indicator initialization function                          | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   fHma2_Period=int(MathFloor(FastHMA/2));
   sHma2_Period=int(MathFloor(SlowHMA/2));
   fSqrt_Period=int(MathFloor(MathSqrt(FastHMA)));
   sSqrt_Period=int(MathFloor(MathSqrt(SlowHMA)));

//----     
   min_rates_total=MathMax(fHma2_Period+fSqrt_Period,sHma2_Period+sSqrt_Period);

//----    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Ind");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);

//----         
   string short_name="OsHMA";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name+"("+string(FastHMA)+","+string(SlowHMA)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//   CMoving_Average                                   | 
//+------------------------------------------------------------------+  
#include <SmoothAlgorithms.mqh>
//+------------------------------------------------------------------+  
//| OsHMA iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,     //       
                const int prev_calculated, //       
                const int begin,           //     
                const double &price[]      //     
                )
  {
//----       
   if(rates_total<min_rates_total+begin) return(0);

//----    
   int first,bar;
   double lwma1,lwma2,fhma,shma,series;
   static uint fbegin,sbegin;

//----    first    
   if(prev_calculated==0) //      
     {
      first=begin; //      
      int minbar=min_rates_total+begin;  
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,minbar);
      for(bar=0; bar<=minbar; bar++) IndBuffer[bar]=0;
      fbegin=FastHMA+1+begin;
      sbegin=SlowHMA+1+begin;
     }
   else first=prev_calculated-1; //      

//----    CMoving_Average   HMASeries_Cls.mqh
   static CMoving_Average MA1,MA2,MA3,MA4,MA5,MA6;

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      series=price[bar];

      lwma1=MA1.LWMASeries(begin,prev_calculated,rates_total,fHma2_Period,series,bar,false);
      lwma2=MA2.LWMASeries(begin,prev_calculated,rates_total,FastHMA,series,bar,false);
      fhma=MA3.LWMASeries(fbegin,prev_calculated,rates_total,fSqrt_Period,2*lwma1-lwma2,bar,false);
      //----
      lwma1=MA4.LWMASeries(begin,prev_calculated,rates_total,sHma2_Period,series,bar,false);
      lwma2=MA5.LWMASeries(begin,prev_calculated,rates_total,SlowHMA,series,bar,false);
      shma=MA6.LWMASeries(sbegin,prev_calculated,rates_total,sSqrt_Period,2*lwma1-lwma2,bar,false);
      //----
      IndBuffer[bar]=fhma-shma;
     }

   if(prev_calculated>rates_total || prev_calculated<=0) first++;
//----     Ind
   for(bar=first; bar<rates_total; bar++)
     {
      ColorIndBuffer[bar]=0;

      if(IndBuffer[bar]>0)
        {
         if(IndBuffer[bar]>IndBuffer[bar-1]) ColorIndBuffer[bar]=1;
         if(IndBuffer[bar]<IndBuffer[bar-1]) ColorIndBuffer[bar]=2;
        }

      if(IndBuffer[bar]<0)
        {
         if(IndBuffer[bar]<IndBuffer[bar-1]) ColorIndBuffer[bar]=3;
         if(IndBuffer[bar]>IndBuffer[bar-1]) ColorIndBuffer[bar]=4;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
