//+------------------------------------------------------------------+
//|                                            PriceDistribution.mq5 |
//|                              Copyright  2012, Khlystov Vladimir |
//|                                         http://cmillion.narod.ru |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2012, cmillion@narod.ru"
//----    
#property link      "http://cmillion.narod.ru"
#property description "          "
//----     
#property indicator_chart_window 
//----      
#property indicator_buffers 2
//----         
#property indicator_plots   0

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="PriceDistribution";//    
input uint iPeriod=3000;                  //  
input int  Shift=-300;                    //    
input double Dev=1.0;                     //  
input color PrColor=clrDodgerBlue;        //  
//+----------------------------------------------+
//---      
int min_rates_total, iperiod;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----    
   min_rates_total=int(iPeriod);
   iperiod=int(iPeriod);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="PriceDistribution";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectsDeleteAll(0,SirName,-1,OBJ_TREND);
   Comment("");
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----    
   int to_copy,Pr,limit;
   double max,min,P;
   string txt,name;   

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1;
     }
   else
     {
      limit=rates_total-prev_calculated;
     }
   if(!limit) return(rates_total);
   to_copy=limit+1;
      
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(time,true);
//----     
   datetime TimeSt = time[0]+PeriodSeconds()*Shift;
//----   
   max=high[ArrayMaximum(high,0,iperiod)];
   min=low[ArrayMinimum(low,0,iperiod)];
   iperiod=MathMin(iperiod,rates_total-1);
   txt="";
   StringConcatenate(txt,"   ",iperiod,"  ",TimeToString(time[iperiod],TIME_DATE),
                         "\n ",DoubleToString(max,_Digits),"\n ",DoubleToString(min,_Digits));
   Comment(txt,"\n","  ",TimeToString(TimeCurrent(),TIME_DATE|TIME_SECONDS));

   Pr=int((max-min)/_Point);
   double Price[];
   ArrayResize(Price,Pr);
   ArrayInitialize(Price,0);
   for(int bar=1; bar<=int(iperiod); bar++)
     {
      for(int kkk=0; kkk<Pr; kkk++)
        {
         P=NormalizeDouble(min+kkk*_Point,_Digits);
         if(P>=low[bar] && P<=high[bar]) Price[kkk]++;
        }
     }
     
   for(int rrr=0; rrr<Pr; rrr++)
     {
      P=NormalizeDouble(min+rrr*_Point,_Digits);
      name="";
      StringConcatenate(name,SirName," ",P);
      SetTline(0,name,0,TimeSt,P,datetime(TimeSt+Price[rrr]*Dev*PeriodSeconds()),P,PrColor,0,3);
     }
//----     
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTline(
                 long     chart_id,      //  
                 string   name,          //  
                 int      nwin,          //  
                 datetime time1,         //  1  
                 double   price1,        // 1  
                 datetime time2,         //  2  
                 double   price2,        // 2  
                 color    Color,         //  
                 int      style,         //  
                 int      width          //  
                 )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_TREND,nwin,time1,price1,time2,price2);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_RAY_RIGHT,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTED,false);
   ObjectSetInteger(chart_id,name,OBJPROP_SELECTABLE,false);
   ObjectSetInteger(chart_id,name,OBJPROP_ZORDER,true);
//----
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTline(
              long     chart_id,      //  
              string   name,          //  
              int      nwin,          //  
              datetime time1,         //  1  
              double   price1,        // 1  
              datetime time2,         //  2  
              double   price2,        // 2  
              color    Color,         //  
              int      style,         //  
              int      width          //  
              )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateTline(chart_id,name,nwin,time1,price1,time2,price2,Color,style,width);
   else
     {
      ObjectMove(chart_id,name,0,time1,price1);
      ObjectMove(chart_id,name,1,time2,price2);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
      ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
      ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
     }
//----
  }
//+------------------------------------------------------------------+
