//+------------------------------------------------------------------+
//|                                     BreakEven & TrailingStop.mq4 |
//|                        Copyright 2016, MetaQuotes Software Corp. |
//|                                   https://M2P_Design@hotmail.com |
//+------------------------------------------------------------------+
#property library
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "https://M2P_Design@hotmail.com"
#property version   "1.00"
#property strict

input double        Magic = 280456;
input double    Breakeven = 30;
input double Trailingstop = 50;
//+------------------------------------------------------------------+
//| My BreakEven                                                     |
//+------------------------------------------------------------------+
void BreakEven()
  {
   double MyPoint=Point;
   if(Digits==3 || Digits==5) MyPoint=Point*10;

   for(int i=OrdersTotal()-1; i>=0;i--)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
         if(OrderSymbol()==Symbol())
            if(OrderMagicNumber()==Magic)
               if(OrderType()==OP_BUY)
                 {
                  if(Bid-OrderOpenPrice()>Breakeven*MyPoint)
                     if(OrderOpenPrice()>OrderStopLoss())
                        int BBM=OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice(),OrderTakeProfit(),0,clrNONE);
                 }

      else if(OrderType()==OP_SELL)
        {
         if(OrderOpenPrice()-Ask>Breakeven*MyPoint)
            if(OrderOpenPrice()<OrderStopLoss())
               int BSM=OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice(),OrderTakeProfit(),0,clrNONE);
        }
     }
  }
//+------------------------------------------------------------------+
//| My TrailingStop                                                  |
//+------------------------------------------------------------------+
void TrailingStop()
  {
   double MyPoint=Point;
   if(Digits==3 || Digits==5) MyPoint=Point*10;

   for(int i=OrdersTotal()-1; i>=0;i--)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
         if(OrderSymbol()==Symbol())
            if(OrderMagicNumber()==Magic)
               if(OrderType()==OP_BUY)
                 {
                  if(Bid-OrderOpenPrice()>Trailingstop*MyPoint)
                     if(OrderStopLoss()<Bid-Trailingstop*MyPoint)
                        int TBM=OrderModify(OrderTicket(),OrderOpenPrice(),Bid-(Trailingstop*MyPoint),OrderTakeProfit(),0,clrNONE);
                 }

      else if(OrderType()==OP_SELL)
        {
         if(OrderOpenPrice()-Ask>Trailingstop*MyPoint)
            if(OrderStopLoss()>Ask+Trailingstop*MyPoint)
               int TSM=OrderModify(OrderTicket(),OrderOpenPrice(),Ask+(Trailingstop*MyPoint),OrderTakeProfit(),0,clrNONE);
        }
     }
  }
//+------------------------------------------------------------------+
