//+------------------------------------------------------------------+
//|                                                 StopLossCalc.mq4 |
//|                        Copyright 2016, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property library
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict

input    int      StopLoss = 0;
input string        ATRexp = "this function to calculate stoploss depend on iATR";
input   bool           ATR = false;
input    int ATRMultiplier = 3;
//+------------------------------------------------------------------+
//| StopLoss Calculations                                            |
//+------------------------------------------------------------------+
double StpLoss(int i)
  {
   double SL=0;
   if(StopLoss==0 && !ATR) SL=0;
   else if(StopLoss>0 && !ATR)
     {
      double MyPoint=Point;
      if(Digits==3 || Digits==5) MyPoint=Point*10;
      if(i==0) SL=Ask-(StopLoss*MyPoint);
      if(i==1) SL=Bid+(StopLoss*MyPoint);
     }
   else if(ATR)
     {
      double AvTR=iATR(Symbol(),30,14,0);
      if(i==0) SL=Ask-(ATRMultiplier*AvTR);
      if(i==1) SL=Bid+(ATRMultiplier*AvTR);
     }
   return(SL);
  }
//+------------------------------------------------------------------+
// for market excuting orders Buy(i=0)-->(StpLoss(0)) / Sell(i=1)-->(StpLoss(1))
// OR for OrderModify() you can put StopLoss= StpLoss(OrderType())
