//+---------------------------------------------------------------------+
//|                                                     XXRSX_StDev.mq5 | 
//|                                Copyright  2011,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
#property description "Relative Strength Index"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrLimeGreen,clrDeepPink
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "XXRSX"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrMagenta
//----    2  3
#property indicator_width2  3
//----    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----        
#property indicator_color3  clrAqua
//----    3  3
#property indicator_width3  3
//----    
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1       -50.0
#property indicator_level2        50.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT

//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA UPXRSX,DNXRSX,XSIGN;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price 
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -    SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method DSmoothMethod=MODE_JJMA; //  
input uint DPeriod=15;  // 
input int DPhase=100;   //  ,
                       //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method SSmoothMethod=MODE_JurX; //   
input uint SPeriod=7;  //  
input int SPhase=100;   //  ,
                       //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_; // 
input double dK=1.5;  //   
input uint std_period=9; //  
input int Shift=0; //     
//+----------------------------------------------+

//----   ,    
//      
double XXRSX[],ColorXXRSX[];
double BearsBuffer[],BullsBuffer[];

double dXXRSX[];
//----      
int min_rates_total,StartBarsD,StartBarsS;
//+------------------------------------------------------------------+   
//| XRSX indicator initialization function                           | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   StartBarsD=UPXRSX.GetStartBars(DSmoothMethod,DPeriod,DPhase)+1;
   StartBarsS=StartBarsD+UPXRSX.GetStartBars(SSmoothMethod,SPeriod,SPhase);
   min_rates_total=StartBarsS+1+int(std_period);

//----       
   UPXRSX.XMALengthCheck("DPeriod", DPeriod);
   UPXRSX.XMALengthCheck("SPeriod", SPeriod);
//----       
   UPXRSX.XMAPhaseCheck("DPhase",DPhase,DSmoothMethod);
   UPXRSX.XMAPhaseCheck("SPhase",SPhase,SSmoothMethod);
   
//----       
   ArrayResize(dXXRSX,std_period);

//----      
   SetIndexBuffer(0,XXRSX,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(1,ColorXXRSX,INDICATOR_COLOR_INDEX);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//----    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//----      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   string shortname,Smooth;
   Smooth=UPXRSX.GetString_MA_Method(DSmoothMethod);
   StringConcatenate(shortname,"Relative Strength Index(",string(DPeriod),",",Smooth,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| XRSX iteration function                                          | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double dprice_,absdprice_,up_xrsx,dn_xrsx,xrsx,xxrsx;
   double SMAdif,Sum,StDev,dstd,BEARS,BULLS,Filter;
//----        
   int first1,first2,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first1=1; //      
      first2=min_rates_total+1;
     }
   else
     {
      first1=prev_calculated-1; //      
      first2=first1;
     }

//----    
   for(bar=first1; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries      dprice_
      dprice_=PriceSeries(IPC,bar,open,low,high,close)-PriceSeries(IPC,bar-1,open,low,high,close);
      absdprice_=MathAbs(dprice_);

      //----    XMASeries.  
      up_xrsx = UPXRSX.XMASeries(1, prev_calculated, rates_total, DSmoothMethod, DPhase, DPeriod,    dprice_, bar, false);
      dn_xrsx = DNXRSX.XMASeries(1, prev_calculated, rates_total, DSmoothMethod, DPhase, DPeriod, absdprice_, bar, false);

      //----       
      if(dn_xrsx==0) xrsx=EMPTY_VALUE;
      else
        {
         xrsx=up_xrsx/dn_xrsx;

         //----      
         if(xrsx > +1)xrsx = +1;
         if(xrsx < -1)xrsx = -1;
        }

      //----      
      xrsx*=100;
      xxrsx=XSIGN.XMASeries(StartBarsD,prev_calculated,rates_total,SSmoothMethod,SPhase,SPeriod,xrsx,bar,false);

      //----      
      XXRSX[bar]=xxrsx;
     }

//----    
   for(bar=first2; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=0;
      if(XXRSX[bar]>XXRSX[bar-1]) clr=1;
      if(XXRSX[bar]<XXRSX[bar-1]) clr=2;
      ColorXXRSX[bar]=clr;
     }
     
//----      
   for(bar=first2; bar<rates_total && !IsStopped(); bar++)
     {
      //----        
      for(int iii=0; iii<int(std_period); iii++) dXXRSX[iii]=XXRSX[bar-iii]-XXRSX[bar-iii-1];

      //----     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dXXRSX[iii];
      SMAdif=Sum/std_period;

      //----       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dXXRSX[iii]-SMAdif,2);

      //----      StDev   
      StDev=MathSqrt(Sum/std_period);

      //----  
      dstd=NormalizeDouble(dXXRSX[0],_Digits+2);
      Filter=NormalizeDouble(dK*StDev,_Digits+2);
      BEARS=EMPTY_VALUE;
      BULLS=EMPTY_VALUE;

      //----   
      if(dstd<-Filter) BEARS=XXRSX[bar]; //  
      if(dstd>+Filter) BULLS=XXRSX[bar]; //  

      //----       
      BullsBuffer[bar]=BULLS;
      BearsBuffer[bar]=BEARS;
     }     
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
