//+------------------------------------------------------------------+ 
//|                                           XMA_BBx7_Cloud_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    11
#property indicator_buffers 11 
//----     
#property indicator_plots   6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                       //        
#define INDICATOR_NAME "XMA_BBx7_Cloud"               //    
#define SIZE 11                                       //      CountLine
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrDeepSkyBlue
//----   
#property indicator_label1  "Upper Sigma3 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type2   DRAW_FILLING
//----     
#property indicator_color2  clrLime
//----   
#property indicator_label2  "Upper Sigma2 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type3   DRAW_FILLING
//----     
#property indicator_color3  clrLavender
//----   
#property indicator_label3  "Sigma1 Cloud"
//+----------------------------------------------+
//|                     |
//+----------------------------------------------+
//----     
#property indicator_type4   DRAW_LINE
//----       - 
#property indicator_color4 clrBlueViolet
//----   - 
#property indicator_style4  STYLE_SOLID
//----     2
#property indicator_width4  2
//----   
#property indicator_label4  "XMA"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type5   DRAW_FILLING
//----     
#property indicator_color5  clrHotPink
//----   
#property indicator_label5  "Lower Sigma2 Cloud"
//+----------------------------------------------+
//|                      |
//+----------------------------------------------+
//----      
#property indicator_type6   DRAW_FILLING
//----     
#property indicator_color6  clrMagenta
//----   
#property indicator_label6  "Lower Sigma3 Cloud"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;//  
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint XLength=100; //                       
input int XPhase=15; //   
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double BandsDeviation1=2.0; //  1
input double BandsDeviation2=3.0; //  2
input double BandsDeviation3=4.0; //  3
input Applied_price_ IPC=PRICE_CLOSE;//  
input int Shift=0; //      
input int PriceShift=0; //      
//----   
input color  Middle_color=clrBlue;
input color  Upper_color1=clrMediumSeaGreen;
input color  Lower_color1=clrRed;
input color  Upper_color2=clrDodgerBlue;
input color  Lower_color2=clrMagenta;
input color  Upper_color3=clrBlue;
input color  Lower_color3=clrOrange;
//+----------------------------------------------+
//----   ,    
//      
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[],ExtLineBuffer5[];
double ExtLineBuffer6[],ExtLineBuffer7[],ExtLineBuffer8[],ExtLineBuffer9[],ExtLineBuffer10[],ExtLineBuffer11[];
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    XMA_BBx7_Cloud       ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    XMA_BBx7_Cloud
   Ind_Handle=iCustom(Symbol_,TimeFrame,"XMA_BBx7_Cloud",XMA_Method,XLength,XPhase,BandsDeviation1,BandsDeviation2,BandsDeviation3,IPC,
                      0,PriceShift,Middle_color,Upper_color1,Lower_color1,Upper_color2,Lower_color2,Upper_color3,Lower_color3);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      XMA_BBx7_Cloud");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
   SetIndexBuffer(5,ExtLineBuffer6,INDICATOR_DATA);
   SetIndexBuffer(6,ExtLineBuffer7,INDICATOR_DATA);
   SetIndexBuffer(7,ExtLineBuffer8,INDICATOR_DATA);
   SetIndexBuffer(8,ExtLineBuffer9,INDICATOR_DATA);
   SetIndexBuffer(9,ExtLineBuffer10,INDICATOR_DATA);
   SetIndexBuffer(10,ExtLineBuffer11,INDICATOR_DATA);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);
   ArraySetAsSeries(ExtLineBuffer5,true);
   ArraySetAsSeries(ExtLineBuffer6,true);
   ArraySetAsSeries(ExtLineBuffer7,true);
   ArraySetAsSeries(ExtLineBuffer8,true);
   ArraySetAsSeries(ExtLineBuffer9,true);
   ArraySetAsSeries(ExtLineBuffer10,true);
   ArraySetAsSeries(ExtLineBuffer11,true);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---         
   ArraySetAsSeries(time,true);
//---    
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,ExtLineBuffer1,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,1,ExtLineBuffer2,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,2,ExtLineBuffer3,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(3,NULL,TimeFrame,Ind_Handle,3,ExtLineBuffer4,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(4,NULL,TimeFrame,Ind_Handle,4,ExtLineBuffer5,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(5,NULL,TimeFrame,Ind_Handle,5,ExtLineBuffer6,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(6,NULL,TimeFrame,Ind_Handle,6,ExtLineBuffer7,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(7,NULL,TimeFrame,Ind_Handle,7,ExtLineBuffer8,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(8,NULL,TimeFrame,Ind_Handle,8,ExtLineBuffer9,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(9,NULL,TimeFrame,Ind_Handle,9,ExtLineBuffer10,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(10,NULL,TimeFrame,Ind_Handle,10,ExtLineBuffer11,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
