//+------------------------------------------------------------------+
//|                                          MA_Rounding_Channel.mq5 | 
//|                   Copyright  2011, BACKSPACE + Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, BACKSPACE + Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    3
#property indicator_buffers 3 
//----     
#property indicator_plots   3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DarkViolet 
#property indicator_color1 clrDarkViolet
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "MA Rounding"
//+----------------------------------------------+
//|                |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----         
#property indicator_color2  clrDodgerBlue
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "Up MA Rounding"
//+----------------------------------------------+
//|                 |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----         
#property indicator_color3  clrRed
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  1
#property indicator_width3 1 
//----    
#property indicator_label3  "Down MA Rounding"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price 
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input int XLength=12; //  
input int XPhase=15;  //  
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE; //  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input uint MaRound=50; //  
input int    ATRPeriod=12; //  ATR   
input double ATR_Factor=1.0; //   
input bool  ChanContinuity=false; //  
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double UpBuffer[];
double DnBuffer[];
double IndBuffer[];
//----     
double MaRo;
//----      
int ATR_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| XMA indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=XMA1.GetStartBars(XMA_Method,XLength,XPhase)+2;
//----       
   XMA1.XMALengthCheck("XLength", XLength);
   XMA1.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
//----    
   MaRo=_Point*MaRound;
//----    ATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)Print("      ATR");
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----      
   SetIndexBuffer(1,UpBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,167);

//----      
   SetIndexBuffer(2,DnBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,167);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"MA Rounding(",XLength,", ",MaRound,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| XMA iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double price_,MovAve0,MovAle0,res0,res1,Range[],range0;
//----   
   int to_copy,first,bar;
//----     
   static double MovAle1,MovAve1,range1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=2; //      
      MovAve1=PriceSeries(IPC,first,open,low,high,close);
      MovAle1=0;
      range1=0;
     }
   else first=prev_calculated-1; //      
//----   
   range0=range1;
//----
   to_copy=rates_total-first;
//----       Range[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);
//----         
   ArraySetAsSeries(Range,true);
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----
      MovAve0=XMA1.XMASeries(2,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price_,bar,false);
      //----
      res1=IndBuffer[bar-1];
      //----
      if(MovAve0>MovAve1+MaRo
         || MovAve0<MovAve1-MaRo
         || MovAve0>res1+MaRo
         || MovAve0<res1-MaRo
         || (MovAve0>res1 && MovAle1==+1)
         || (MovAve0<res1 && MovAle1==-1))
         IndBuffer[bar]=MovAve0;
      else IndBuffer[bar]=res1;
      //----
      MovAle0=0;
      res0=IndBuffer[bar];
      if(res0<res1) MovAle0 =-1;
      if(res0>res1) MovAle0 =+1;
      if(res0==res1) MovAle0=MovAle1;
      //----    
      UpBuffer[bar]=0.0;
      DnBuffer[bar]=0.0;
      //----  
      if(res0==res1)
        {
         if(res1!=IndBuffer[bar-2]) range0=Range[rates_total-bar-1]*ATR_Factor;
         else range0=range1;

         UpBuffer[bar]=res0+range0;
         DnBuffer[bar]=res0-range0;
        }
      else if(ChanContinuity)
        {
         UpBuffer[bar]=UpBuffer[bar-1];
         DnBuffer[bar]=DnBuffer[bar-1];
        }
      //---       
      if(bar<rates_total-1)
        {
         MovAle1=MovAle0;
         MovAve1=MovAve0;
         range1=range0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
