/*
 *  <<    >>
 *
 *         
 * SmoothAlgorithms.mqh
 *   (): MetaTrader\\MQL5\Include
 *
 *       :
 *
 * 1)    CMO -  /. 
 *  -   +70  ,    +30  .
 * 2)  .  -   CMO    CMO 
 * ,  - ,   CMO    CMO  .
 */
//+------------------------------------------------------------------+
//|                                  Chande Momentum Oscillator_.mq5 |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrGold
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "CMO"
//----    
#property indicator_level1  +50
#property indicator_level2    0
#property indicator_level3  -50
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int CMO_period= 9; //  CMO
input Applied_price_ IPC=PRICE_CLOSE_;//  
input int CMO_Shift = 0; //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtLineBuffer[];
//+------------------------------------------------------------------+
//|   CCMO                                             |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----     
   PlotIndexSetInteger(0,PLOT_SHIFT,CMO_Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,CMO_period);
//----      
   string shortname;
   StringConcatenate(shortname,"CMO(",CMO_period,")");
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,shortname);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<CMO_period+1) return(0);
//----    
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else
     {
      first=prev_calculated-1; //      
     }
//----    CCMO
   static CCMO CMO;
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
      ExtLineBuffer[bar]=CMO.CMOSeries(0,prev_calculated,rates_total,CMO_period,PriceSeries(IPC,bar,open,low,high,close),bar,false)*200-100;
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
