#property copyright "Scriptong"
#property link      "http://advancetools.net"

#property strict

#include <WinUser32.mqh>
#import "user32.dll"
	int RegisterWindowMessageW(string lpString); 
#import


//   
enum ENUM_CONVERT_TYPE
{
   CONVERT_TYPE_TF,                                                                                //   
   CONVERT_TYPE_POINT,                                                                             //   
   CONVERT_TYPE_VOLUME                                                                             //  
};

enum ENUM_BID_ASK_TYPE
{
   BID_ASK_TYPE_ONLY_BID,                                                                          // By Bid /  Bid   
   BID_ASK_TYPE_ONLY_ASK,                                                                          // By Ask /  Ask
   BID_ASK_TYPE_ONLY_BID_HIGH_ASK_LOW,                                                             // Close - max Bid, Open - min Ask
   BID_ASK_TYPE_ONLY_BID_LOW_ASK_HIGH                                                              // Close - max Ask, Open - min Bid   
};

struct TickStruct
{
   datetime time;
   double   bid;
   double   ask;  
   
   TickStruct(datetime dtTime = 0, double dBid = 0.0, double dAsk = 0.0)
   {
      time = dtTime;
      bid = dBid;
      ask = dAsk;
   } 
};

//      .    TicksCollector.
class NonStandartTFChart
{
   bool              m_isActive;                                                                   //   ?
   int               m_tfNameInMinutes;                                                            //  ,   . , 313 -  EURUSD, M313
   int               m_chartProperty;                                                              //  . ,    -    ,  ..
                                                                                                   // ..  -  ,     - ..
                                                                                                   // ..  
   int               m_digits;                                                                     //         
   int               m_ratesSize;                                                                  //   MqlRates
   int               m_mt4Message;                                                                 //    
   
   double            m_point;                                                                      //     
   
   string            m_symbol;                                                                     //  
   
   ENUM_CONVERT_TYPE m_convertType;                                                                //  
   ENUM_BID_ASK_TYPE m_bidAskType;                                                                 //    
   
   
   int               m_fileHandle;                                                                 //   ,     
   int               m_hWindow;                                                                    //  ,     
   
   MqlRates          m_rates;                                                                      //    

   
public:
                     NonStandartTFChart(bool isActive, int tfNameInMinutes, int chartProperty, ENUM_CONVERT_TYPE convertType, ENUM_BID_ASK_TYPE bidAskType, int digits, double point, string symbol);
                    ~NonStandartTFChart(void);
   bool              CreateHistoryFile(void);      
   void              CloseFile(void);       
   bool              ConvertData(const TickStruct &tick, bool doFlush);   
   void              SetPointerToEndOfFile(void) const;
   void              UpdateChart(void);  
                    
private:
   void              CreateNewRatesHighLow(const TickStruct &tick);
   void              CreateRatesHighLow(const TickStruct &tick);
   bool              IsNewBarByConvertType(datetime &time) const;
   bool              IsFindChart(void);
};


//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                                        |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
NonStandartTFChart::NonStandartTFChart(bool isActive, int tfNameInMinutes, int chartProperty, ENUM_CONVERT_TYPE convertType, ENUM_BID_ASK_TYPE bidAskType, int digits, double point, string symbol) :        
                                                                                                       m_isActive(isActive)
                                                                                                      ,m_tfNameInMinutes(tfNameInMinutes)
                                                                                                      ,m_chartProperty(chartProperty)
                                                                                                      ,m_convertType(convertType)
                                                                                                      ,m_bidAskType(bidAskType)
                                                                                                      ,m_digits(digits)
                                                                                                      ,m_point(point)
                                                                                                      ,m_symbol(symbol)
                                                                                                      ,m_fileHandle(-1)
                                                                                                      ,m_hWindow(NULL)
{
   ZeroMemory(m_rates);
   m_ratesSize = sizeof(MqlRates);
   if (IsDllsAllowed())
      m_mt4Message = RegisterWindowMessageW("MetaTrader4_Internal_Message");
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                                         |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
NonStandartTFChart::~NonStandartTFChart(void)
{
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                               |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool NonStandartTFChart::CreateHistoryFile(void)
{
   if (!m_isActive)
      return true;

   //  
   string fileName = m_symbol + IntegerToString(m_tfNameInMinutes) + ".hst";
   m_fileHandle = FileOpenHistory(fileName, FILE_BIN | FILE_WRITE | FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_ANSI);
   if (m_fileHandle < 0)
   {
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(WindowExpertName(), ":     ", fileName, ".  .");
      else
         Alert(WindowExpertName(), ": unable to open the file ", fileName, ". Indicator is off.");
      
      m_isActive = false;
      return false;                                
   }
   
   //  
   string   copyright="(C)opyright 2003, MetaQuotes Software Corp.";
   int      unused[13] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

   FileWriteInteger(m_fileHandle, 401, LONG_VALUE);
   FileWriteString(m_fileHandle, copyright, 64);
   FileWriteString(m_fileHandle, m_symbol, 12);
   FileWriteInteger(m_fileHandle, m_tfNameInMinutes, LONG_VALUE);
   FileWriteInteger(m_fileHandle, m_digits, LONG_VALUE);
   FileWriteInteger(m_fileHandle, 0, LONG_VALUE);
   FileWriteInteger(m_fileHandle, 0, LONG_VALUE);
   FileWriteArray(m_fileHandle, unused, 0, 13);

   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                               |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void NonStandartTFChart::CloseFile(void)
{
   if (!m_isActive)
      return;
      
   if (m_fileHandle < 0)
      return;
      
   FileClose(m_fileHandle);
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                   |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool NonStandartTFChart::ConvertData(const TickStruct &tick, bool doFlush)
{
   if (!m_isActive)
      return true;

   //    
   double price = (m_bidAskType == BID_ASK_TYPE_ONLY_ASK || m_bidAskType == BID_ASK_TYPE_ONLY_BID_LOW_ASK_HIGH)? tick.ask : tick.bid;
   CreateRatesHighLow(tick);
   m_rates.tick_volume++;

   //   
   datetime time = tick.time;
   if (m_rates.time == 0 || IsNewBarByConvertType(time))
   {
      CreateNewRatesHighLow(tick);
      if ((int)(time - m_rates.time) < 60)                                                         //           ,   1- 
         time = m_rates.time + 60;                                                                 //         
      m_rates.time = time;
   }
   //   
   else
      FileSeek(m_fileHandle, -m_ratesSize, SEEK_CUR);
   
   //    
   if (FileWriteStruct(m_fileHandle, m_rates) != m_ratesSize)
   {
      if (TerminalInfoString(TERMINAL_LANGUAGE) == "Russian")
         Alert(WindowExpertName(), ":      .  .");
      else
         Alert(WindowExpertName(), ": unable to write to the history file. Indicator is off.");
      return false;
   }
   
   if (doFlush)
      FileFlush(m_fileHandle);
      
   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                            |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool NonStandartTFChart::IsNewBarByConvertType(datetime &time) const
{
   switch (m_convertType)
   {
      case CONVERT_TYPE_TF:      if (time < m_rates.time + m_chartProperty)
                                    return false;
                                    
                                 time = time / m_chartProperty * m_chartProperty;
                                 return true;
                                 
      case CONVERT_TYPE_POINT:   return m_rates.high - m_rates.low - m_chartProperty * m_point > m_point * 0.9;
      case CONVERT_TYPE_VOLUME:  return m_rates.tick_volume > m_chartProperty;
   }
   
   return false;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                          |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void NonStandartTFChart::CreateNewRatesHighLow(const TickStruct &tick)
{
   switch(m_bidAskType)
   {
      case BID_ASK_TYPE_ONLY_BID:                  m_rates.open = tick.bid;
                                                   m_rates.close = tick.bid;
                                                   m_rates.high = tick.bid;
                                                   m_rates.low = tick.bid;
                                                   m_rates.tick_volume = 1;
                                                   break;

      case BID_ASK_TYPE_ONLY_ASK:                  m_rates.open = tick.ask;
                                                   m_rates.close = tick.ask;
                                                   m_rates.high = tick.ask;
                                                   m_rates.low = tick.ask;
                                                   m_rates.tick_volume = 1;
                                                   break;

      case BID_ASK_TYPE_ONLY_BID_HIGH_ASK_LOW:     m_rates.open = tick.ask;
                                                   m_rates.close = tick.bid;
                                                   m_rates.high = MathMax(m_rates.close, m_rates.open);
                                                   m_rates.low = MathMin(m_rates.close, m_rates.open);
                                                   m_rates.tick_volume = 2;
                                                   break;

      case BID_ASK_TYPE_ONLY_BID_LOW_ASK_HIGH:     m_rates.open = tick.bid;
                                                   m_rates.close = tick.ask;
                                                   m_rates.high = MathMax(m_rates.close, m_rates.open);
                                                   m_rates.low = MathMin(m_rates.close, m_rates.open);
                                                   m_rates.tick_volume = 2;
                                                   break;
   }
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|  Bid  Ask                                                                                                                                 |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void NonStandartTFChart::CreateRatesHighLow(const TickStruct &tick)
{
   switch(m_bidAskType)
   {
      case BID_ASK_TYPE_ONLY_BID:                  m_rates.high = MathMax(m_rates.high, tick.bid);
                                                   m_rates.low = MathMin(m_rates.low, tick.bid);
                                                   m_rates.close = tick.bid;
                                                   break;

      case BID_ASK_TYPE_ONLY_ASK:                  m_rates.high = MathMax(m_rates.high, tick.ask);
                                                   m_rates.low = MathMin(m_rates.low, tick.ask);
                                                   m_rates.close = tick.ask;
                                                   break;

      case BID_ASK_TYPE_ONLY_BID_HIGH_ASK_LOW:     m_rates.open = MathMin(m_rates.open, tick.ask);
                                                   m_rates.close = MathMax(m_rates.close, tick.bid);
                                                   m_rates.high = MathMax(m_rates.close, m_rates.open);
                                                   m_rates.low = MathMin(m_rates.close, m_rates.open);
                                                   break;

      case BID_ASK_TYPE_ONLY_BID_LOW_ASK_HIGH:     m_rates.open = MathMin(m_rates.open, tick.bid);
                                                   m_rates.close = MathMax(m_rates.close, tick.ask);
                                                   m_rates.high = MathMax(m_rates.close, m_rates.open);
                                                   m_rates.low = MathMin(m_rates.close, m_rates.open);
                                                   break;
   }
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|  ,                                                                                                                                              |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void NonStandartTFChart::UpdateChart(void)
{
   if (!IsFindChart())
      return;

   PostMessageW(m_hWindow, WM_COMMAND, 33324, 0);
   if (m_mt4Message > 0)
      SendMessageW(m_hWindow, m_mt4Message, 2, 1);
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|                                                                                                                                                                  |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
bool NonStandartTFChart::IsFindChart(void)
{
   if (m_hWindow > 0)
      return true;
      
   m_hWindow = WindowHandle(m_symbol, m_tfNameInMinutes);
   if (m_hWindow <= 0)
      return false;
      
   Print("Chart window detected: ", m_symbol, ", M", m_tfNameInMinutes);
   return true;
}
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
//|   /                                                                                                                                                |
//+---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
void NonStandartTFChart::SetPointerToEndOfFile(void) const
{
   if (!m_isActive)
      return;
      
   if (m_fileHandle < 0)
      return;
      
   FileFlush(m_fileHandle);   
   FileSeek(m_fileHandle, 0, SEEK_END);
}


