//+------------------------------------------------------------------+
//|                                            GRFLeadingEdgeMov.mq5 | 
//|                                  Copyright  2007, GammaRatForex | 
//|                                   http://www.gammarat.com/Forex/ | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, GammaRatForex"
#property link "http://www.gammarat.com/Forex/"
/*
 * LSQ line fitting to the a number of samples.
 * The trendline is the leading point in the fit;
 * the bands are calculated somewhat differently, check the math below and adapt to 
 * your own needs as appropriate
 * also the point estimate is given by the geometric mean
 * MathPow(HCCC,.025) (see function "get_avg" below) rather than 
 * more standard estimates.
 * It's computationally fairly intensive
 */
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    1
#property indicator_buffers 1 
//----   1  
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DeepPink 
#property indicator_color1 clrDeepPink
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint Samples=12;
input int  LookAhead=0;
input int Shift=0; //      
input int PriceShift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double LeadingEdgeBuffer[];
//----       
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(Samples);
//----    
   dPriceShift=_Point*PriceShift;
//----      
   SetIndexBuffer(0,LeadingEdgeBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"LeadingEdge Trend");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"LeadingEdge Trend");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----     
   double c0,c1,alpha,beta,b[2][2];
   static double base_det,a[2][2];
//----   
   int first,bar,kkk;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_total; //      
      ArrayInitialize(a,0);
      for(int iii=0; iii<int(Samples); iii++)
        {
         a[0][0]+=iii*iii;
         a[0][1]+=iii;
         a[1][0]+=iii;
         a[1][1]++;
        }
      //----
      base_det=det2(a);
     }
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      c0=0;
      c1=0;
      for(kkk=0; kkk<int(Samples); kkk++)
        {
         double res=get_avg(bar-kkk,high,low,close);
         c0+=kkk*res;
         c1+=res;
        }
      //----
      ArrayCopy(b,a);
      b[0][0]=c0;
      b[1][0]=c1;
      alpha=det2(b)/base_det;
      //----
      ArrayCopy(b,a);
      b[0][1]=c0;
      b[1][1]=c1;
      beta=det2(b)/base_det;
      //----
      LeadingEdgeBuffer[bar]=(beta-alpha*LookAhead)*_Point+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double get_avg(int index,const double &High[],const double &Low[],const double &Close[])
  {
//----
   return(MathPow((High[index]*Low[index]*Close[index]*Close[index]),1/4.0)/_Point);
  }
//+------------------------------------------------------------------+
//| Point and figure                                                 |
//+------------------------------------------------------------------+       
double det2(double &a[][2])
  {
//----
   return(a[0][0]*a[1][1]-a[1][0]*a[0][1]);
  }
//+------------------------------------------------------------------+
