//+---------------------------------------------------------------------+
//|                                                 ColorJFatlSpeed.mq5 | 
//|                                 Copyright  2010, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.11"
//----     
#property indicator_separate_window 
//----        
#property indicator_buffers 3
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       
#property indicator_color1  clrGray
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "JFATL SPEED"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_COLOR_ARROW
//----      ,    
#property indicator_color2  clrMagenta,clrGray,clrBlue
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "JFATL SPEED"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int JLength=8;   //  JMA  Fatl                   
input int JPhase=100;  //  JMA  Fatl
                       //    -100 ... +100,
                       //     
input int MomPeriod=1; //   Momentum   

input int Smooth=2;    //  JMA                    
input int SmPhase=100; //  JMA  
                       //    -100 ... +100,
                       //     
input Applied_price_ IPC=PRICE_CLOSE_; //  
input int FATLShift=0; //      
//+----------------------------------------------+
//----          FATL
int FATLPeriod=39;
//----   ,    
//----      
double IndBuffer[];
double ColorBuffer[];
double LineIndBuffer[];
//----
int start,fstart,jfstart,mstart,FATLSize;
double dPriceShift;
//+------------------------------------------------------------------+
//|   iPriceSeries()                                  |
//|   CFATL, CJJMA  CMomentum                        |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh>  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----  
   fstart=FATLPeriod;
   jfstart=fstart+30;
   mstart=jfstart+MomPeriod;
   start=mstart+30+1;
//----    IndBuffer   
   SetIndexBuffer(0,LineIndBuffer,INDICATOR_DATA);
//----       FATLShift
   PlotIndexSetInteger(0,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,start);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    IndBuffer   
   SetIndexBuffer(1,IndBuffer,INDICATOR_DATA);
//----       FATLShift
   PlotIndexSetInteger(1,PLOT_SHIFT,FATLShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,start);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----     ,     
   SetIndexBuffer(2,ColorBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,start);
//----      
   string shortname;
   StringConcatenate(shortname,"JFATL Speed(",JLength," ,",JPhase," ,",MomPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----    CJJMA   JJMASeries_Cls.mqh
   CJJMA JMA;
//----       
   JMA.JJMALengthCheck("JLength", JLength);
   JMA.JJMAPhaseCheck("JPhase", JPhase);
   JMA.JJMALengthCheck("MomPeriod", MomPeriod);
   JMA.JJMALengthCheck("Smooth", Smooth);
   JMA.JJMAPhaseCheck("SmPhase", SmPhase);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<start) return(0);
//----    
   int first,bar,clr;
   double price,jfatl,fatl,jmom,jfspeed;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else first=prev_calculated-1; //      
//----    CFATL, CJJMA  CMomentum   JJMASeries_Cls.mqh
   static CJJMA JMA1,JMA2;
   static CFATL FATL;
   static CMomentum MOM;
//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----    price
      price=PriceSeries(IPC,bar,open,low,high,close);
      //----    price  FATLSeries()   fatl
      fatl=FATL.FATLSeries(0,prev_calculated,rates_total,price,bar,false);
      //----  fatl  JJMASeries()   jfatl
      jfatl=JMA1.JJMASeries(fstart,prev_calculated,rates_total,0,JPhase,JLength,fatl,bar,false);
      //----  jfatl  MomentumSeries()   jmom
      jmom=MOM.MomentumSeries(jfstart,prev_calculated,rates_total,MomPeriod,jfatl,bar,false);
      //----  jmom  JJMASeries()   jfspeed
      jfspeed=JMA2.JJMASeries(mstart,prev_calculated,rates_total,0,SmPhase,Smooth,jmom,bar,false);
      //----      
      jfspeed/=_Point;
      //----  jfspeed   
      IndBuffer[bar]=jfspeed;
      LineIndBuffer[bar]=jfspeed;
     }
//----        
   if(prev_calculated>rates_total || prev_calculated<=0) first=start;
//----     
   for(bar=first; bar<rates_total; bar++)
     {
      clr=1;
      if(IndBuffer[bar]>IndBuffer[bar-1]) clr=2;
      if(IndBuffer[bar]<IndBuffer[bar-1]) clr=0;
      ColorBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
