//+------------------------------------------------------------------+
//|                                                  andleSizes.mq5 |
//|                                                         Tapochun |
//|                         https://login.mql5.com/ru/users/tapochun |
//+------------------------------------------------------------------+
#property copyright "Tapochun"
#property link      "https://login.mql5.com/ru/users/tapochun"
#property version   "1.00"
#property indicator_separate_window
//---
#property indicator_plots 2
#property indicator_buffers 3
#property indicator_minimum 0
//---
#property indicator_type1 DRAW_COLOR_HISTOGRAM
#property indicator_label1 "CandleSize"
//---
#property indicator_type2 DRAW_LINE
#property indicator_label2 "csAverage"
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
double bufSize[];               //  
double bufSizeClr[];            //  
double bufAverage[];            //   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_CONSTRUCTION_TYPE  //  
  {
   upper_shadows,            //  
   lower_shadows,            //  
   bodies                    // 
  };
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
input ENUM_CONSTRUCTION_TYPE inpType = upper_shadows;  //   
input color inpClr = clrLime;                          //  
input color inpNeutralClr=clrGray;                     //  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---  ..   2
   if(_Period>PERIOD_H2) //   > 2
     {
      Print(__FUNCTION__,": !        2");
      return(INIT_FAILED); //   
     }
//---   
   SetIndicatorParameters(inpType,inpClr,inpNeutralClr);
//---
   return( INIT_SUCCEEDED );
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---    
   if( rates_total <= 0 ) return( 0 );
//---
   static int dNum;                       //   
   static int dCount = 0;                 //      
   static int dSum=0;                     //       
//---
   if(prev_calculated!=0) //    
     {
      int n;                          //   
      if(rates_total>prev_calculated) //    
        {
         //---     
         bufSize[rates_total-1]=0.0;
         bufAverage[rates_total-1]=bufAverage[rates_total-2];
         //---
         n=rates_total-2;                  //   
         //---     
         Calculation_bar(inpType,n,dCount,dSum,time,high,low,open,close);
         //---    
         CheckNewDay(time[n+1],dNum,dCount,dSum);
        }
      else                                 //   
        {
         n=rates_total-1;                  //   
         //---     
         Calculation(inpType,n,dCount+1,dSum,time[n],high[n],low[n],open[n],close[n]);
        }
     }
   else                                    //   
     {
      //---     
      ArrayInitialize(bufSize,0.0);
      ArrayInitialize(bufAverage,0.0);
      //---       
      int first = GetFirstBar( time, rates_total, dNum );
      if( first == 0 ) return( 0 );
      //---    
      for(int i=first; i<rates_total-1; i++)
        {
         //---   ( )
         Calculation_bar(inpType,i,dCount,dSum,time,high,low,open,close);
         //---    
         CheckNewDay(time[i+1],dNum,dCount,dSum);
        }
     }
//---
   return( rates_total );
  }
//+------------------------------------------------------------------+
//|                                                |
//+------------------------------------------------------------------+
int GetCandleType(const double open,  //   
                  const double close) //   
  {
   if( open > close ) return( 1 );    //       - 
   else               return( 0 );    //   - 
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
bool SetIndicatorParameters(const ENUM_CONSTRUCTION_TYPE type, //  
                            const color clr,                   //  
                            const color neutralClr)            //  
  {
//---    
   SetIndexBuffer(0,bufSize);
   SetIndexBuffer(1,bufSizeClr,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,bufAverage);
//---    
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---     
   PlotIndexSetDouble( 0, PLOT_EMPTY_VALUE, EMPTY_VALUE );   // 
   PlotIndexSetDouble( 1, PLOT_EMPTY_VALUE, EMPTY_VALUE );   //  
//---   
   PlotIndexSetInteger( 0, PLOT_COLOR_INDEXES, 2 );           //   
   PlotIndexSetInteger( 0, PLOT_LINE_COLOR, 0, neutralClr );  //   
   PlotIndexSetInteger( 0, PLOT_LINE_COLOR, 1, clr );         //   
   PlotIndexSetInteger( 1, PLOT_LINE_COLOR, 0, clr );         //   
//---    
   string name="CandleSizes ("+GetConstructionStringType(type)+")";
   IndicatorSetString(INDICATOR_SHORTNAME,name);
//---
   return( true );
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
string GetConstructionStringType(const ENUM_CONSTRUCTION_TYPE type) //  
  {
   switch(type)
     {
      case upper_shadows: return( "upper" );
      case lower_shadows: return( "lower" );
      case bodies:         return( "bodies" );
      default:
         Print(__FUNCTION__,": !    "+EnumToString(type));
         return( "" );
     }
  }
//+------------------------------------------------------------------+
//|                    |
//+------------------------------------------------------------------+
int GetFirstBar(const datetime &time[], //       
                const int rates_total,  //   
                int &dayNum)            //    (out)
  {
   int prev = GetDayNumber(time[ 0 ] ); //     
   int curr;                            //     
   for(int i=1; i<rates_total; i++)     //    
     {
      curr=GetDayNumber(time[i]);       //      
      if(curr==prev) continue;          //    -   . 
      else                              //    
        {
         dayNum = curr;                 //     
         return(i );                    //      
        }
     }
//---
   Print(__FUNCTION__,":   ..");
   return(0);                           //  0
  }
//+------------------------------------------------------------------+
//|                                   |
//+------------------------------------------------------------------+
int GetDayNumber(const datetime time) //  
  {
   MqlDateTime tStr;                  //  
   TimeToStruct( time,tStr );         //   
   return(tStr.day);                  //    
  }
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
void Calculation(const ENUM_CONSTRUCTION_TYPE type, //  
                 const int num,                     //   
                 const int dCount,                  //      (  )
                 const int dSum,                    //      (  )
                 const datetime time,               //     
                 const double high,                 //    
                 const double low,                  //    
                 const double open,                 //   
                 const double close)                //   
  {
//---      
   int cdlType = GetCandleType( open, close );                           //   
   int size = GetElementSize( type, cdlType, open, high, low, close );   //  
   if( size == 0 ) return;
//---    
   bufSize[ num ] = size;      //  
   bufSizeClr[ num ] = 0;      // 
//---     
   bufAverage[num]=int(MathRound(( dSum+size)/dCount));
//---         
   if(bufSize[num]>bufAverage[num]) //   
      bufSizeClr[num]=1;            //    
  }
//+------------------------------------------------------------------+
//|                              |
//+------------------------------------------------------------------+
void Calculation_bar(const ENUM_CONSTRUCTION_TYPE type, //  
                     const int num,                     //  
                     int &dCount,                       //      (out)
                     int &dSum,                         //      (out)
                     const datetime &time[],            //     
                     const double &high[],              //    
                     const double &low[],               //    
                     const double &open[],              //   
                     const double &close[])             //   
  {
//---    
   dCount++;
//---     
   int cdlType = GetCandleType( open[ num ],close[ num ] );                                          //   
   int size = GetElementSize( type, cdlType, open[ num ], high[ num ], low[ num ], close[ num ] );   //  
   if( size == -1 ) return;
//---    
   dSum+=size;
//---    
   bufSize[num]=size;
//---   
   bufAverage[num]=int(MathRound(dSum/dCount));
//---    
   if(bufSize[num]>bufAverage[num]) //     
      bufSizeClr[num]=1;            //   
   else                             //     
   bufSizeClr[num]=0;               //   
  }
//+------------------------------------------------------------------+
//|     type                               |
//+------------------------------------------------------------------+
int GetElementSize(const ENUM_CONSTRUCTION_TYPE type, //  
                   const int cdlType,                 //  
                   const double open,                 //  
                   const double high,                 //  
                   const double low,                  //  
                   const double close)                //  
  {
   switch(type) //     
     {
      case upper_shadows:                                 //  
         if( cdlType == 0 ) return( int( NormalizeDouble( high - close, _Digits )/_Point ) );   //  
         else               return( int( NormalizeDouble( high - open, _Digits  )/_Point ) );   //  
         break;
      case lower_shadows:                                 //  
         if( cdlType == 0 ) return( int( NormalizeDouble( open  - low, _Digits )/_Point ) );   //  
         else               return( int( NormalizeDouble( close - low, _Digits )/_Point ) );   //  
         break;
      case bodies:                                       //  
         if( cdlType == 0 ) return( int( NormalizeDouble( close - open, _Digits )/_Point ) );   //  
         else               return( int( NormalizeDouble( open - close, _Digits )/_Point ) );   //  
         break;
      default:                                          //  
         Print(__FUNCTION__,": !   : "+EnumToString(type));
         return(-1);                                    //   
     }
  }
//+------------------------------------------------------------------+
//|      +  . -  |
//+------------------------------------------------------------------+
void CheckNewDay(const datetime time, //   
                 int &dNum,           //    (out)
                 int &dCount,         //       (out)
                 int &dSum)           //        (out)
  {
   int currDayNum=GetDayNumber(time); //   
   if(currDayNum!=dNum)               //      
     {
      //---    
      dNum= currDayNum;               //  
      dCount = 0;                     //    
      dSum= 0;                        //     
     }
  }
//+------------------------------------------------------------------+
