//+------------------------------------------------------------------+
//|                                                    TriXCloud.mq5 |
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrChartreuse,clrDarkOrange
//----   
#property indicator_label1  "TriXCloud"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint TriXPeriod=14;           //  TriX 
//+----------------------------------------------+
//----   ,    
//----      
double ExtABuffer[],ExtBBuffer[];
//----       
int IndA_Handle,IndB_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(TriXPeriod);
//---    iTriX HIGH
   IndA_Handle=iTriX(Symbol(),PERIOD_CURRENT,TriXPeriod,PRICE_HIGH);
   if(IndA_Handle==INVALID_HANDLE)
     {
      Print("      iTriX HIGH");
      return(INIT_FAILED);
     }
//---    iTriX LOW
   IndB_Handle=iTriX(Symbol(),PERIOD_CURRENT,TriXPeriod,PRICE_LOW);
   if(IndB_Handle==INVALID_HANDLE)
     {
      Print("      iTriX LOW");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtABuffer,true);
//----      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtBBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"TriXCloud");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,6);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total
   || BarsCalculated(IndA_Handle)<rates_total
   || BarsCalculated(IndB_Handle)<rates_total) return(RESET);
//----    
   int to_copy;
//----     
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total; //      
     }
   else to_copy=rates_total-prev_calculated+1; //      
//----      
   if(CopyBuffer(IndA_Handle,0,0,to_copy,ExtABuffer)<=0) return(RESET);
   if(CopyBuffer(IndB_Handle,0,0,to_copy,ExtBBuffer)<=0) return(RESET);
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
