//+---------------------------------------------------------------------+
//|                                                        CCIBands.mq5 |
//|                                             Copyright  2014, wellx | 
//|                                                 http://www.mql4.com | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2014, wellx"
#property link "http://www.mql4.com"
#property description "Commodity Channel Index High-Low Band"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----    3
#property indicator_buffers 3 
//----    
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       Lime 
#property indicator_color1 clrLime
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "UpCCI"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       BlueViolet 
#property indicator_color2 clrBlueViolet
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "MediumCCI"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       Red 
#property indicator_color3 clrRed
//----   -  
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//----   
#property indicator_label3  "LowCCI"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +100.0
#property indicator_level2    0.0
#property indicator_level3 -100.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA H1XMA,H2XMA,C1XMA,C2XMA,L1XMA,L2XMA;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; //  
input uint CCIPeriod=14;                 //  CCI 
input double koeff=0.015;
input int XPhase=15;                     //  
//----  JJMA    -100 ... +100,     
//----  VIDIA   CMO,  AMA    
//+----------------------------------------------+
//----   ,    
//----      
double ExtABuffer[],ExtBBuffer[],ExtBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(GetStartBars(XMA_Method,CCIPeriod,XPhase)+CCIPeriod);
//----      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(1,ExtBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   SetIndexBuffer(2,ExtBBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"CCIBands");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----       
   double ExtPrice_C,ExtPrice_H,ExtPrice_L,ExtMov_C,ExtMov_H,ExtMov_L,dSum_C,dSum_H,dSum_L;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      ExtPrice_C=(high[bar]+low[bar]+close[bar])/3;
      ExtPrice_H=(high[bar]+low[bar]+high[bar])/3;
      ExtPrice_L=(high[bar]+low[bar]+low[bar])/3;
      //----
      ExtMov_C=C1XMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,CCIPeriod,ExtPrice_C,bar,false);
      ExtMov_H=H1XMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,CCIPeriod,ExtPrice_H,bar,false);
      ExtMov_L=L1XMA.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,CCIPeriod,ExtPrice_L,bar,false);
      //----
      dSum_C=koeff*C2XMA.XMASeries(CCIPeriod,prev_calculated,rates_total,MODE_SMA_,XPhase,CCIPeriod,MathAbs(ExtPrice_C-ExtMov_C),bar,false);
      dSum_H=koeff*H2XMA.XMASeries(CCIPeriod,prev_calculated,rates_total,MODE_SMA_,XPhase,CCIPeriod,MathAbs(ExtPrice_H-ExtMov_C),bar,false);
      dSum_L=koeff*L2XMA.XMASeries(CCIPeriod,prev_calculated,rates_total,MODE_SMA_,XPhase,CCIPeriod,MathAbs(ExtPrice_L-ExtMov_C),bar,false);
      //----      
      ExtABuffer[bar]=0.0;
      ExtBBuffer[bar]=0.0;
      ExtBuffer[bar]=0.0;
      //---- 
      if(dSum_C) ExtBuffer[bar]=(ExtPrice_C-ExtMov_C)/dSum_C;
      if(dSum_H) ExtABuffer[bar]=(ExtPrice_H-ExtMov_C)/dSum_H;
      if(dSum_L) ExtBBuffer[bar]=(ExtPrice_L-ExtMov_C)/dSum_L;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
