//+------------------------------------------------------------------+
//|                                           ChandelierStops_v1.mq5 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"
#property description ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   4
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1 DRAW_LINE
//----       Lime
#property indicator_color1 clrLime
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "ChandelierStops Up"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2 DRAW_LINE
//----       Magenta
#property indicator_color2 clrMagenta
//----   - 
#property indicator_style2 STYLE_SOLID
//----     2
#property indicator_width2 2
//----    
#property indicator_label2  "ChandelierStops Down"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----         MediumTurquoise
#property indicator_color3  clrMediumTurquoise
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  4
#property indicator_width3  4
//----    
#property indicator_label3  "Buy ChandelierStops signal"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----         DeepPink
#property indicator_color4  clrDeepPink
//----   2 -  
#property indicator_style4  STYLE_SOLID
//----    4  4
#property indicator_width4  4
//----    
#property indicator_label4  "Sell ChandelierStops signal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   Length=20;
input uint   ATRPeriod=10;
input double Kv=3;
input int    Shift=0; //       
//+----------------------------------------------+
//----   ,    
//----      
double TrendUp[],TrendDown[],SignUp[],SignDown[];
//----      
int ATR_Handle;
//----      
int min_rates_total;
//----   ,    
//----      
int Count[];
double smin[],smax[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+    
int OnInit()
  {
//----     
   min_rates_total=int(ATRPeriod+Length);
//----    ATR
   ATR_Handle=iATR(NULL,0,ATRPeriod);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(1);
     }
//----       
   ArrayResize(Count,Length);
   ArrayResize(smin,Length);
   ArrayResize(smax,Length);
   ArrayInitialize(smin,-999999);
   ArrayInitialize(smax,+999999);
   ArraySetAsSeries(smin,true);
   ArraySetAsSeries(smax,true);
//----    ExtBuffer[]   
   SetIndexBuffer(0,TrendUp,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(TrendUp,true);
//----    ExtBuffer[]   
   SetIndexBuffer(1,TrendDown,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(TrendDown,true);
//----    SignUp []   
   SetIndexBuffer(2,SignUp,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(SignUp,true);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,108);
//----    SignDown[]   
   SetIndexBuffer(3,SignDown,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(SignDown,true);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);
//----   
   PlotIndexSetInteger(3,PLOT_ARROW,108);
//----      
   string shortname;
   StringConcatenate(shortname,"ChandelierStops_v1(",Length,", ",ATRPeriod,", ",Kv,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   int limit,to_copy,bar;
   double trend0,ATR[];
   static double trend1;
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(ATR,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-1-int(ATRPeriod); //      
     }
   else limit=rates_total-prev_calculated; //      
//---
   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      int bar0=Count[0];
      int bar1=Count[1];
      smin[Count[0]]=high[ArrayMaximum(high,bar,ATRPeriod)]-Kv*ATR[bar];
      smax[Count[0]]=low[ArrayMinimum(low,bar,ATRPeriod)]+Kv*ATR[bar];
      trend0=trend1;
      //---
      if(close[bar]>smax[Count[1]]) trend0=+1;
      if(close[bar]<smin[Count[1]]) trend0=-1;
      //---
      if(trend0>0)
        {
         if(smin[bar0]<smin[bar1]) smin[bar0]=smin[bar1];
         TrendUp[bar]=smin[bar0];
         TrendDown[bar]=0.0;
        }
      if(trend0<0)
        {
         if(smax[bar0]>smax[bar1]) smax[bar0]=smax[bar1];
         TrendUp[bar]=0.0;
         TrendDown[bar]=smax[bar0];
        }
      //---
      if(bar)
        {
         Recount_ArrayZeroPos(Count,Length);
         trend1=trend0;
        }
      //---
      SignUp[bar]=0.0;
      SignDown[bar]=0.0;
      //---
      if(TrendDown[bar+1] &&  TrendUp[bar]) SignUp[bar]=TrendUp[bar];
      if(TrendUp[bar+1]&& TrendDown[bar]) SignDown[bar]=TrendDown[bar];
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
