//+------------------------------------------------------------------+
//|                                              ChandelExitSign.mq5 |
//|                                                       MQLService |
//|                                           scripts@mqlservice.com |
//+------------------------------------------------------------------+
//----  
#property copyright "MQLService"
#property link      "scripts@mqlservice.com"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Red 
#property indicator_color1  clrRed
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "BullsBears Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        Lime 
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "BullsBears Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint RangePeriod=15;
input uint Shift=1;
input uint ATRPeriod=14;
input uint MultipleATR=4;
//+----------------------------------------------+
//----   ,    
//----      
double SellBuffer[];
double BuyBuffer[];
//----      
int ATR1_Handle,ATR2_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   int ATR2Period=12;
   min_rates_total=int(MathMax(MathMax(ATRPeriod,RangePeriod+Shift)+1,ATR2Period));
//----    ATR1
   ATR1_Handle=iATR(NULL,0,ATRPeriod);
   if(ATR1_Handle==INVALID_HANDLE)
     {
      Print("     ATR1");
      return(INIT_FAILED);
     }
//----    ATR2
   ATR2_Handle=iATR(NULL,0,ATR2Period);
   if(ATR2_Handle==INVALID_HANDLE)
     {
      Print("     ATR2");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,163);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----       
   ArraySetAsSeries(SellBuffer,true);
//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,163);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----       
   ArraySetAsSeries(BuyBuffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"ChandelExit(",RangePeriod,", ",ATRPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR1_Handle)<rates_total
      || BarsCalculated(ATR2_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   static int direction;
   int to_copy,limit,bar;
   double ATR1[],ATR2[],HH0,LL0,Up=0.0,Dn=0.0;
   static double Up1,Dn1;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
      direction=0;
      Up=Up1=0.0;
      Dn=Dn1=0.0;
     }
   else limit=rates_total-prev_calculated; //      
//----     
   to_copy=limit+1;
//----      
   if(CopyBuffer(ATR1_Handle,0,0,to_copy,ATR1)<=0) return(RESET);
   if(CopyBuffer(ATR2_Handle,0,0,to_copy,ATR2)<=0) return(RESET);
//----         
   ArraySetAsSeries(ATR1,true);
   ArraySetAsSeries(ATR2,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ATR1[bar]*=MultipleATR;
      HH0=high[ArrayMaximum(high,bar+Shift,RangePeriod)]-ATR1[bar];
      LL0=low[ArrayMinimum(low,bar+Shift,RangePeriod)]+ATR1[bar];

      if(direction>=0)
        {
         if(close[bar]<HH0)
           {
            if(bar) direction=-1;
            Up=LL0;
            Dn=HH0;
           }
         else
           {
            Up=HH0;
            Dn=LL0;
           }
        }
      else
      if(direction<=0)
        {
         if(close[bar]>LL0)
           {
            if(bar) direction=+1;
            Dn=LL0;
            Up=HH0;
           }
         else
           {
            Up=LL0;
            Dn=HH0;
           }
        }
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(Dn1<=Up1 && Dn>Up) BuyBuffer[bar]=low[bar]-ATR1[bar]*3/8;
      if(Dn1>=Up1 && Dn<Up) SellBuffer[bar]=high[bar]+ATR1[bar]*3/8;

      if(bar)
        {
         Up1=Up;
         Dn1=Dn;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
