//+------------------------------------------------------------------+
//|                                                 RSITrend_x10.mq5 |
//|                               Copyright  2015, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "2015, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property description "    RSI   "
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    0
#property indicator_buffers 0 
//----      
#property indicator_plots   0
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0          //        
#define INDTOTAL 10      //     
//+----------------------------------------------+
//|   type_font              |
//|   CFontName                    | 
//+----------------------------------------------+ 
#include <GetFontName.mqh>
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame0=PERIOD_H1;           //   1
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_H2;           //   2
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_H3;           //   3
input ENUM_TIMEFRAMES TimeFrame3=PERIOD_H4;           //   4
input ENUM_TIMEFRAMES TimeFrame4=PERIOD_H6;           //   5
input ENUM_TIMEFRAMES TimeFrame5=PERIOD_H8;           //   6
input ENUM_TIMEFRAMES TimeFrame6=PERIOD_H12;          //   7
input ENUM_TIMEFRAMES TimeFrame7=PERIOD_D1;           //   8
input ENUM_TIMEFRAMES TimeFrame8=PERIOD_W1;           //   9
input ENUM_TIMEFRAMES TimeFrame9=PERIOD_MN1;          //   10 
//----  RSI
input int   RSIPeriod=14;
input ENUM_APPLIED_PRICE   RSIPrice=PRICE_CLOSE;
input uint UpLevel=70;                                //  
input uint DnLevel=30;                                //  
//----
input color  CpColor=clrDarkOrchid;                   //   
input color  UpColor=clrDodgerBlue;                   //   
input color  DnColor=clrRed;                          //   
input color  ZrColor=clrGray;                         //   
input int    FontSize=11;                             //  
input type_font FontType=Font14;                      //  
input ENUM_BASE_CORNER  WhatCorner=CORNER_LEFT_LOWER; //  
input uint Y_=20;                                     //   
input uint X_=5;                                      //   
//+----------------------------------------------+
string sFontType;
int min_rates_total;
uint xshift,shift[11];
string sPer[10],sPerA[10],sPerB[10],Cap;
ENUM_TIMEFRAMES ePer[10];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+  
class CIndArrow
  {
public:
   double            m_Ind[1];
   int               m_Handle;
   ENUM_TIMEFRAMES   m_TimeFrame;
  };
//----  ,    
//----      
CIndArrow Ind[INDTOTAL];
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
   ePer[0]=TimeFrame0;
   ePer[1]=TimeFrame1;
   ePer[2]=TimeFrame2;
   ePer[3]=TimeFrame3;
   ePer[4]=TimeFrame4;
   ePer[5]=TimeFrame5;
   ePer[6]=TimeFrame6;
   ePer[7]=TimeFrame7;
   ePer[8]=TimeFrame8;
   ePer[9]=TimeFrame9;
   for(int poz=0; poz<INDTOTAL; poz++) Ind[poz].m_TimeFrame=ePer[poz];
//----   
   for(int poz=0; poz<INDTOTAL; poz++)
     {
      Ind[poz].m_Handle=iRSI(Symbol(),Ind[poz].m_TimeFrame,RSIPeriod,RSIPrice);

      if(Ind[poz].m_Handle==INVALID_HANDLE)
        {
         Print("OnInit()(",poz,"):      RSI");
         return(false);
        }
     }
//----   
   CFontName FONT;
   sFontType=FONT.GetFontName(FontType);
   Deinit();
   min_rates_total=int(RSIPeriod)+1;
//----  
   xshift=int(X_+8.3*FontSize);
   Cap="RSITrend_x10";
//----
   switch(WhatCorner)
     {
      case CORNER_RIGHT_LOWER:
        {
         for(int poz=0; poz<=INDTOTAL; poz++) shift[10-poz]=Y_+22*poz;
         break;
        }
      //---
      case CORNER_LEFT_LOWER:
        {
         for(int poz=0; poz<=INDTOTAL; poz++) shift[10-poz]=Y_+22*poz;
         break;
        }
      default:
        {
         for(int poz=0; poz<=INDTOTAL; poz++) shift[poz]=Y_+22*poz;
        }
     }
   for(int poz=0; poz<INDTOTAL; poz++)
     {
      sPer[poz]=GetStringTimeframe(ePer[poz]);
      sPerA[poz]=sPer[poz]+"Stat+";
      sPerB[poz]=sPer[poz]+"Stat_";
     }
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Deinit();
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void Deinit()
  {
   for(int poz=0; poz<INDTOTAL; poz++)
     {
      ObjectDelete(0,sPerA[poz]);
      ObjectDelete(0,sPerB[poz]);
     }
   ObjectDelete(0,Cap);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CreateTLabel(long   chart_id,         //  
                  string name,             //  
                  int    nwin,             //  
                  ENUM_BASE_CORNER corner, //   
                  ENUM_ANCHOR_POINT point, //   
                  int    X,                //      X   
                  int    Y,                //      Y   
                  string text,             // 
                  color  Color,            //  
                  string Font,             //  
                  int    Size)             //  
  {
   ObjectCreate(chart_id,name,OBJ_LABEL,0,0,0);
   ObjectSetInteger(chart_id,name,OBJPROP_CORNER,corner);
   ObjectSetInteger(chart_id,name,OBJPROP_ANCHOR,point);
   ObjectSetInteger(chart_id,name,OBJPROP_XDISTANCE,X);
   ObjectSetInteger(chart_id,name,OBJPROP_YDISTANCE,Y);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetString(chart_id,name,OBJPROP_FONT,Font);
   ObjectSetInteger(chart_id,name,OBJPROP_FONTSIZE,Size);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,false);
  }
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
void SetTLabel(long   chart_id,         //  
               string name,             //  
               int    nwin,             //  
               ENUM_BASE_CORNER corner, //   
               ENUM_ANCHOR_POINT point, //   
               int    X,                //      X   
               int    Y,                //      Y   
               string text,             // 
               color  Color,            //  
               string Font,             //  
               int    Size)             //  
  {
   if(ObjectFind(chart_id,name)==-1) CreateTLabel(chart_id,name,nwin,corner,point,X,Y,text,Color,Font,Size);
   else
     {
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectSetInteger(chart_id,name,OBJPROP_XDISTANCE,X);
      ObjectSetInteger(chart_id,name,OBJPROP_YDISTANCE,Y);
      ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
     }
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   for(int poz=0; poz<INDTOTAL; poz++) if(Bars(Symbol(),ePer[poz])<min_rates_total) return(RESET);
//----       
   for(int poz=0; poz<INDTOTAL; poz++)
      if(CopyBuffer(Ind[poz].m_Handle,MAIN_LINE,1,1,Ind[poz].m_Ind)<=0) return(RESET);
//----
   color ColorGain[INDTOTAL];
   ArrayInitialize(ColorGain,ZrColor);
//----       
   for(int poz=0; poz<INDTOTAL; poz++)
     {
      if(Ind[poz].m_Ind[0]>UpLevel) ColorGain[poz]=UpColor;
      if(Ind[poz].m_Ind[0]<DnLevel) ColorGain[poz]=DnColor;
     }
//----
   for(int poz=0; poz<INDTOTAL; poz++)
     {
      SetTLabel(0,sPerA[poz],0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_,shift[poz+1],sPer[poz]+": ",ColorGain[poz],sFontType,FontSize);
      SetTLabel(0,sPerB[poz],0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),xshift,shift[poz+1],"n",ColorGain[poz],"Wingdings",FontSize);
     }
   SetTLabel(0,Cap,0,WhatCorner,ENUM_ANCHOR_POINT(2*WhatCorner),X_,shift[0],Cap,CpColor,sFontType,FontSize);
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
