//+---------------------------------------------------------------------+
//|                                               ATR_MA_Oscillator.mq5 | 
//|                                               Copyright  zfs, 2009 | 
//|                                                                     | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  zfs, 2009"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_HISTOGRAM
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "ATR_MA_Oscillator"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA   SmoothAlgorithms.mqh
CXMA XATR1,XATR2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_LWMA; //  
input int XLength=100;                    //                      
input int XPhase=15;                      //  
                                          //  JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Smooth_Method SXMA_Method=MODE_LWMA; //  
input int SXLength=100;                    //                      
input int SXPhase=15;                      //  
                                           //  JJMA    -100 ... +100,     ;
                                           //  VIDIA   CMO,  AMA    
input int Shift=0;                         //      
//----   ,    
//----      
double IndBuffer[];
//----      
int min_rates_total,min_rates_;
//+------------------------------------------------------------------+   
//| ATR_MA_Oscillator initialization function                        | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_=XATR1.GetStartBars(XMA_Method,XLength,XPhase)+1;
   min_rates_total=min_rates_+XATR1.GetStartBars(SXMA_Method,SXLength,SXPhase);
//----       
   XATR1.XMALengthCheck("XLength", XLength);
   XATR1.XMAPhaseCheck("XPhase", XPhase, XMA_Method);
   XATR1.XMALengthCheck("SXLength", SXLength);
   XATR1.XMAPhaseCheck("SXPhase", SXPhase, SXMA_Method);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"ATR_MA_Oscillator");
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| ATR_MA_Oscillator iteration function                             | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double atr,xatr,xxatr;
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      atr=MathMax(high[bar],close[bar-1])-MathMin(low[bar],close[bar-1]);
      atr/=_Point;
      xatr=XATR1.XMASeries(1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,atr,bar,false);
      xxatr=XATR2.XMASeries(min_rates_,prev_calculated,rates_total,SXMA_Method,SXPhase,SXLength,xatr,bar,false);
      IndBuffer[bar]=xatr-xxatr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
