//+------------------------------------------------------------------+
//|                                                    AML_StDev.mq5 | 
//|                                       Copyright  2011, andreybs | 
//|                                               andreybs@yandex.ru | 
//+------------------------------------------------------------------+ 
//---  
#property copyright "Adaptive Market Level"
//---  
#property link      "andreybs@yandex.ru"
//---   
#property version   "1.11"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 4
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_COLOR_LINE
//---      
#property indicator_color1  clrGray,clrDeepSkyBlue,clrViolet
//---   -  
#property indicator_style1  STYLE_SOLID
//---     3
#property indicator_width1  3
//---   
#property indicator_label1  "AML"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrRed
//---    2  3
#property indicator_width2  3
//---    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---        
#property indicator_color3  clrLime
//---    3  3
#property indicator_width3  3
//---    
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Fractal=6;
input int Lag=7;
input double dK=3.0;      //    
input uint std_period=9;  //   
input int Shift=0;        //      
input int PriceShift=0;   //      
//+----------------------------------------------+
//---   ,   
//---      
double AMLBuffer[];
double ColorAMLBuffer[];
double BearsBuffer[];
double BullsBuffer[];
//---
double dAML[];
//---      
double dPriceShift;
double LagLagPoint;
//---      
int min_rates_1,min_rates_total,size,Fractal2;
//---   ,   
//---      
int Count[];
double Smooth[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//---
   int numb,Max1,Max2;
   static int count=1;
//---
   Max2=Size;
   Max1=Max2-1;
//---
   count--;
   if(count<0) count=Max1;
//---
   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
double Range(int period,int start,const double &High[],const double &Low[])
  {
//---
   double max = High[ArrayMaximum(High,start,period)];
   double min = Low[ArrayMinimum(Low,start,period)];
//---
   return(max-min);
  }
//+------------------------------------------------------------------+   
//| AML indicator initialization function                            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   Fractal2=int(2*Fractal);
   min_rates_1=int(MathMax(Fractal+Lag,Fractal2));
   min_rates_total=min_rates_1+1+int(std_period);
//---    
   dPriceShift=_Point*PriceShift;
//---       
   ArrayResize(dAML,std_period);
//---  
   LagLagPoint=Lag*Lag*_Point;
   size=int(Lag+1);
//---       
   ArrayResize(Count,size);
   ArrayResize(Smooth,size);
//---      
   SetIndexBuffer(0,AMLBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(AMLBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorAMLBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorAMLBuffer,true);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---    BearsBuffer   
   SetIndexBuffer(2,BearsBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(BearsBuffer,true);
//---    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---    BullsBuffer   
   SetIndexBuffer(3,BullsBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(BullsBuffer,true);
//---    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//---       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname;
   StringConcatenate(shortname,"AML(",Fractal,", ",Lag,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
  }
//+------------------------------------------------------------------+ 
//| AML iteration function                                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double SMAdif,Sum,StDev,dstd,BEARS,BULLS,Filter;
//---        
   int limit,bar;
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(close,true);
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_1-1; //      
      bar=limit;
      double price=(high[bar]+low[bar]+2*open[bar]+2*close[bar])/6;
      //---   
      ArrayInitialize(Smooth,price);
      ArrayInitialize(Count,0.0);
      AMLBuffer[bar+1]=price;
      ColorAMLBuffer[bar+1]=0;
     }
   else limit=rates_total-prev_calculated; //      
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double R1=Range(Fractal,bar,high,low)/Fractal;
      double R2=Range(Fractal,bar+Fractal,high,low)/Fractal;
      double R3=Range(Fractal2,bar,high,low)/Fractal2;
      //---
      double dim=0;
      if(R1+R2>0 && R3>0) dim=(MathLog(R1+R2)-MathLog(R3))*1.44269504088896;
      //---
      double alpha=MathExp(-Lag*(dim-1.0));
      alpha=MathMin(alpha,1.0);
      alpha=MathMax(alpha,0.01);
      //---
      double price=(high[bar]+low[bar]+2*open[bar]+2*close[bar])/6;
      Smooth[Count[0]]=alpha*price+(1.0-alpha)*Smooth[Count[1]];
      //---
      if(MathAbs(Smooth[Count[0]]-Smooth[Count[Lag]])>=LagLagPoint) AMLBuffer[bar]=Smooth[Count[0]];
      else AMLBuffer[bar]=AMLBuffer[bar+1];
      AMLBuffer[bar]+=PriceShift;
      //---
      if(bar) Recount_ArrayZeroPos(Count,size);
     }
//---    limit
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      limit=rates_total-min_rates_total-1; //      
//---     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorAMLBuffer[bar]=0;
      if(AMLBuffer[bar+1]<AMLBuffer[bar]) ColorAMLBuffer[bar]=1;
      if(AMLBuffer[bar+1]>AMLBuffer[bar]) ColorAMLBuffer[bar]=2;
      if(AMLBuffer[bar+1]==AMLBuffer[bar]) ColorAMLBuffer[bar]=ColorAMLBuffer[bar+1];
     }
//---      
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---        
      for(int iii=0; iii<int(std_period); iii++) dAML[iii]=AMLBuffer[bar+iii]-AMLBuffer[bar+iii+1];
      //---     
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=dAML[iii];
      SMAdif=Sum/std_period;
      //---       
      Sum=0.0;
      for(int iii=0; iii<int(std_period); iii++) Sum+=MathPow(dAML[iii]-SMAdif,2);
      //---      StDev   
      StDev=MathSqrt(Sum/std_period);
      //---  
      dstd=NormalizeDouble(dAML[0],_Digits+2);
      Filter=NormalizeDouble(dK*StDev,_Digits+2);
      BEARS=0;
      BULLS=0;
      //---   
      if(dstd<-Filter) BEARS=AMLBuffer[bar]; //  
      if(dstd>+Filter) BULLS=AMLBuffer[bar]; //  
      //---       
      BullsBuffer[bar]=BULLS;
      BearsBuffer[bar]=BEARS;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
