//+------------------------------------------------------------------+ 
//|                                                         BoDi.mq5 | 
//|                                      Copyright  2011, paladin80 | 
//|                                                  forevex@mail.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2011, paladin80"
#property link "forevex@mail.ru"
//---   
#property version   "1.01"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---      
#property indicator_color1 clrDeepPink,clrGray,clrDodgerBlue
//---   - 
#property indicator_style1 STYLE_SOLID
//---     2
#property indicator_width1 2
//---   
#property indicator_label1 "BoDi"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint                BBPeriod=20;                 //     
input double              StdDeviation=2;              // - 
input ENUM_APPLIED_PRICE  applied_price=PRICE_CLOSE;   //  
//+-----------------------------------+
//---      
int min_rates_total;
//---   ,  
//---       
double IndBuffer[],ColorIndBuffer[];
//---      
int Ind_Handle;
//+------------------------------------------------------------------+    
//| BoDi indicator initialization function                           | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=int(BBPeriod+1);
//---    iBands
   Ind_Handle=iBands(Symbol(),PERIOD_CURRENT,BBPeriod,0,StdDeviation,applied_price);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iBands");
      return(INIT_FAILED);
     }
//---    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorIndBuffer,true);  
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"BoDi");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| BoDi iteration function                                          | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit,bar;
   double UpBB[],DnBB[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-2; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//---      
   if(CopyBuffer(Ind_Handle,UPPER_BAND,0,to_copy,UpBB)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle,LOWER_BAND,0,to_copy,DnBB)<=0) return(RESET);
//---       
   ArraySetAsSeries(UpBB,true);
   ArraySetAsSeries(DnBB,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--) IndBuffer[bar]=(UpBB[bar]-DnBB[bar])/_Point;
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorIndBuffer[bar]=1;
      if(IndBuffer[bar]>IndBuffer[bar+1]) ColorIndBuffer[bar]=2;
      if(IndBuffer[bar]<IndBuffer[bar+1]) ColorIndBuffer[bar]=0;
     }
//---
   return(rates_total);
  }
//+------------------------------------------------------------------+
