//------------------------------------------------------------------------------
//                                                              SpecAnalyzer.mq5
//                                     Copyright 2010, MetaQuotes Software Corp.
//                                                           http://www.mql5.com
//------------------------------------------------------------------------------
#property copyright "2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property description "Spectrum Analyzer (FFT 1024). Example of use MQL5 graphical objects."
#property version   "3.002"

#include "SpecAnalyzer.mqh"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1
#property indicator_type1   DRAW_LINE
#property indicator_color1  DodgerBlue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

double DrawBuffer[];                                         // Indicator buffer

input bool Automatic=true;
input int Window=0;   //Subwindow index
input int Indicator=0;//Indicator index

double InpData[1024];                                             // Input Array
double Spectrum[512];                                          // Spectrum Array
double ListArray[512];                                          // Listing array
int  YPowerFlag;                              // Y-axis mode:0-Amplitude,1-Power
int  YdBFlag;                                         // Y-axis mode:0-Line,1-dB
int  InputSource;                   // Input :0-External,1-Test1,2-Test2,3-Test3
long ListPointer;                           // Pointer to row number for listing
int  ExtHandle;                                     // External indicator handle

AllGrObject GObj;
GRaphChart  MainChart;                                // Create MainChart object 
//----------------------------------------- Indicator initialization function --
int OnInit()
  {
   SetIndexBuffer(0,DrawBuffer,INDICATOR_DATA);           // Init ndicator buffer
   PlotIndexSetString(0,PLOT_LABEL,"Spectrum");           // Init ndicator buffer
   ArraySetAsSeries(DrawBuffer,true);                     // Init ndicator buffer

   gr_object_create();                             // Create all graphical object
   YPowerFlag=0;                                       // Y-axis mode = Amplitude
   YdBFlag=1;                                                 // Y-axis mode = dB
   InputSource=2;                                                // Input = Test2
   ListPointer=1;
   ExtHandle=iCustom(NULL,0,"SpecAnalyzer\\SAInpData",Automatic,Window,Indicator);            // External indicator Handle

   return(0);
  }
//---------------------------------------------- Indicator iteration function --
int OnCalculate(const int rates_total,const int prev_calculated,
                const datetime &time[],const double &open[],
                const double &high[],const double &low[],
                const double &close[],const long &tick_volume[],
                const long &volume[],const int &spread[])
  {

   MainChart.SetOwnProperty();
   gr_object_coordinate();
   get_input_data();                                           // Load input data
   fft_calc();                                                 // FFT calculation
   norm_and_draw();                            // Normalization and draw spectrum
   list_levels();                                   // Listing of spectrum levels

   return(rates_total);
  }
//--------------------------------------- Indicator deinitialization function --
void OnDeinit(const int reason)
  {

  }
//----------------------------------------------------- Indicator Chart Event --
void OnChartEvent(const int id,const long &lparam,
                  const double &dparam,const string &sparam)
  {

   if(id==CHARTEVENT_OBJECT_ENDEDIT && sparam=="Edit1") // End of edit
     {
      ListPointer=GObj.GetRowNumber("Edit1");
     }
   if(id==CHARTEVENT_OBJECT_CLICK) // Click on the gr. object
     {
      if(sparam=="Butt1") // Click on the button
        {
         GObj.SetButtonProp("Butt1",1,Chocolate);
         GObj.SetButtonProp("Butt2",0,SlateGray);
         GObj.SetButtonProp("Butt3",0,SlateGray);
         GObj.SetButtonProp("Butt4",0,SlateGray);
         YPowerFlag=0;YdBFlag=0;
        }
      if(sparam=="Butt2") // Click on the button
        {
         GObj.SetButtonProp("Butt1",0,SlateGray);
         GObj.SetButtonProp("Butt2",1,Chocolate);
         GObj.SetButtonProp("Butt3",0,SlateGray);
         GObj.SetButtonProp("Butt4",0,SlateGray);
         YPowerFlag=0;YdBFlag=1;
        }
      if(sparam=="Butt3") // Click on the button
        {
         GObj.SetButtonProp("Butt1",0,SlateGray);
         GObj.SetButtonProp("Butt2",0,SlateGray);
         GObj.SetButtonProp("Butt3",1,Chocolate);
         GObj.SetButtonProp("Butt4",0,SlateGray);
         YPowerFlag=1;YdBFlag=0;
        }
      if(sparam=="Butt4") // Click on the button
        {
         GObj.SetButtonProp("Butt1",0,SlateGray);
         GObj.SetButtonProp("Butt2",0,SlateGray);
         GObj.SetButtonProp("Butt3",0,SlateGray);
         GObj.SetButtonProp("Butt4",1,Chocolate);
         YPowerFlag=1;YdBFlag=1;
        }
      if(sparam=="Butt5") // Click on the button
        {
         GObj.SetButtonProp("Butt5",1,Chocolate);
         GObj.SetButtonProp("Butt6",0,SlateGray);
         GObj.SetButtonProp("Butt7",0,SlateGray);
         GObj.SetButtonProp("Butt8",0,SlateGray);
         InputSource=0;
        }
      if(sparam=="Butt6") // Click on the button
        {
         GObj.SetButtonProp("Butt5",0,SlateGray);
         GObj.SetButtonProp("Butt6",1,Chocolate);
         GObj.SetButtonProp("Butt7",0,SlateGray);
         GObj.SetButtonProp("Butt8",0,SlateGray);
         InputSource=1;
        }
      if(sparam=="Butt7") // Click on the button
        {
         GObj.SetButtonProp("Butt5",0,SlateGray);
         GObj.SetButtonProp("Butt6",0,SlateGray);
         GObj.SetButtonProp("Butt7",1,Chocolate);
         GObj.SetButtonProp("Butt8",0,SlateGray);
         InputSource=2;
        }
      if(sparam=="Butt8") // Click on the button
        {
         GObj.SetButtonProp("Butt5",0,SlateGray);
         GObj.SetButtonProp("Butt6",0,SlateGray);
         GObj.SetButtonProp("Butt7",0,SlateGray);
         GObj.SetButtonProp("Butt8",1,Chocolate);
         InputSource=3;
        }
      if(sparam=="Butt9") // Click on the button
        {
         GObj.SetButtonProp("Butt9",0,SlateGray);
         ListPointer++;
        }
      if(sparam=="Butt10") // Click on the button
        {
         GObj.SetButtonProp("Butt10",0,SlateGray);
         ListPointer--;
        }
     }
   MainChart.SetOwnProperty();
   gr_object_coordinate();
   get_input_data();                                           // Load input data
   fft_calc();                                                 // FFT calculation
   norm_and_draw();                            // Normalization and draw spectrum
   list_levels();                                   // Listing of spectrum levels
   MainChart.Redraw();
  }
//------------------------------------------------------------------------------
//----------------------------------------------- Create all graphical object --
void gr_object_create()
  {
   GObj.AddLabel("Title",10,"Arial",DarkGray,256,367,"Spectrum Analyzer");
   GObj.AddLabel("Label1",9,"Arial",LightSteelBlue,557,128,"0");
   GObj.AddLabel("Label2",9,"Arial",LightSteelBlue,422,128,"128");
   GObj.AddLabel("Label3",9,"Arial",LightSteelBlue,294,128,"256");
   GObj.AddLabel("Label4",9,"Arial",LightSteelBlue,166,128,"384");
   GObj.AddLabel("Label5",9,"Arial",LightSteelBlue,40,128,"512");
   GObj.AddLabel("Label6",9,"Arial",LightSteelBlue,28,156,"N");
   GObj.AddLabel("Label7",9,"Arial",LightSteelBlue,569,141,"0.00");
   GObj.AddLabel("Label8",9,"Arial",LightSteelBlue,569,191,"0.25");
   GObj.AddLabel("Label9",9,"Arial",LightSteelBlue,569,241,"0.50");
   GObj.AddLabel("Label10",9,"Arial",LightSteelBlue,569,291,"0.75");
   GObj.AddLabel("Label11",9,"Arial",LightSteelBlue,569,341,"1.00");
   GObj.AddLabel("Label12",9,"Arial",LightSteelBlue,569,358,"U");
   GObj.AddLabel("Label13",9,"Arial",DarkGray,490,86,"Y-axis Mode");
   GObj.AddLabel("Label14",9,"Arial",DarkGray,285,86,"Input Data");
   GObj.AddLabel("Label15",9,"Arial",DarkGray,75,86,"Level");
   GObj.AddLabel("Label16",9,"Arial",DarkGray,185,86,"N");
   GObj.AddLabel("Label17",8,"Courier",DarkOliveGreen,64,64);
   GObj.AddLabel("Label18",8,"Courier",DarkOliveGreen,64,51);
   GObj.AddLabel("Label19",8,"Courier",DarkOliveGreen,64,38);
   GObj.AddLabel("Label20",8,"Courier",DarkOliveGreen,64,25);
   GObj.AddLabel("Label21",8,"Courier",DarkOliveGreen,64,12);
   GObj.AddButton("Butt1",185,18,C'32,32,32',8,"Arial",SlateGray,612,79,"Amplitude (line)",0);
   GObj.AddButton("Butt2",185,18,C'32,32,32',8,"Arial",Chocolate,612,61,"Amplitude (log)",1);
   GObj.AddButton("Butt3",185,18,C'32,32,32',8,"Arial",SlateGray,612,43,"Power (line)",0);
   GObj.AddButton("Butt4",185,18,C'32,32,32',8,"Arial",SlateGray,612,25,"Power (log)",0);
   GObj.AddButton("Butt5",185,18,C'32,32,32',8,"Arial",SlateGray,403,79,"External Data",0);
   GObj.AddButton("Butt6",185,18,C'32,32,32',8,"Arial",SlateGray,403,61,"Test 1. SMA(3)",0);
   GObj.AddButton("Butt7",185,18,C'32,32,32',8,"Arial",Chocolate,403,43,"Test 2. SMA(32)",1);
   GObj.AddButton("Butt8",185,18,C'32,32,32',8,"Arial",SlateGray,403,25,"Test 3. LWMA(12)",0);
   GObj.AddButton("Butt9",14,34,C'32,32,32',8,"Wingdings",SlateGray,36,78,"\x0431",0);
   GObj.AddButton("Butt10",14,34,C'32,32,32',8,"Wingdings",SlateGray,36,44,"\x0432",0);
   GObj.AddEdit("Edit1",35,18,Black,9,"Arial",SlateGray,180,102);
   GObj.AddTrendLine("Trdline1",C'32,32,32');
   GObj.AddTrendLine("Trdline2",C'32,32,32');
   GObj.AddTrendLine("Trdline3",C'32,32,32');
   GObj.AddTrendLine("Trdline4",C'32,32,32');
   GObj.AddTrendLine("Trdline5",C'32,32,32');
   GObj.AddTrendLine("Trdline6",C'32,32,32');
   GObj.AddTrendLine("Trdline7",C'32,32,32');
   GObj.AddTrendLine("Trdline8",C'32,32,32');
   GObj.AddArrowline("Arrline1",LightSteelBlue);
   GObj.AddArrowline("Arrline2",LightSteelBlue);
   GObj.AddRectangle("Rect1",C'72,72,72');
   GObj.AddRectangle("Rect2",C'72,72,72');
   GObj.AddRectangle("Rect3",C'72,72,72');
   GObj.AddRectangle("Rect4",DarkGray);
   GObj.AddRectangle("Rect5",C'72,72,72');
  }
//---------- Set object coordinate for Trend Line, Arroved Line and Rectangle --
void gr_object_coordinate()
  {
   GObj.MoveGrObject("Trdline1",48,150,48,360);
   GObj.MoveGrObject("Trdline2",176,150,176,360);
   GObj.MoveGrObject("Trdline3",304,150,304,360);
   GObj.MoveGrObject("Trdline4",432,150,432,360);
   GObj.MoveGrObject("Trdline5",42,350,560,350);
   GObj.MoveGrObject("Trdline6",42,300,560,300);
   GObj.MoveGrObject("Trdline7",42,250,560,250);
   GObj.MoveGrObject("Trdline8",42,200,560,200);
   GObj.MoveGrObject("Arrline1",560,150,28,150);
   GObj.MoveGrObject("Arrline2",560,150,560,370);
   GObj.MoveGrObject("Rect1",0,1,208,110);
   GObj.MoveGrObject("Rect2",208,1,416,110);
   GObj.MoveGrObject("Rect3",416,1,624,110);
   GObj.MoveGrObject("Rect4",0,1,624,400);
   GObj.MoveGrObject("Rect5",20,10,195,80);
  }
//------------------------------------------------ Listing of spectrum levels --
void list_levels()
  {
   int m;
   string str;

   if(YdBFlag==0) str="%3u    %.5f";                     // If Y-axis mode = Line
   else str="%3u  %6.1f dB";                               // If Y-axis mode = dB
   m=ArraySize(ListArray)-5;
   if(ListPointer<1)ListPointer=1;
   if(ListPointer>m)ListPointer=m;
   GObj.LabelTxt("Label17",StringFormat(str,ListPointer,ListArray[int(ListPointer)]));
   GObj.LabelTxt("Label18",StringFormat(str,ListPointer+1,ListArray[int(ListPointer+1)]));
   GObj.LabelTxt("Label19",StringFormat(str,ListPointer+2,ListArray[int(ListPointer+2)]));
   GObj.LabelTxt("Label20",StringFormat(str,ListPointer+3,ListArray[int(ListPointer+3)]));
   GObj.LabelTxt("Label21",StringFormat(str,ListPointer+4,ListArray[int(ListPointer+4)]));
  }
//---------------------------------------------------------------- Input data --
void get_input_data()
  {
   int i;

   ArrayInitialize(InpData,0.0);
   switch(InputSource)
     {
      case 0:                                                     // External Data
         if(ExtHandle!=INVALID_HANDLE)
         CopyBuffer(ExtHandle,0,0,ArraySize(InpData),InpData);
         break;
      case 1:                                                    // Test 1. SMA(3)
         for(i=0;i<3;i++)InpData[i]=1;
         break;
      case 2:                                                   // Test 2. SMA(32)
         for(i=0;i<32;i++)InpData[i]=1;
         break;
      case 3:                                                  // Test 3. LWMA(12)
         for(i=0;i<12;i++)InpData[i]=12-i;
         break;
     }
  }
//----------------------------------------------------------- FFT calculation --
void fft_calc()
  {
   int i,k;

   realfastfouriertransform(InpData,ArraySize(InpData),false);             // FFT
   for(i=1;i<ArraySize(Spectrum);i++)
     {
      k=i*2;
      Spectrum[i]=InpData[k]*InpData[k]+InpData[k+1]*InpData[k+1];
     }
   Spectrum[0]=0.0;                             // Clear constant component level
  }
//------------------------------------------- Normalization and draw spectrum --
void norm_and_draw()
  {
   int i,k;
   double max,min;
   string str;

   k=ArraySize(Spectrum);
   ArrayInitialize(DrawBuffer,EMPTY_VALUE);                // Clear all draw data
   max=0.0;
   for(i=1;i<k;i++)
      if(max<Spectrum[i])max=Spectrum[i];                          // Find maximum
   if(max!=0.0)
      for(i=1;i<k;i++)Spectrum[i]=Spectrum[i]/max;                  // Range 0...1
   if(YPowerFlag==0) // Y-axis mode = Amplitude
      for(i=1;i<k;i++)Spectrum[i]=MathSqrt(Spectrum[i]);
   if(YdBFlag==0) // Y-axis mode = Line
     {
      ArrayCopy(ListArray,Spectrum);                    // Copy levels for listing
      if(max==0.0)ArrayInitialize(Spectrum,0.0015);
      else
        {
         for(i=1;i<k;i++)Spectrum[i]=Spectrum[i]*0.0020+0.0015;
         GObj.LabelTxt("Label11","1.00");
         GObj.LabelTxt("Label10","0.75");
         GObj.LabelTxt("Label9","0.50");
         GObj.LabelTxt("Label8","0.25");
         GObj.LabelTxt("Label7","0.00");
        }
     }
   else                                                       // Y-axis mode = dB
     {
      min=10000;
      for(i=1;i<k;i++)
        {
         Spectrum[i]=20*MathLog10(Spectrum[i]);
         if(min>Spectrum[i])min=Spectrum[i];                        // Find minimum
        }
      for(i=10;i>0;i--)
         if(min>=(-i*10) && min<(-(i-1)*10))min=(-i*10);
      if(min<-100)
        {
         for(i=1;i<k;i++)
            if(Spectrum[i]<-100)Spectrum[i]=-100;
         min=-100;
        }
      ArrayCopy(ListArray,Spectrum);                    // Copy levels for listing
      for(i=1;i<k;i++)Spectrum[i]=(min-Spectrum[i])/min*0.0020+0.0015;
      GObj.LabelTxt("Label11","0.00");
      GObj.LabelTxt("Label10",DoubleToString(min/4,2));
      GObj.LabelTxt("Label9",DoubleToString(min/2,2));
      GObj.LabelTxt("Label8",DoubleToString(min/4*3,2));
      GObj.LabelTxt("Label7",DoubleToString(min,2));
     }
   if(YPowerFlag==0)str="U, ";
   else str="P, ";
   if(YdBFlag==1)str+="dB";
   else str+="lin";
   GObj.LabelTxt("Label12",str);
   ArrayCopy(DrawBuffer,Spectrum,49,0,512);                      // Draw spectrum
   DrawBuffer[560]=EMPTY_VALUE;
  }
//+------------------------------------------------------------------+
