//+------------------------------------------------------------------+
//|                                                   PrintModes.mq5 |
//|                        Copyright 2012, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2012, MetaQuotes Software Corp."
#property link        "http://tol64.blogspot.com"
#property description "email: hello.tol64@gmail.com"
#property version     "1.00"
#property script_show_inputs
//---
//--- ENUMERATION
enum ENUM_PRINT_MODE
  {
   PRINT   = 0,
   COMMENT = 1,
   ALERT   = 2
  };
//---
// INPUT PARAMETERS
input ENUM_PRINT_MODE printMode=PRINT; // Print mode
//---
//+------------------------------------------------------------------+
//| MAIN FUNCTION                                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   PrintSymbolProperties();
  }
//+------------------------------------------------------------------+
//| PRINTING SYMBOL PROPERTIES                                       |
//+------------------------------------------------------------------+
void PrintSymbolProperties()
  {
   string symb_symbol    = "";  // Symbol
   int    symb_digits    = 0;   // Number of decimal places
   int    symb_spread    = 0;   // Difference between the ask price and bid price (spread)
   int    symb_stoplevel = 0;   // Stop levels
   double symb_ask       = 0.0; // Ask price
   double symb_bid       = 0.0; // Bid price
//---
   symb_symbol    =Symbol();
   symb_digits    =(int)SymbolInfoInteger(_Symbol,SYMBOL_DIGITS);
   symb_spread    =(int)SymbolInfoInteger(_Symbol,SYMBOL_SPREAD);
   symb_stoplevel =(int)SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL);
   symb_ask       =SymbolInfoDouble(_Symbol,SYMBOL_ASK);
   symb_bid       =SymbolInfoDouble(_Symbol,SYMBOL_BID);
//---
// If it says to print to the journal
   if(printMode==PRINT)
     {
      Print("Symbol: ",symb_symbol,"\n",
            "Digits: ",symb_digits,"\n",
            "Spread: ",symb_spread,"\n",
            "Stops Level: ",symb_stoplevel,"\n",
            "Ask: ",symb_ask,"\n",
            "Bid: ",symb_bid
            );
     }
//---
// If it says to print to the chart
   if(printMode==COMMENT)
     {
      int mb_res=-1; // Variable with the option selected in the dialog box
      //---
      Comment("Symbol: ",symb_symbol,"\n",
              "Digits: ",symb_digits,"\n",
              "Spread: ",symb_spread,"\n",
              "Stops Level: ",symb_stoplevel,"\n",
              "Ask: ",symb_ask,"\n",
              "Bid: ",symb_bid
              );
      //---
      // Open a dialog box
      mb_res=MessageBox("Do you want to delete comments from the chart?",NULL,MB_YESNO|MB_ICONQUESTION);
      //---
      // If "Yes" is clicked, remove the comments from the chart 
      if(mb_res==IDYES) { Comment(""); }
      //---
      return;
     }
//---
// If it says to print to the alert window
   if(printMode==ALERT)
     {
      Alert("Symbol: "+symb_symbol+"\n",
            "Digits: "+IntegerToString(symb_digits)+"\n",
            "Spread: "+IntegerToString(symb_spread)+"\n",
            "Stops Level: "+IntegerToString(symb_stoplevel)+"\n",
            "Ask: "+DoubleToString(symb_ask,_Digits)+"\n",
            "Bid: "+DoubleToString(symb_bid,_Digits)
            );
     }
  }

//+------------------------------------------------------------------+