//+------------------------------------------------------------------+
//|                                                     VolChart.mq4 |
//|                        Copyright 2018, MetaQuotes Software Corp. |
//|                                              http://www.mql4.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, MetaQuotes Software Corp."
#property link      "http://www.mql4.com"
#property version   "1.00"
#property strict
#property indicator_chart_window

#include "HDiagsE.mqh"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum HD_ZOOM 
  {
   HD_MIN    = 0,  //1
   HD_MIDDLE = 1,  //10
   HD_BIG    = 2   //100
  };

input HD_STYLE    hdStyle   = HD_LINE;
input int         hdHorSize = 20;
input color       hdColor   = clrDeepSkyBlue;
input int         hdWidth   = 2;

input ENUM_TIMEFRAMES TargetPeriod = PERIOD_D1;
input ENUM_TIMEFRAMES SourcePeriod = PERIOD_M1;
input HD_ZOOM     hdStep=HD_MIDDLE;   
input int         MaxHDcount = 1;
input int         iTimer     = 1;

CHDiags    *pHd;
int iCurr;
HDDATA sdata;

int         hdDigit;
double      hdPoint;

int iCurSource, iCurTarget;

MqlRates    target[], source[];
datetime    tme[];

struct NEW_CANDLE {
   int             iCandleNum;
   datetime        dtTimeOpen;
   string          strSymbol;
   ENUM_TIMEFRAMES PeriodCurr;
   bool            bFirstStart;
   NEW_CANDLE() {
      Reset();
      strSymbol   = Symbol();
      PeriodCurr  = PERIOD_CURRENT;
      bFirstStart = false;      
   };
   NEW_CANDLE(string newSymbol, ENUM_TIMEFRAMES newTimeFrame, bool bStartReac) {
      Reset();
      strSymbol   = newSymbol;
      PeriodCurr  = newTimeFrame;
      bFirstStart = bStartReac;
   };   
   void Reset() {
      iCandleNum  = -1;
      dtTimeOpen  = 0;   
   };
   bool IsNewAndSet(int iNewNum, datetime dtNewTime) {
      if (!bFirstStart && (iCandleNum == -1 || dtTimeOpen == 0) ) {
         iCandleNum = iNewNum;
         dtTimeOpen = dtNewTime;
         return (false);
      }   
      if (iCandleNum == iNewNum || dtTimeOpen == dtNewTime) return (false);
      iCandleNum = iNewNum;
      dtTimeOpen = dtNewTime;
      return (true);
   };
};


bool IsNewCandle(NEW_CANDLE& stNewCandle) {

   int t1=0;
   datetime dt = iTime(stNewCandle.strSymbol, stNewCandle.PeriodCurr, 0);
   switch(stNewCandle.PeriodCurr)
     {
      case PERIOD_M1:  t1 = Minute(); break;
      case PERIOD_M2:  t1 = M2();     break;
      case PERIOD_M3:  t1 = M3();     break;
      case PERIOD_M4:  t1 = M4();     break;
      case PERIOD_M5:  t1 = M5();     break;
      case PERIOD_M6:  t1 = M6();     break;
      case PERIOD_M10: t1 = M10();    break;
      case PERIOD_M12: t1 = M12();    break;
      case PERIOD_M15: t1 = M15();    break;
      case PERIOD_M20: t1 = M20();    break;
      case PERIOD_M30: t1 = M30();    break;
      case PERIOD_H1:  t1 = Hour();   break;
      case PERIOD_H2:  t1 = Hour2();  break;
      case PERIOD_H3:  t1 = Hour3();  break;
      case PERIOD_H4:  t1 = Hour4();  break;
      case PERIOD_H6:  t1 = Hour6();  break;
      case PERIOD_H8:  t1 = Hour8();  break;
      case PERIOD_H12: t1 = Hour12(); break;
      case PERIOD_D1:  t1 = Day();    break;
      case PERIOD_W1:  t1 = Week();   break;
      case PERIOD_MN1: t1 = Month();  break;
      default: return (false);
     }
   return (stNewCandle.IsNewAndSet(t1, dt) );

}

NEW_CANDLE NcS ;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit() 
  {
   NcS.Reset(); NcS.PeriodCurr = SourcePeriod; NcS.bFirstStart = true;
   pHd         = new CHDiags(HD_RIGHT, hdStyle, HD_RIGHTLEFT, hdHorSize, hdColor, hdWidth, 0, MaxHDcount);
   if(pHd      == NULL) return (INIT_FAILED);
   iCurr       = pHd.AddHDiag(TimeCurrent() );
   if(iCurr    == -1) return (INIT_FAILED);     
   
   hdDigit= Digits() -(int)hdStep;
   switch(hdStep) 
     {
      case HD_MIN:
         hdPoint=Point();
         break;
      case HD_MIDDLE:
         hdPoint=10 *Point();
         break;
      case HD_BIG:
         hdPoint=100*Point();
         break;
      default:
         return (INIT_FAILED);
     }

  ArraySetAsSeries(target, true);
  ArraySetAsSeries(tme,     true);
  ArraySetAsSeries(source, true);  

  EventSetTimer(iTimer);

  return(INIT_SUCCEEDED);
  }
  
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
      switch (id) {
         case CHARTEVENT_CHART_CHANGE:
            pHd.Align();
            break;
        default:
            break;    
      }//switch (id)
  }  
//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer() 
  {
      if (IsNewCandle(NcS) ) 
        {
         Print("Prepare new source");      
         if (PrepareForBar(0, sdata) ) 
           {
             int count = pHd.SetData(sdata, iCurr);
             Print("Send arrays to manager: ",sdata.prsize," Create levels: ", count);             
           } 
      }//if (IsNewCandle(iCurSource, SourcePeriod) )       
 }// void OnTimer()  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

bool PrepareForBar(int bar, HDDATA& hdta) {

   hdta.prmax  = hdta.prmin  = hdta.prsize  = 0;
   hdta.bRemovePrev = true;
   int iSCount;
   datetime dtStart, dtEnd;
   dtEnd = (bar == 0)? TimeCurrent() : iTime(Symbol(), TargetPeriod, bar - 1);
   hdta.dtLastTime = dtStart = iTime(Symbol(), TargetPeriod, bar);
   
   hdta.prmax = iHigh(Symbol(), TargetPeriod, bar);
   if(hdta.prmax == 0) return (false);
   hdta.prmax      = (int)MathCeil(NormalizeDouble(hdta.prmax, hdDigit) / hdPoint );
   
   hdta.prmin = iLow(Symbol(), TargetPeriod, bar);
   if(hdta.prmin == 0) return (false);
   hdta.prmin      = (int)MathFloor(NormalizeDouble(hdta.prmin, hdDigit) / hdPoint );

   iSCount = CopyRates(Symbol(), SourcePeriod, dtStart, dtEnd, source);
   if (iSCount < 1) return (false);

   hdta.prsize = (int)(hdta.prmax - hdta.prmin + 10);
   
   ArrayResize(hdta.pcur,  hdta.prsize);
   ArrayResize(hdta.vcur,  hdta.prsize);
   ArrayInitialize(hdta.pcur, 0);
   ArrayInitialize(hdta.vcur, 0);
   
   double avTick;
   int i, delta;
   hdta.prmax = 0;
   
   for (i = 0; i < hdta.prsize; i++) hdta.pcur[i] = (hdta.prmin + i) * hdPoint;
   int rs = 0;
   for (i = 1; i < iSCount; i++) {
      if (source[i].tick_volume == 0.0) continue;
      if (!MqlRatesRound(source[i], (int)hdta.prmin) ) continue;
      delta = (int)(source[i].high - source[i].low);
      if (delta == 0) delta = 1;
      avTick = (double)(source[i].tick_volume / delta);
      int j;
      for (j = (int)source[i].low; j <= (int)(source[i].low) + delta; j++) {
         if (j >= hdta.prsize) {
            Print("Internal ERROR. Wait for next source period or switch timeframe");
            return false;
         }
         hdta.vcur[j] += avTick;
         if (hdta.vcur[j] > hdta.prmax) hdta.prmax = (int)hdta.vcur[j];
      }//for (int j = (int)source[i].low; j <= (int)(source[i].low) + delta; j++)   
      if (j > rs) rs = j; //real size
   }//for (int i = 1; i < iSCount; i++)
   hdta.prsize = rs + 1;
   return (true);
}  

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   return(rates_total);
  } 
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnDeinit(const int reason) 
  {
   delete pHd;
   EventKillTimer();
  }//void OnDeinit(const int reason)  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool MqlRatesRound(MqlRates &rates,const int iZero) 
  {
   if( (rates.close = MathRound(NormalizeDouble(rates.close, hdDigit) / hdPoint ) - iZero) < 0) return (false);
   if( (rates.high  = MathRound(NormalizeDouble(rates.high,  hdDigit) / hdPoint ) - iZero) < 0) return (false);
   if( (rates.low   = MathRound(NormalizeDouble(rates.low,   hdDigit) / hdPoint ) - iZero) < 0) return (false);
   if( (rates.open  = MathRound(NormalizeDouble(rates.open,  hdDigit) / hdPoint ) - iZero) < 0) return (false);
   return (true);
  }// bool MqlRatesRound(MqlRates& rates, const int iZero)
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Week() 
  {
   double w=(double)((TimeCurrent()+3*86400)/7)/86400;
   return (int)MathFloor(w);
  }
int Hour12(){return  ((int)Hour()/12);}
int Hour8() {return  ((int)Hour()/8);}
int Hour6() {return  ((int)Hour()/6);}
int Hour4() {return  ((int)Hour()/4);}
int Hour3() {return  ((int)Hour()/3);}
int Hour2() {return  ((int)Hour()/2);}
int M30()   {return  (2  * Hour() + (int)Minute() / 30);}
int M20()   {return  (3  * Hour() + (int)Minute() / 20);}
int M15()   {return  (4  * Hour() + (int)Minute() / 15);}
int M12()   {return  (5  * Hour() + (int)Minute() / 12);}
int M10()   {return  (6  * Hour() + (int)Minute() / 10);}
int M6()    {return  (10 * Hour() + (int)Minute() / 6);}
int M5()    {return  (12 * Hour() + (int)Minute() / 5);}
int M4()    {return  (15 * Hour() + (int)Minute() / 4);}
int M3()    {return  (20 * Hour() + (int)Minute() / 3);}
int M2()    {return  (30 * Hour() + (int)Minute() / 2);}
int M1()    {return  (60 * Hour() +      Minute());}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Hour()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.hour);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Minute()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.min);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Day()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.day);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Month()
  {
   MqlDateTime tm;
   TimeCurrent(tm);
   return(tm.mon);
  }
//+------------------------------------------------------------------+
