//+------------------------------------------------------------------+
//|                                                   cotsignals.mq5 |
//|                                           Copyright 2010, Sergan |
//|                                               SerganMT@hotbox.ru |
//+------------------------------------------------------------------+
#property copyright "2010, Sergan"
#property link      "SerganMT@hotbox.ru"
#property version   "1.00"
#property script_show_inputs
//--- input parameters
input int      NBars=150; //History depth W1

#include <cot.mqh>

string listsymbols[]={"EURUSD","GBPUSD","USDCHF","USDCAD","USDJPY","AUDUSD","XAUUSD"}; //, "XAGUSD"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CCOTOutFile
  {
private:
   string            filename;
   int               handle;
public:
   bool              Init(string passedname);
   void              PutString(string symbol,double &probably[]);
   void              PutHeader(cot_type_statistics &arrheaders[]);
   void ~CCOTOutFile(){       FileClose(handle);    }
  };
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   CCOTOutFile outfile;  //file with results
   if(!outfile.Init("cotw1signals.csv"))return;

   cot_type_statistics list_statistic[]=// statistic types list
     { speculantsign,speculantchange,willamszones };
   outfile.PutHeader(list_statistic); // write header to .csv file
   for(int i=0; i<ArraySize(listsymbols); i++)
     {  //for all symbols in the list
      Print("Analysis for "+listsymbols[i]);
      CCOTStatistic stat;
      stat.Init(listsymbols[i],list_statistic);
      double probably[];  //probability of a signal
      if(!stat.Get(probably))
        {
         Print("Error in statistics calculation for the symbol ",listsymbols[i]);
         return;
        }
      outfile.PutString(listsymbols[i],probably); //write string to .csv file
     }
   Print("Calculation complete.");
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization of instance - creates file                        |
//| Input : passedname - file name                                   |
//| Output: true - if successful                                     |
//|         false - in the case of error                             |
//+------------------------------------------------------------------+
bool CCOTOutFile::Init(string passedname)
  {
   filename=passedname;
   handle=FileOpen(filename,FILE_WRITE|FILE_ANSI); //file opens for writing
   if(handle==INVALID_HANDLE)
     {
      Print("Error in creating of file "+filename);
      return(false);
     }
   return(true);
  }
//+------------------------------------------------------------------+
//| Writes the string to the .csv file                               |
//| Input  : symbol - symbol name in the terminal                    |
//|          probably[] - list of probabilities                      |
//| Output : None                                                    |
//+------------------------------------------------------------------+
void CCOTOutFile::PutString(string symbol,double &probably[])
  {
//format of output data:
//symbol; signal1prob; signal2prob; ......

   string outs=symbol;
   for(int i=0; i<ArraySize(probably); i++)
     {
      outs=outs+";"+DoubleToString(probably[i],2);
     }
   FileWrite(handle,outs);
  }
//+------------------------------------------------------------------+
//| Writes the header to the .csv file                               |
//| Input : arrheaders - list of signal types                        |
//| Output: None                                                     |
//+------------------------------------------------------------------+
void CCOTOutFile::PutHeader(cot_type_statistics &arrheaders[])
  {
   string outs = "symbol";
   string str2 = "";
   for(int i=0; i<ArraySize(arrheaders); i++)
     {
      StringConcatenate(outs,outs,";",GetStringTypeStatistic(arrheaders[i]));
     }
   FileWriteString(handle,outs+"\n");
  }
//+------------------------------------------------------------------+
