//+------------------------------------------------------------------+
//|                                                cotdownloader.mq5 |
//|                                           Copyright 2010, Sergan |
//|                                               SerganMT@hotbox.ru |
//+------------------------------------------------------------------+
//Loads cot reports from the site of CFTC
#property copyright "2010, Sergan"
#property link      "SerganMT@hotbox.ru"
#property version   "1.00"

#include <ClassProgressBar.mqh> //from here: http://www.mql5.com/en/articles/17
#include <cot.mqh>
#include <CDownloader.mqh>
//+------------------------------------------------------------------+
//| Class CCOTDownloadedFile                                         |
//+------------------------------------------------------------------+
class CCOTDownloadedFile
  {        //describes the file to download
private:
   int               year;                // year
   string            strbegname;          // beginning substring of the file
public:
   // object initializatation
   void Init(string  passedbegname,int passedyear){ year=passedyear; strbegname=passedbegname;}
   // returns the URL of the archive file
   string InternetName(){  return(COT_MAIN_URL+strbegname+IntegerToString(year)+".zip");   }
   // returns full filename of the archive
   string OnDiskPackedName(){ return(COT_STORE_FOLDER+IntegerToString(year)+"/"+strbegname+IntegerToString(year)+".zip"); }
   // returns path to extract the files from the archive
   string UnpackPath(){return(COT_STORE_FOLDER+IntegerToString(year));  }

  };
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
//preparing file list to download
   CCOTDownloadedFile listfilestodownload[];
   int endyear= TimeYear(GetWindowsLocalTime());
   for( int i = COT_FIRST_YEAR_DATA; i <=endyear; i++  )AddUrlToArray( listfilestodownload, "deacot", i );
   for( int i = CIT_FIRST_YEAR_DATA; i <=endyear; i++  )AddUrlToArray( listfilestodownload, "dea_cit_txt_" , i );
   for( int i = DCOT_FIRST_YEAR_DATA; i <=endyear; i++ )AddUrlToArray( listfilestodownload, "fut_disagg_txt_", i );
//file list has been formed
   CProgressBar progress;
   progress.Create(0,"Loading",0,150,20);
   progress.Text("Downloading");
   bool flagwasload=false;
   Print("Search for CFTC reports...");
   progress.Value(0.00001);
// cycle for all urls to download
   for(int i=0; i<ArraySize(listfilestodownload); i++,progress.Value((i+0.)/ArraySize(listfilestodownload)*100))
     {

      CFileDownLoader handle;

      //file downloading initialization
      bool res=handle.Init(listfilestodownload[i].InternetName(),listfilestodownload[i].OnDiskPackedName());
      if(!res)
        {
         Print("Error in downloading of file: ",listfilestodownload[i].InternetName(),". Downloading has failed");
         return;
        }

      //file size at server
      ulong internetsize=handle.SizeOfFile();
      //file size on the disk, that has been already downloaded
      ulong ondisksize=FileSize(listfilestodownload[i].OnDiskPackedName());

      if(internetsize!=ondisksize)
        {
         //file lengths are different
         Print("Downloading: "+listfilestodownload[i].InternetName()+" -> "+listfilestodownload[i].OnDiskPackedName());
         if(!handle.ExecuteDownload())
           {
            Print("Error downloading of file "+listfilestodownload[i].InternetName());
            return;
           }
         flagwasload=true;
         //at least one file has been downloaded successfully
        }
      //unpack downloaded file
      if(!ExtractZip(listfilestodownload[i].OnDiskPackedName(),listfilestodownload[i].UnpackPath()))
        {
         Print("Error unpacking of file: "+listfilestodownload[i].OnDiskPackedName());
         return;
        }
      //unpack was successful
     }
   if(flagwasload)
     {
      Print("Download complete.");
        }else{
      Print("There isn't any new data on the server");
     }
  }
//+-----------------------------------------------------------------+
//| The function adds string to the list of files to download       |
//| Input : arr[] - array of file list                              |
//|         passedbegname - beginning substring of file name        |
//|         passedyear    - year                                    |
//| Output : None                                                   |
//|-----------------------------------------------------------------+
void AddUrlToArray(CCOTDownloadedFile &arr[],string passedbegname,int passedyear)
  {
   string testnextyearnamefolder=COT_STORE_FOLDER+""+IntegerToString(passedyear+1)+"/annual.txt";
   int cursize=ArraySize(arr);
   cursize++;
   ArrayResize(arr,cursize);
   arr[cursize-1].Init(passedbegname,passedyear);
  }
//+------------------------------------------------------------------+
