//+------------------------------------------------------------------+
//|                                                       cotnet.mq5 |
//|                                         Copyright  2010, Sergan |
//|                                               SerganMT@hotbox.ru |
//+------------------------------------------------------------------+
#property copyright "2010, Sergan"
#property link      "SerganMT@hotbox.ru"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2
//---- plot Noncommercial
#property indicator_label1  "Noncommercial"
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_color1  Blue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  5
//---- plot Commercial
#property indicator_label2  "Commercial"
#property indicator_type2   DRAW_HISTOGRAM
#property indicator_color2  Red
#property indicator_style2  STYLE_SOLID
#property indicator_width2  5
//--- indicator buffers

#include <cot.mqh>
input cot_type_data    type_data=netlongs;  // Indicator's type
double         NoncommercialBuffer[];
double         CommercialBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int handlecomm,handlenoncomm;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   SetIndexBuffer(0,NoncommercialBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,CommercialBuffer,INDICATOR_DATA);
   cot_type_traders td = commercial;
   cot_type_report  tr = COT;
   handlecomm=iCustom(NULL,0,"cot",td,type_data,tr);
   td=noncommercial;
   handlenoncomm=iCustom(NULL,0,"cot",td,type_data,tr);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {

   if(BarsCalculated(handlecomm)<rates_total || BarsCalculated(handlenoncomm)<rates_total) return(0);
   int to_copy=clctocopy(rates_total,prev_calculated);
   if(!copycotbuf(handlecomm,CommercialBuffer,to_copy))
     {
      Print("Error in data of commercial traders");
      return(0);
     }

   if(!copycotbuf(handlenoncomm,NoncommercialBuffer,to_copy))
     {
      Print("Error in data of non-commercial traders");
      return(0);
     }
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int clctocopy(int rates_total,int prev_calculated)
  {
   int to_copy;
   if(prev_calculated>rates_total || prev_calculated<=0) to_copy=rates_total;
   else
     {
      to_copy=rates_total-prev_calculated;
      to_copy++;
     }
   return(to_copy);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool copycotbuf(int handle,double &buf[],int to_copy)
  {
   return(CopyBuffer(handle,0,0,to_copy,buf)>=0);
  }
//+------------------------------------------------------------------+
