//+------------------------------------------------------------------+
//|                                                          cot.mq5 |
//|                                         Copyright  2010, Sergan |
//|                                               SerganMT@hotbox.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Sergan"
#property link      "SerganMT@hotbox.ru"

#include <cot.mqh>
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   1
#property indicator_type1   DRAW_LINE
#property indicator_color1 Blue
#property indicator_width1 2

input cot_type_traders type_trader = noncommercial;  //Type of traders
input cot_type_data    type_data   = netlongs;       //Type of the indicator
input cot_type_report  type_report = COT;            //Type of report

double BufferCalculations[];  // buffer for the calculated data
double BufferData[];          // buffer for the output data

CCFTCReport Report;           // COT report
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
   if(!Report.Init(type_report))
     {
      Print("Initialization error",MyErrorDescription(_LastError));
      return(-1);
     }
   string indname=Report.Name()+" "+GetCotIndicatorName(type_data);
   if(!Report.TestGroup(type_trader))
     {
      Print("Error: inconsistent report parameters: "+Report.Name()+", group of traders:",GetStringTypeTrader(type_trader));
      return(-1);
     }
   if(type_data!=openinterest)
     {
      indname=indname+" "+GetStringTypeTrader(type_trader);
     }
   SetIndexBuffer(0,BufferData,INDICATOR_DATA);
   IndicatorSetString(INDICATOR_SHORTNAME,indname);
   SetIndexBuffer(1,BufferCalculations,INDICATOR_CALCULATIONS);

   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &TickVolume[],
                const long &Volume[],
                const int &Spread[])
  {

   int pos=rates_total-prev_calculated-1;
   if(pos>= rates_total-1)pos--;

   ArraySetAsSeries(Time,true);
   ArraySetAsSeries(BufferData,true);
   ArraySetAsSeries(BufferCalculations,true);

   for(int i=pos;i>=0;i--)
     {
      cot_type_data passed=type_data;
      if(type_data==netlongs || type_data==netlongsrate || type_data==willams_index)
        {
         // for the types of the data: net longs, net longs rate, William Index
         // it returns net longs, the futher calculations are based on these data.
         passed=netlongs;
        }
      double res=Report.At(Time[i],type_trader,passed); //get data from report
      BufferCalculations[i] = res;
      BufferData[i]         = CalcData( type_data, i, Time );
     }
   return(rates_total);

  }
//+------------------------------------------------------------------+
//| The function returns the value of the specified type of the data |
//| Input : type_data - type of data                                 |
//|         i - current position in the buffer                       |
//|         Time[] - time values array (as timeseries)               |
//| Output: numerical value of the data requested                    |
//+------------------------------------------------------------------+
double CalcData(cot_type_data type_data,int i,const datetime &Time[])
  {
// share in the open interest
   if(type_data==netlongsrate)
     {
      return(BufferCalculations[i]/Report.At(Time[i],type_trader,openinterest));
     }
// Williams Index
   if(type_data==willams_index)return(CalcIndex(i,Time,BufferCalculations));

   return(BufferCalculations[i]);
  }
//+------------------------------------------------------------------+
//| The function calculates the value of the William's Index         |
//| Input : fromi - position of the data buffer                      |
//|         Time[] - time values array (as timeseries)               |
//|         bufdata[] - array of the index values                    |
//| Output : Index value                                             |
//|  Note  : None                                                    |
//+------------------------------------------------------------------+
double CalcIndex(int fromi,const datetime &Time[],const double &bufdata[])
  {
   datetime endtime=Time[fromi];
   datetime begtime=endtime-365*3*24*60*60; //3 year period

   double maxv = bufdata[fromi];
   double minv = bufdata[fromi];
   for(int i=fromi+1; i<Bars(Symbol(),PERIOD_CURRENT); i++)
     {
      if(Time[i]<begtime)break;
      maxv = MathMax( bufdata[i], maxv );
      minv = MathMin( bufdata[i], minv );
     }
// the maximal and minimal values from begtime to endtime has been found
   double div=maxv-minv;
   if(div==0)div=1;
   return((bufdata[fromi]-minv)/(div)*100);
  }
//+------------------------------------------------------------------+
