//+------------------------------------------------------------------+
//|                                                       common.mqh |
//|                                           Copyright 2009, Sergan |
//|                                               serganmt@hotbox.ru |
//+------------------------------------------------------------------+
//portions for the work with timeseries is taken from here:
//http://www.metatraderglobal.com/406/rewrite-mql4-to-mql5-script/
//#property copyright "2009, A. Williams"
//#property link      "http://www.mql5.com"

#property copyright "2009, Sergan"
#property link      "serganmt@hotbox.ru"


#include <errordescription.mqh>

double iif(bool condition,double ifTrue,double ifFalse){  if(condition) return(ifTrue); return(ifFalse);}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_MQLRATES_ID_MEMBER
  {
   CLOSE,OPEN,HIGH,LOW
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime BeginHistory(string symbol,ENUM_TIMEFRAMES timeframe)
  {
   datetime firstdate=SeriesInfoInteger(symbol,timeframe,SERIES_FIRSTDATE);
   return(firstdate);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double MqlRatesMemberOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact,ENUM_MQLRATES_ID_MEMBER idmember)
  {
   if(exact){ Print("ibarshift error, not implemented "); return(-1); }
   MqlRates ret[];
   datetime firstdate;
   firstdate=BeginHistory(symbol,timeframe);
   if(firstdate>time)
     {
      Print("Error, the history is absent for date/time=",TimeToString(time));
      return(0);
     }
   int iret=CopyRates( symbol, timeframe, time, 1, ret);
   if(iret==-1 || iret==0)
     {
      Print("Error in call of copyrates");
      Print("Error code ",GetLastError()," passedtime=",TimeToString(time)," first time in the history:",TimeToString(firstdate));
      return(-1);
     }
   if(idmember == CLOSE )return(ret[0].close);
   if( idmember == OPEN )return(ret[0].open);
   if( idmember == HIGH )return(ret[0].high);
   if(idmember==LOW)return(ret[0].low);
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
ENUM_TIMEFRAMES TFMigrate(int tf)
  {
   switch(tf)
     {
      case 0: return(PERIOD_CURRENT);
      case 1: return(PERIOD_M1);
      case 5: return(PERIOD_M5);
      case 15: return(PERIOD_M15);
      case 30: return(PERIOD_M30);
      case 60: return(PERIOD_H1);
      case 240: return(PERIOD_H4);
      case 1440: return(PERIOD_D1);
      case 10080: return(PERIOD_W1);
      case 43200: return(PERIOD_MN1);

      case 2: return(PERIOD_M2);
      case 3: return(PERIOD_M3);
      case 4: return(PERIOD_M4);
      case 6: return(PERIOD_M6);
      case 10: return(PERIOD_M10);
      case 12: return(PERIOD_M12);
      case 16385: return(PERIOD_H1);
      case 16386: return(PERIOD_H2);
      case 16387: return(PERIOD_H3);
      case 16388: return(PERIOD_H4);
      case 16390: return(PERIOD_H6);
      case 16392: return(PERIOD_H8);
      case 16396: return(PERIOD_H12);
      case 16408: return(PERIOD_D1);
      case 32769: return(PERIOD_W1);
      case 49153: return(PERIOD_MN1);

      default: return(PERIOD_CURRENT);
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iHigh(string symbol,int tf,int ind)
  {
   if(ind<0) return(-1);
   double Arr[];
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   if(CopyHigh(symbol,timeframe,ind,1,Arr)>0) return(Arr[0]);
   else return(-1);
  }

double High(int i){  return(iHigh(Symbol(),0,i)); }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iLow(string symbol,int tf,int ind)
  {
   if(ind<0) return(-1);
   double Arr[];
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   if(CopyLow(symbol,timeframe,ind,1,Arr)>0) return(Arr[0]);
   else return(-1);
  }

double Low(int i){  return(iLow(Symbol(),0,i)); }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iClose(string symbol,int tf,int ind)
  {
   if(ind<0) return(-1);
   double Arr[];
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   if(CopyClose(symbol,timeframe,ind,1,Arr)>0)
     {
      return(Arr[0]);
     }
   else return(-1);
  }

double Close(int i){  return(iClose(Symbol(),0,i)); }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iOpen(string symbol,int tf,int ind)
  {
   if(ind<0) return(-1);
   double Arr[];
   ENUM_TIMEFRAMES timeframe=TFMigrate(tf);
   if(CopyOpen(symbol,timeframe,ind,1,Arr)>0) return(Arr[0]);
   else return(-1);
  }

double Open(int i){  return(iOpen(Symbol(),0,i)); }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime Time(int i)
  {
   return(iTime(Symbol(),0,i));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double HighOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
//Searches for the bar by time. 
//The function returns High price of the bar with the specified time. 
//If there isn't a bar with the specified time (hole in the history), the function
//returns -1 or shift of the closest bar, depending on exact parameter

   return(MqlRatesMemberOnTime(symbol,timeframe,time,exact,HIGH));

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double LowOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
//Searches for the bar by time. 
//The function returns Low price of the bar with the specified time. 
//If there isn't a bar with the specified time (hole in the history), the function
//returns -1 or shift of the closest bar, depending on exact parameter

   return(MqlRatesMemberOnTime(symbol,timeframe,time,exact,LOW));

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CloseOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
//Searches for the bar by time. 
//The function returns Close price of the bar with the specified time. 
//If there isn't a bar with the specified time (hole in the history), the function
//returns -1 or shift of the closest bar, depending on exact parameter

   return(MqlRatesMemberOnTime(symbol,timeframe,time,exact,CLOSE));

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double OpenOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
//Searches for the bar by time. 
//The function returns Open price of the bar with the specified time.
//If there isn't a bar with the specified time (hole in the history), the function
//returns -1 or shift of the closest bar, depending on exact parameter

   return(MqlRatesMemberOnTime(symbol,timeframe,time,exact,OPEN));

  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string SPeriod(ENUM_TIMEFRAMES tf)
  {  //string description of the period
   if(tf==PERIOD_M1) return("M1");
   else if(tf==PERIOD_M2) return("M2");
   else if(tf==PERIOD_M3) return("M3");
   else if(tf==PERIOD_M4) return("M4");
   else if(tf==PERIOD_M5) return("M5");
   else if(tf==PERIOD_M6) return("M6");
   else if(tf==PERIOD_M10) return("M10");
   else if(tf==PERIOD_M12) return("M12");
   else if(tf==PERIOD_M15) return("M15");
   else if(tf==PERIOD_M20) return("M20");
   else if(tf==PERIOD_M30) return("M30");
   else if(tf==PERIOD_H1) return("H1");
   else if(tf==PERIOD_H2) return("H2");
   else if(tf==PERIOD_H3) return("H3");
   else if(tf==PERIOD_H4) return("H4");
   else if(tf==PERIOD_H6) return("H6");
   else if(tf==PERIOD_H8) return("H8");
   else if(tf==PERIOD_H12) return("H12");
   else if(tf==PERIOD_D1) return("D1");
   else if(tf==PERIOD_W1) return("W1");
   else if(tf==PERIOD_MN1) return("MN1");
   return("no");
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime iTime(const string symbol,int tf,int ind)
  {
   if(ind<0) return(-1);
   ENUM_TIMEFRAMES timeframe=tf;
   datetime Arr[];
   if(CopyTime(symbol,timeframe,ind,1,Arr)>0)
     {
      return(Arr[0]);
     }
   else return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iBarOnTime(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
//The function searches for the number of bar on the specified timeframe by the specified time.
//If there isn't a bar with the specified time (hole in the history), the function
//returns -1 or shift of the closest bar, depending on exact parameter.

   if(time<0) return(-1);
//sorry, exact will always =true in this code of mines. no exact=false yet.
   datetime Arr[];
   datetime passedtime=time;
   long ps=PeriodSeconds(timeframe);
   long rest= time%ps;
   if(rest!=0)
     {
      time=time-rest;
     }
   int ind=0;

   datetime it=iTime(symbol,timeframe,ind);
   int cnt=CopyTime(symbol,timeframe,it,time,Arr);
//Print("ibarontime passed period:", SPeriod( timeframe), "rest=", rest, " passedtime=", passedtime, " convertedtime=", time, " cnttoret=", cnt, " itm=", it );
   if(cnt>0)
     {
      return(ArraySize(Arr)-1);
     }
   return(-1);


  }
enum ENUM_DIRECTION {ENUM_DIRECTION_UP=1,ENUM_DIRECTION_DN=-1,ENUM_DIRECTION_NONE=0 };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void delobjectsbyprefiks(string prefiks)
  {
//if( IsTesting() && IsOptimization() )return; 
   bool scanning=true;
   while(scanning)
     {
      bool flagwasdel=false;
      for(int i=ObjectsTotal(0)-1; i>=0; i--)
        {
         //debug( "try to delete for i="+i );    
         string name=ObjectName(0,i);
         if(StringSubstr(name,0,StringLen(prefiks))!=prefiks)continue;

         ObjectDelete(0,name);
         flagwasdel=true;
        }
      if(!flagwasdel)scanning=false;
     }

  }

#define ORDER_TYPE_NOT_DEFINED -1
//+------------------------------------------------------------------+
//| The same as the function Bars(), it doesn't need                 |
//| the history synchronization                                      |
//| Input : symbol - symbol name in the client terminal              |
//|         timeframe - symbol timeframe                             |
//| Output: None                                                     |
//| Note. : None                                                     |
//+------------------------------------------------------------------+
int BarsSinh(string symbol,ENUM_TIMEFRAMES  timeframe)
  {
   SynhronizeSeries(symbol,timeframe);
   return(Bars(symbol,timeframe));
  }
//+------------------------------------------------------------------+
//| The function synchronizes timeseries with the history            |
//| Input : symbol - symbol name in the client terminal              |
//|         tf     - symbol timeframe                                |
//| Output: None                                                     |
//| Note. : None                                                     |
//+------------------------------------------------------------------+
void SynhronizeSeries(string symbol,ENUM_TIMEFRAMES tf)
  {
   int fail_cnt=0;
   while(!IsStopped() && fail_cnt<100)
     {
      //--- wait for timeseries build
      while(!SeriesInfoInteger(symbol,tf,SERIES_SYNCHRONIZED) && !IsStopped()) Sleep(5);
      //--- ask for built bars
      datetime times[1];
      if(Bars(symbol,PERIOD_W1)>0)break;
      int copied=CopyTime(symbol,tf,0,1,times);
      if(copied<=0)
        {         //--- no more than 100 failed attempts
         fail_cnt++;
         Sleep(10);
        }
     }
  }
//+------------------------------------------------------------------------+
//| The function checks for the presence of history on the date start_date |
//| If it absent, it tries to donwload the history                         |
//| Input : symbol - symbol name in the client terminal                    |
//|         period - period of symbol                                      |
//|         start_date - starting date                                     |
//| Output: the details of the operation result can be found at            |
//|         http://www.mql5.com/ru/docs/series/timeseries_access           |
//| Note  : None                                                           |
//+------------------------------------------------------------------------+
int CheckLoadHistory(string symbol,ENUM_TIMEFRAMES period,datetime start_date)
  {
   datetime first_date=0;
   datetime times[100];
//--- check symbol & period
   if(symbol==NULL || symbol=="") symbol=Symbol();
   if(period==PERIOD_CURRENT)     period=Period();
//--- check if symbol is selected in the MarketWatch
   if(!SymbolInfoInteger(symbol,SYMBOL_SELECT))
     {
      if(GetLastError()==ERR_MARKET_UNKNOWN_SYMBOL) return(-1);
      SymbolSelect(symbol,true);
     }
//--- check if data is present
   SeriesInfoInteger(symbol,period,SERIES_FIRSTDATE,first_date);
   if(first_date>0 && first_date<=start_date) return(1);
//--- don't ask for load of its own data if it is an indicator
   if(MQL5InfoInteger(MQL5_PROGRAM_TYPE)==PROGRAM_INDICATOR && Period()==period && Symbol()==symbol)
      return(-4);
//--- second attempt
   if(SeriesInfoInteger(symbol,PERIOD_M1,SERIES_TERMINAL_FIRSTDATE,first_date))
     {
      //--- there is loaded data to build timeseries
      if(first_date>0)
        {
         //--- force timeseries build
         CopyTime(symbol,period,first_date+PeriodSeconds(period),1,times);
         //--- check date
         if(SeriesInfoInteger(symbol,period,SERIES_FIRSTDATE,first_date))
            if(first_date>0 && first_date<=start_date) return(2);
        }
     }
//--- max bars in chart from terminal options
   int max_bars=TerminalInfoInteger(TERMINAL_MAXBARS);
//--- load symbol history info
   datetime first_server_date=0;
   while(!SeriesInfoInteger(symbol,PERIOD_M1,SERIES_SERVER_FIRSTDATE,first_server_date) && !IsStopped())
      Sleep(5);
//--- fix start date for loading
   if(first_server_date>start_date) start_date=first_server_date;
   if(first_date>0 && first_date<first_server_date)
      Print("Warning: first server date",first_server_date,"for",symbol,"does not match to first series date",first_date);
//--- load data step by step

   int fail_cnt=0;
   while(!IsStopped())
     {
      //--- wait for timeseries build
      while(!SeriesInfoInteger(symbol,period,SERIES_SYNCHRONIZED) && !IsStopped())
         Sleep(5);
      //--- ask for built bars
      int bars=Bars(symbol,period);
      if(bars>0)
        {
         if(bars>=max_bars) return(-2);
         //--- ask for first date
         if(SeriesInfoInteger(symbol,period,SERIES_FIRSTDATE,first_date))
            if(first_date>0 && first_date<=start_date) return(0);
        }
      //--- copying of next part forces data loading
      int copied=CopyTime(symbol,period,bars,100,times);
      if(copied>0)
        {
         //--- check for data
         if(times[0]<=start_date)  return(0);
         if(bars+copied>=max_bars) return(-2);
         fail_cnt=0;
        }
      else
        {
         //--- no more than 100 failed attempts
         fail_cnt++;
         if(fail_cnt>=100) return(-5);
         Sleep(10);
        }
     }
//--- stopped
   return(-3);
  }
//+------------------------------------------------------------------+
//| returns the string description of the period                     |
//+------------------------------------------------------------------+
string GetPeriodName(ENUM_TIMEFRAMES period)
  {
   if(period==PERIOD_CURRENT) period=Period();
//---
   switch(period)
     {
      case PERIOD_M1:  return("M1");
      case PERIOD_M2:  return("M2");
      case PERIOD_M3:  return("M3");
      case PERIOD_M4:  return("M4");
      case PERIOD_M5:  return("M5");
      case PERIOD_M6:  return("M6");
      case PERIOD_M10: return("M10");
      case PERIOD_M12: return("M12");
      case PERIOD_M15: return("M15");
      case PERIOD_M20: return("M20");
      case PERIOD_M30: return("M30");
      case PERIOD_H1:  return("H1");
      case PERIOD_H2:  return("H2");
      case PERIOD_H3:  return("H3");
      case PERIOD_H4:  return("H4");
      case PERIOD_H6:  return("H6");
      case PERIOD_H8:  return("H8");
      case PERIOD_H12: return("H12");
      case PERIOD_D1:  return("Daily");
      case PERIOD_W1:  return("Weekly");
      case PERIOD_MN1: return("Monthly");
     }
//---
   return("unknown period");
  }


#define COT_ERROR_SYMBOL_NOT_SUPPORTED 1
#define COT_ERROR_CIT_NOT_SUPPORTED    2
#define COT_ERROR_LOAD_FILE            3


#define DOWNLDR_ERR_CALLINTERNENATTEMPCONNECT 101
#define DOWNLDR_ERR_CALLINTERNETNOPENW        102
#define DOWNLDR_ERR_CALLINTERNETOPENURLW      103
#define DOWNLDR_ERR_CALLHTTPQUERYINFOW        104
#define DOWNLDR_ERR_DEFINELEN                 105
//+------------------------------------------------------------------+
//| Returns string description of an error, defined by the user      |
//| Input : err_code - error code                                    |
//| Output: Error description                                        |
//| Note  : None                                                     |
//+------------------------------------------------------------------+
string MyErrorDescription(int err_code)
  {
   if(err_code>=ERR_USER_ERROR_FIRST && err_code<ERR_USER_ERROR_LAST)
     {
      err_code -= ERR_USER_ERROR_FIRST;
      if( err_code == COT_ERROR_SYMBOL_NOT_SUPPORTED)return( "The symbol is not supported");
      if( err_code == COT_ERROR_CIT_NOT_SUPPORTED)   return( "The CIT report is not supported");
      if( err_code == COT_ERROR_LOAD_FILE)           return( "Error in report file downloading");

      if( err_code == DOWNLDR_ERR_CALLINTERNENATTEMPCONNECT) return( "Error in call of InternetAttemptConnect()" );
      if( err_code == DOWNLDR_ERR_CALLINTERNETNOPENW       ) return( "Error in call of InternetOpenW()");
      if( err_code == DOWNLDR_ERR_CALLINTERNETOPENURLW     ) return( "Error in call of InternetOpenUrlW()");
      if( err_code == DOWNLDR_ERR_CALLHTTPQUERYINFOW       ) return( "Error in call of HttpQueryInfoW()");
      if( err_code == DOWNLDR_ERR_DEFINELEN                ) return( "The content length is unknown");
     }
   return(ErrorDescription(err_code));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct SYSTEMTIME
  {   //see http://msdn.microsoft.com/en-us/library/ms724950(VS.85).aspx
   ushort            wYear;
   ushort            wMonth;
   ushort            wDayOfWeek;
   ushort            wDay;
   ushort            wHour;
   ushort            wMinute;
   ushort            wSecond;
   ushort            wMilliseconds;
  };

#import "kernel32.dll"
void GetLocalTime(SYSTEMTIME &lpSystemTime);
#import
//+------------------------------------------------------------------+
//| Determines the system time                                       |
//| Input : None                                                     |
//| Output: Date and time as a variable of type datetime             |
//| Note  : Because the TimeLocal is emulated in Tester              |
//+------------------------------------------------------------------+
datetime GetWindowsLocalTime()
  {
   SYSTEMTIME lpSystemTime;
   GetLocalTime(lpSystemTime);
   MqlDateTime  dt_struct;
   dt_struct.year  = lpSystemTime.wYear;
   dt_struct.mon   = lpSystemTime.wMonth;
   dt_struct.day   = lpSystemTime.wDay;
   dt_struct.hour  = lpSystemTime.wHour;
   dt_struct.min   = lpSystemTime.wMinute;
   dt_struct.sec   = lpSystemTime.wSecond;
   return(StructToTime(dt_struct));
  }
//+------------------------------------------------------------------+
//| Returns the year from the value of type datetime                 |
//| Input : time - variable of datetime type                         |
//| Output: Year                                                     |
//| Note  : None                                                     |
//+------------------------------------------------------------------+
int TimeYear(datetime time)
  {
   MqlDateTime tstruct;
   TimeToStruct(time,tstruct);
   return(tstruct.year);
  }
//+------------------------------------------------------------------+
//| Returns file size                                                |
//| Input : filename  - name of the file                             |
//| Output: File size in bytes                                       |
//| Note  : None                                                     |
//+------------------------------------------------------------------+
ulong FileSize(string filename)
  {
   ulong fsize=0;
   if(FileIsExist(filename))
     {
      int fh=FileOpen(filename,FILE_BIN);
      if(fh>0)
        {
         fsize=FileSize(fh);
         FileClose(fh);
        }
     }
   return(fsize);
  }

// example: http://articles.mql4.com/ru/336
#import  "shell32.dll"  
int ShellExecuteW(
                  int hwnd,
                  string Operation,
                  string File,
                  string Parameters,
                  string Directory,
                  int ShowCmd);  // 0-hide window 3-show window 
#import
//+------------------------------------------------------------------+
//| The function extracts the file from the archive of .zip type     |
//| by calling the program "unzip.exe"                               |
//| Input : filename  - name of the archive file                     |
//|         pathtoextract - path to extract                          |
//| Output: true if successful, false in the case of an error        |
//| Note  : None                                                     |
//+------------------------------------------------------------------+
bool ExtractZip(string filename,string pathtoextract="")
  {
   string unzipperpath = TerminalInfoString(TERMINAL_DATA_PATH)+"\\mql5\\files";
   string unzipperexe  = "unzip.exe";
   string param=" -o "+filename;
   if(StringLen(pathtoextract)!=0)
     {
      param=param+" -d"+pathtoextract;
     }
//Print("Unpacking started: "+unzipperpath+" "+unzipperexe+" "+param );
   int   start=ShellExecuteW(0,"Open",unzipperexe,param,unzipperpath,0);
//Print("Unpacking complete");
//Print("Return code ", start );
// 2 - the file unzip.exe is absent
// 42 - ok
//
   return(start==42);
  }
//+------------------------------------------------------------------+