//+------------------------------------------------------------------+
//|                                                cotdownloader.mqh |
//|                                           Copyright 2010, Sergan |
//|                                               SerganMT@hotbox.ru |
//+------------------------------------------------------------------+
#property copyright "2010, Sergan"
#property link      "SerganMT@hotbox.ru"
//code portions from WININET_TEST.mq5, http://www.mql5.com/ru/code/82  

#include <common.mqh>

//+------------------------------------------------------------------+
//| Imported functions from wininet.dll                              |
//+------------------------------------------------------------------+
#import "wininet.dll"
int InternetAttemptConnect(int x);
int InternetOpenW(string sAgent,int lAccessType,
                  string sProxyName="",string sProxyBypass="",
                  int lFlags=0);
int InternetOpenUrlW(int hInternetSession,string sUrl,
                     string sHeaders="",int lHeadersLength=0,
                     int lFlags=0,int lContext=0);
int InternetReadFile(int hFile,uchar &sBuffer[],int lNumBytesToRead,
                     int &lNumberOfBytesRead[]);
int HttpQueryInfoW(int hRequest,int dwInfoLevel,
                   uchar &lpvBuffer[],int &lpdwBufferLength,int &lpdwIndex);
int InternetCloseHandle(int hInet);
#import
#define HTTP_QUERY_CONTENT_LENGTH 5
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum filedownloader_type_status
  {  //this type of data describes the state of the instance
   notinit,                        //not yet initialized
   inited,                         //initialized
   endofread                       //reading complete
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CFileDownLoader
  {  //Downloads file from the internet
private:
   string            url;             //url
   string            filename;        //resulted file name
   string            midlname;        //temporary file name
   filedownloader_type_status status; //object state
   int               hURL;
   int               BufLen;
   int               ind;
   uchar             buf0[2048];
   int               h;                // file handle
   int               hInternetSession;
   int               cnt;
   uchar             buffer[1024];
   bool              isdownloadsuccess;//flag of successful downloading
public:

   void CFileDownLoader(){status=notinit; };
   void ~CFileDownLoader(){  Deinit();  }
   bool              Init( string URLpassed, string saveto );  //Initialization
   void              Deinit();                                 //Closes file and deleles temporary file
   bool              ExecuteDownload();                        //Download execution
   bool              Status();                                 //Returns downloading status
   int               SizeOfFile();                             //Returns file size to download
   bool              IsEnd();                                  //Check for the end of data
   int  BytesDownLoaded(){return(cnt);}                        //Number of bytes downloaded
   bool IsDownLoadSuccess(){ return(isdownloadsuccess); }      //Flag of successful downloading
  };
//+-----------------------------------------------------------------+
//| Returns the downloading state                                   |
//| Input  : None                                                   |
//| Output : true, if successful, false if there was an error       |
//| Note   : None                                                   | 
//+-----------------------------------------------------------------+
bool CFileDownLoader::ExecuteDownload()
  {
   while(!IsEnd());
   return(IsDownLoadSuccess());
  }
//+-----------------------------------------------------------------+
//| Checking for the end of data downloading                        |
//| Input : None                                                    |
//| Output: true, if downloading complete,                          |
//|         false - if it isn't yet completed                       |
//| Note  : While calling this function, it downloads part of data  | 
//+-----------------------------------------------------------------+
bool CFileDownLoader::IsEnd()
  {

   if(status!=inited)return(true);

   int dwBytesRead[1];

   bool bResult=InternetReadFile(hURL,buffer,1024,dwBytesRead);

   cnt+=dwBytesRead[0];

//Print("Last downloading result ", bResult );

   if(dwBytesRead[0]!=0)
     {
      FileWriteArray(h,buffer,0,dwBytesRead[0]);
      return(false);
     }
// while reading the current portion of data 0 byte has downloaded
   Deinit(); // it means that we have to finish downloading
   status=endofread;
   isdownloadsuccess=bResult;
//maybe an error occured during the file downloading
   if(!bResult)
     { //in case of error, the downloaded file should be deleted
      FileDelete(midlname);
        }else{
      bResult=FileCopy(midlname,0,filename,FILE_REWRITE);
     }
   isdownloadsuccess=bResult;

   return(true);
  }
//+-----------------------------------------------------------------+
//| Initialization                                                  |
//| Input : URL - url reference to download                         |
//|         saveto - target file name to save the data downloaded   |
//| Output: true - if successful, false - in the case of an error   |
//| Note  : the error code is set into the variable _LastError      | 
//+-----------------------------------------------------------------+
bool CFileDownLoader::Init(string urlpassed,string saveto)
  {
   if(status!=notinit) Deinit(); // deinit if we haven't deinitialized since last call
   url=urlpassed;
   filename=saveto;
   BufLen = 2048; ind = 0; cnt= 0;
   int rv = InternetAttemptConnect(0);
   if(rv!=0)
     {
      SetUserError(DOWNLDR_ERR_CALLINTERNENATTEMPCONNECT);
      return(false);
     }
   hInternetSession=InternetOpenW("Microsoft Internet Explorer",0,"","",0);
   if(hInternetSession<=0)
     {
      SetUserError(DOWNLDR_ERR_CALLINTERNETNOPENW);
      return(false);
     }
   string addr=url;
   hURL=InternetOpenUrlW(hInternetSession,addr,"",0,0,0);
   if(hURL<=0)
     {
      SetUserError(DOWNLDR_ERR_CALLINTERNETOPENURLW);
      InternetCloseHandle(hInternetSession);
      return(false);
     }

   midlname="loadingcotmidlfile";
   h=FileOpen(midlname,FILE_BIN|FILE_WRITE);
   if(h<=0)
     {
      return(false);
     }

   status=inited;
   return(true);
  }
//+-----------------------------------------------------------------+
//| Request for file size, that we have to download                 |
//| Input : None                                                    |
//| Output: File size, 0 - if file size is unknown                  |
//| Note  : the code of an error is in the variable _LastError      | 
//+-----------------------------------------------------------------+
int CFileDownLoader::SizeOfFile()
  {
   if(status!=inited)return(0); //the object isn't initialized
   ResetLastError();
   int iRes;
   iRes=HttpQueryInfoW(hURL,HTTP_QUERY_CONTENT_LENGTH,buf0,BufLen,ind);
   int ContentSize_HttpQueryInfoW=0;
   string s;
   if(iRes<=0)
     {
      SetUserError(DOWNLDR_ERR_CALLHTTPQUERYINFOW);
      return(0);
        }else{
      s="";
      for(int k=0;k<BufLen;k++) { s=s+CharToString(buf0[k]);}
      if(StringLen(s)>0) ContentSize_HttpQueryInfoW=(int)StringToInteger(s);
     }
   if(ContentSize_HttpQueryInfoW>0)
     {
      return(ContentSize_HttpQueryInfoW);
        }else{
      SetUserError(DOWNLDR_ERR_DEFINELEN);
      return(0);
     }
  }
//+-----------------------------------------------------------------+
//| The function closes file and session handle                     |
//| Input : None                                                    |
//| Output: None                                                    |
//| Note  : None                                                    | 
//+-----------------------------------------------------------------+
void CFileDownLoader::Deinit()
  {
   if(status==inited)
     {
      if(h>0) FileClose(h);
      if(cnt==0) FileDelete(midlname);
      InternetCloseHandle(hInternetSession);
     }
   status=notinit;
  }
//+------------------------------------------------------------------+