-- coint_eg definition

CREATE TABLE coint_eg (
	tstamp INTEGER NOT NULL,
	ref_ticker TEXT CHECK(LENGTH(ref_ticker) <= 10) NOT NULL,
	coint_ticker TEXT CHECK(LENGTH(coint_ticker) <= 10) NOT NULL,
	timeframe TEXT CHECK(LENGTH(timeframe) <= 10) NOT NULL,
	lookback INTEGER NOT NULL,
	pvalue REAL NOT NULL,
	test_stat REAL NOT NULL,
	crit_val_1 REAL NOT NULL,
	crit_val_5 REAL NOT NULL,
	crit_val_10 REAL NOT NULL,
	hedge_ratio REAL,
	is_coint INTEGER NOT NULL,
CONSTRAINT coint_eg_pk PRIMARY KEY(tstamp, ref_ticker, coint_ticker)
) STRICT;


-- coint_johansen_test definition

CREATE TABLE coint_johansen_test (
	test_id INTEGER PRIMARY KEY AUTOINCREMENT,
	tstamp INTEGER NOT NULL,
	timeframe TEXT CHECK(LENGTH(timeframe) <= 10) NOT NULL,
	lookback INTEGER NOT NULL,
	num_assets INTEGER NOT NULL,
	trace_stats_json TEXT NOT NULL,
	trace_crit_vals_json TEXT NOT NULL,
	eigen_stats_json TEXT NOT NULL,
	eigen_crit_vals_json TEXT NOT NULL,
	coint_rank INTEGER NOT NULL, 'coint_vectors_json' TEXT,
	CONSTRAINT coint_johansen_test_unique UNIQUE (tstamp, timeframe, lookback)
) STRICT;


-- corr_pearson definition

CREATE TABLE corr_pearson (
	tstamp INTEGER NOT NULL,
	ref_ticker TEXT CHECK(LENGTH(ref_ticker) <= 10) NOT NULL,
	corr_ticker TEXT CHECK(LENGTH(corr_ticker) <= 10) NOT NULL,
	timeframe TEXT CHECK(LENGTH(timeframe) <= 10) NOT NULL,
	lookback INTEGER NOT NULL,
	coefficient REAL NOT NULL,
CONSTRAINT corr_pearson_pk PRIMARY KEY(tstamp, ref_ticker, corr_ticker)
) STRICT;


-- strategy definition

CREATE TABLE "strategy" (
tstamp INTEGER,
test_id INTEGER,
	name TEXT CHECK(LENGTH(name) <= 20) NOT NULL,
	symbols TEXT CHECK(LENGTH(symbols) <= 255) NOT NULL,
	weights TEXT CHECK(LENGTH(weights) <= 255),
	timeframe TEXT CHECK (
        timeframe IN (
            'M1',
            'M2',
            'M3',
            'M4',
            'M5',
            'M6',
            'M10',
            'M12',
            'M15',
            'M20',
            'M30',
            'H1',
            'H2',
            'H3',
            'H4',
            'H6',
            'H8',
            'H12',
            'D1',
            'W1',
            'MN1'
        )
    ), lookback INTEGER DEFAULT (0) NOT NULL,
	CONSTRAINT strategy_pk PRIMARY KEY (tstamp, test_id)
) WITHOUT ROWID,STRICT;


-- symbol definition

CREATE TABLE symbol(
    symbol_id INTEGER PRIMARY KEY,
    ticker TEXT CHECK(LENGTH(ticker) <= 10) NOT NULL,
    exchange TEXT CHECK(LENGTH(exchange) <= 50) NOT NULL,
    asset_type TEXT CHECK(LENGTH(asset_type) <= 50),
    sector TEXT CHECK(LENGTH(sector) <= 50),
    industry TEXT CHECK(LENGTH(industry) <= 50),
    currency TEXT CHECK(LENGTH(currency) <= 10)
, source TEXT CHECK(LENGTH('source') <= 50) DEFAULT ('MetaQuotes') NOT NULL) STRICT;


-- coint_adf_kpss definition

CREATE TABLE "coint_adf_kpss" (
	test_id INTEGER NOT NULL,
	symbol_id INTEGER NOT NULL,
	adf_stat REAL NOT NULL,
	adf_pvalue REAL NOT NULL,
	is_adf_stationary INTEGER NOT NULL,
	kpss_stat REAL NOT NULL,
	kpss_pvalue REAL NOT NULL,
	is_kpss_stationary INTEGER NOT NULL,
	CONSTRAINT coint_adf_kpss_pk PRIMARY KEY (test_id, symbol_id),
	CONSTRAINT coint_adf_kpss_test_fk FOREIGN KEY (test_id) REFERENCES coint_johansen_test(test_id) ON DELETE CASCADE,
	CONSTRAINT coint_adf_kpss_symbol_fk FOREIGN KEY (symbol_id) REFERENCES symbol(symbol_id) ON DELETE CASCADE
) STRICT;


-- coint_johansen_test_assets definition

CREATE TABLE coint_johansen_test_assets (
	test_id INTEGER NOT NULL,
	symbol_id INTEGER NOT NULL,
	CONSTRAINT coint_johansen_test_assets_pk PRIMARY KEY(test_id, symbol_id),
	CONSTRAINT coint_johansen_test_assets_test_fk FOREIGN KEY(test_id) REFERENCES coint_johansen_test(test_id) ON DELETE CASCADE,
	CONSTRAINT coint_johansen_test_assets_symbol_fk FOREIGN KEY(symbol_id) REFERENCES symbol(symbol_id) ON DELETE CASCADE
) STRICT;


-- corporate_event definition

CREATE TABLE "corporate_event"(
    tstamp INTEGER PRIMARY KEY,
    event_type TEXT CHECK(event_type IN ('dividend', 'split', 'earnings')) NOT NULL,
    event_value REAL,
    details TEXT CHECK(LENGTH(details) <= 255),
    symbol_id INTEGER NOT NULL,
    FOREIGN KEY(symbol_id) REFERENCES symbol(symbol_id)
) STRICT;


-- market_data definition

CREATE TABLE "market_data" (
    tstamp INTEGER,
    timeframe TEXT CHECK (
        timeframe IN (
            'M1',
            'M2',
            'M3',
            'M4',
            'M5',
            'M6',
            'M10',
            'M12',
            'M15',
            'M20',
            'M30',
            'H1',
            'H2',
            'H3',
            'H4',
            'H6',
            'H8',
            'H12',
            'D1',
            'W1',
            'MN1'
        )
    ) NOT NULL,
    price_open REAL NOT NULL,
    price_high REAL NOT NULL,
    price_low REAL NOT NULL,
    price_close REAL NOT NULL,
    tick_volume INTEGER,
    real_volume INTEGER,
    spread REAL,
    symbol_id INTEGER NOT NULL,
    CONSTRAINT market_data_pk PRIMARY KEY (tstamp, timeframe, symbol_id),
    CONSTRAINT market_data_symbol_fk FOREIGN KEY (symbol_id) REFERENCES symbol(symbol_id) ON DELETE CASCADE ON UPDATE CASCADE
) STRICT;


-- trade definition

CREATE TABLE trade(
    tstamp INTEGER PRIMARY KEY,
    ticket INTEGER NOT NULL,
    side TEXT CHECK(side IN ('buy', 'sell')) NOT NULL,
    quantity INTEGER CHECK(quantity > 0) NOT NULL,
    price REAL CHECK(price >= 0) NOT NULL,
    strategy TEXT CHECK(LENGTH(strategy) <= 50),
    symbol_id INTEGER NOT NULL,
    FOREIGN KEY(symbol_id) REFERENCES symbol(symbol_id)
) STRICT;

-- index to speed up queries on corr_pearson table by timeframe and lookback
-- CREATE INDEX idx_corr_pearson_timeframe_lookback ON corr_pearson (timeframe, lookback);
-- index to speed up queries on coint_eg table by timeframe and lookback
-- CREATE INDEX idx_coint_eg_timeframe_lookback ON coint_eg (timeframe, lookback);
-- index to speed up queries on market_data table by timeframe  and symbol_id
-- CREATE INDEX idx_market_data_timeframe_symbol ON market_data (timeframe, symbol_id);