//+------------------------------------------------------------------+
//|                          Project 13 Gartley Hermonic Pattern.mq5 |
//|                                             Abioye Israel Pelumi |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"
#include <Trade/Trade.mqh>
CTrade trade;
input int MagicNumber = 61626;
input ENUM_TIMEFRAMES timeframe = PERIOD_CURRENT; // TIMEFRAME
input double lot_size = 0.6;

input double b_xa_max = 65; // MAX B RETRACEMENT LEVEL FOR XA
input double b_xa_min = 60; // MIN B RETRACEMENT LEVEL FOR XA

input double c_ab_max = 88.6; // MAX C RETRACEMENT LEVEL FOR AB
input double c_ab_min = 38.2; // MIN C RETRACEMENT LEVEL FOR AB

input double d_xa_max = 79.0; // MAX D RETRACEMENT LEVEL FOR XA
input double d_xa_min = 77.0; // MIN D RETRACEMENT LEVEL FOR XA


double X;
datetime X_time;
string X_line;
string X_letter;

double A;
datetime A_time;
string A_line;
string A_letter;

double B;
datetime B_time;
string B_line;
string B_letter;

double C;
datetime C_time;
string C_line;
string C_letter;

double D;
datetime D_time;
string D_line;
string D_letter;

double open[];
double close[];
double low[];
double high[];
datetime time[];

datetime time_bar;
int bars_check = 500;
int total_symbol_bars;

int z = 4;

string xa_line;
string ab_line;
string bc_line;
string cd_line;

ulong chart_id = ChartID();

int c_d_bars;
int c_highest_index;
double c_d_hh;
datetime c_d_hh_t;

int c_lowest_index;
double c_d_ll;
datetime c_d_ll_t;


int b_c_bars;
int b_lowest_index;
double b_c_ll;
datetime b_c_ll_t;

int b_highest_index;
double b_c_hh;
datetime b_c_hh_t;

double B_low;
double B_high;

int a_b_bars;
int a_highest_index;
double a_b_hh;
datetime a_b_hh_t;
double A_low;

int a_lowest_index;
double a_b_ll;
datetime a_b_ll_t;
double A_high;


int x_a_bars;
int x_lowest_index;
double x_a_ll;
datetime x_a_ll_t;

int x_highest_index;
double x_a_hh;
datetime x_a_hh_t;

double lvl_max_b;
double lvl_min_b;

double lvl_max_c;
double lvl_min_c;

double lvl_max_d;
double lvl_min_d;

string b_zone;
string c_zone;
string d_zone;

datetime time_price[];

double ask_price;

datetime lastTradeBarTime = 0;
double take_p;

string XAB;
string BCD;

string xd_line;
string ac_line;


//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   trade.SetExpertMagicNumber(MagicNumber);
   ArraySetAsSeries(time_price,true);

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   ObjectsDeleteAll(chart_id);

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   total_symbol_bars = Bars(_Symbol, timeframe);
   time_bar = iTime(_Symbol, timeframe, 0);
   CopyOpen(_Symbol, timeframe, time_bar, bars_check, open);
   CopyClose(_Symbol, timeframe, time_bar, bars_check, close);
   CopyLow(_Symbol, timeframe, time_bar, bars_check, low);
   CopyHigh(_Symbol, timeframe, time_bar, bars_check, high);
   CopyTime(_Symbol, timeframe, time_bar, bars_check, time);

   CopyTime(_Symbol, timeframe, 0, 2, time_price);

   ask_price = SymbolInfoDouble(_Symbol,SYMBOL_ASK);

   datetime currentBarTime = iTime(_Symbol,timeframe,0);

   if(total_symbol_bars >= bars_check && currentBarTime != lastTradeBarTime)
     {

      for(int i = z ; i < bars_check - z; i++)
        {

         if(IsSwingHigh(high, i, z))
           {

            for(int j = i; j < bars_check - z; j++)
              {

               if(IsSwingLow(low, j, z) && low[j] < high[i])
                 {

                  A = low[j];
                  A_time = time[j];
                  A_letter = StringFormat("A %d",j);

                  for(int k = j; k < bars_check - z; k++)
                    {

                     if(IsSwingHigh(high, k, z) && high[k] > A)
                       {

                        B = high[k];
                        B_time = time[k];
                        B_letter =  StringFormat("B %d",k);

                        for(int a = j; a >= i; a--)
                          {

                           if(IsSwingHigh(high, a, z) && high[a] > B)
                             {
                              X = high[a];
                              X_time = time[a];
                              X_letter = StringFormat("X  %d",a);


                              for(int l = k; l < bars_check - z; l++)
                                {

                                 if(IsSwingLow(low, l, z) && low[l] < B)
                                   {

                                    C = low[l];
                                    C_time = time[l];
                                    C_letter = StringFormat("C  %d",l);



                                    for(int m = l; m < bars_check - z; m++)
                                      {

                                       if(IsSwingHigh(high, m, z) && high[m] > B)
                                         {


                                          D = high[m];
                                          D_time = time[m];
                                          D_letter = StringFormat("C  %d",m);

                                          c_d_bars = Bars(_Symbol,PERIOD_CURRENT,C_time,D_time);
                                          c_lowest_index = ArrayMinimum(low,l,c_d_bars);
                                          c_d_ll = low[c_lowest_index];
                                          c_d_ll_t = time[c_lowest_index];

                                          b_c_bars = Bars(_Symbol, PERIOD_CURRENT, B_time, c_d_ll_t);
                                          b_highest_index = ArrayMaximum(high, k, b_c_bars);
                                          b_c_hh = high[b_highest_index];
                                          b_c_hh_t = time[b_highest_index];

                                          a_b_bars = Bars(_Symbol,PERIOD_CURRENT,A_time,b_c_hh_t);
                                          a_lowest_index = ArrayMinimum(low,j,a_b_bars);
                                          a_b_ll = low[a_lowest_index];
                                          a_b_ll_t = time[a_lowest_index];

                                          x_a_bars = Bars(_Symbol, PERIOD_CURRENT, X_time, a_b_ll_t);
                                          x_highest_index = ArrayMaximum(high, a, x_a_bars);
                                          x_a_hh = high[x_highest_index];
                                          x_a_hh_t = time[x_highest_index];

                                          lvl_min_b = a_b_ll + ((b_xa_min / 100) * (x_a_hh - a_b_ll));
                                          lvl_max_b = a_b_ll + ((b_xa_max / 100) * (x_a_hh - a_b_ll));

                                          lvl_min_c = b_c_hh - ((c_ab_min / 100) * (b_c_hh - a_b_ll));
                                          lvl_max_c = b_c_hh - ((c_ab_max / 100) * (b_c_hh - a_b_ll));


                                          lvl_min_d = a_b_ll + ((d_xa_min / 100) * (x_a_hh - a_b_ll));
                                          lvl_max_d = a_b_ll + ((d_xa_max / 100) * (x_a_hh - a_b_ll));

                                          if(b_c_hh >= lvl_min_b && b_c_hh <= lvl_max_b && c_d_ll <= lvl_min_c && c_d_ll >= lvl_max_c
                                             && D >= lvl_min_d && D <= lvl_max_d)
                                            {

                                             xa_line = StringFormat("XA Line  %d",i);
                                             ab_line = StringFormat("AB Line  %d",i);
                                             bc_line = StringFormat("BC Line  %d",i);
                                             cd_line = StringFormat("CD Line  %d",i);


                                             ObjectCreate(chart_id,xa_line,OBJ_TREND,0,x_a_hh_t,x_a_hh, a_b_ll_t,a_b_ll);
                                             ObjectCreate(chart_id,ab_line,OBJ_TREND,0, a_b_ll_t,a_b_ll, b_c_hh_t,b_c_hh);
                                             ObjectCreate(chart_id,bc_line,OBJ_TREND,0, b_c_hh_t,b_c_hh, c_d_ll_t,c_d_ll);
                                             ObjectCreate(chart_id,cd_line,OBJ_TREND,0, c_d_ll_t,c_d_ll, D_time,D);

                                             ObjectSetInteger(chart_id,xa_line,OBJPROP_COLOR,clrBlue);
                                             ObjectSetInteger(chart_id,bc_line,OBJPROP_COLOR,clrYellow);
                                             ObjectSetInteger(chart_id,cd_line,OBJPROP_COLOR,clrPink);



                                             b_zone = StringFormat("B ZONE %d",i);

                                             ObjectCreate(chart_id,b_zone,OBJ_RECTANGLE,0,x_a_hh_t,lvl_max_b,b_c_hh_t,lvl_min_b);
                                             ObjectSetInteger(chart_id,b_zone,OBJPROP_COLOR,clrBlue);

                                             c_zone = StringFormat("C ZONE %d",i);
                                             ObjectCreate(chart_id,c_zone,OBJ_RECTANGLE,0,a_b_ll_t,lvl_max_c,c_d_ll_t,lvl_min_c);
                                             ObjectSetInteger(chart_id,c_zone,OBJPROP_COLOR,clrBlue);

                                             d_zone = StringFormat("D ZONE %d",i);
                                             ObjectCreate(chart_id,d_zone,OBJ_RECTANGLE,0,x_a_hh_t,lvl_max_d,D_time,lvl_min_d);
                                             ObjectSetInteger(chart_id,d_zone,OBJPROP_COLOR,clrBlue);

                                             XAB = StringFormat("XAB TRIANGLE %d", i);
                                             BCD = StringFormat("BCD TRIANGLE %d", i);



                                             ObjectCreate(chart_id,XAB,OBJ_TRIANGLE,0,x_a_hh_t,x_a_hh,a_b_ll_t,a_b_ll,b_c_hh_t,b_c_hh);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_FILL,true);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_COLOR,clrPink);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_BACK,true);

                                             ObjectCreate(chart_id,BCD,OBJ_TRIANGLE,0,b_c_hh_t,b_c_hh,c_d_ll_t,c_d_ll,D_time,D);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_FILL,true);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_COLOR,clrPink);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_BACK,true);

                                             xd_line = StringFormat("XD LINE %d", i);
                                             ac_line = StringFormat("AC %d", i);

                                             ObjectCreate(chart_id,xd_line,OBJ_TREND,0,x_a_hh_t,x_a_hh,D_time,D);
                                             ObjectSetInteger(chart_id,xd_line,OBJPROP_COLOR,clrPink);
                                             ObjectSetInteger(chart_id,xd_line,OBJPROP_WIDTH,2);

                                             ObjectCreate(chart_id,ac_line,OBJ_TREND,0,a_b_ll_t,a_b_ll,c_d_ll_t,c_d_ll);
                                             ObjectSetInteger(chart_id,ac_line,OBJPROP_COLOR,clrPink);
                                             ObjectSetInteger(chart_id,ac_line,OBJPROP_WIDTH,2);






                                             if(time[m+z] == time_price[1])
                                               {



                                               
                                                take_p = ask_price - (MathAbs(D - ask_price) * 3);

                                                trade.Sell(lot_size,_Symbol,ask_price,D,take_p);






                                               }


                                            }





                                          break;
                                         }
                                      }


                                    break;
                                   }
                                }


                              break;
                             }
                          }


                        break;
                       }

                    }

                  break;
                 }


              }

           }

        }



      //BUY

      for(int i = z ; i < bars_check - z; i++)
        {

         if(IsSwingLow(low, i, z))
           {

            for(int j = i; j < bars_check - z; j++)
              {

               if(IsSwingHigh(high, j, z) && high[j] > low[i])
                 {

                  A = high[j];
                  A_time = time[j];
                  A_letter = StringFormat("A B%d",j);

                  for(int k = j; k < bars_check - z; k++)
                    {

                     if(IsSwingLow(low, k, z) && low[k] < A)
                       {

                        B = low[k];
                        B_time = time[k];
                        B_letter =  StringFormat("B B%d",k);

                        for(int a = j; a >= i; a--)
                          {

                           if(IsSwingLow(low, a, z) && low[a] < B)
                             {

                              X = low[a];
                              X_time = time[a];
                              X_letter = StringFormat("X B%d",a);

                              for(int l = k; l < bars_check - z; l++)
                                {

                                 if(IsSwingHigh(high, l, z) && high[l] > B)
                                   {

                                    C = high[l];
                                    C_time = time[l];
                                    C_letter = StringFormat("C B%d",l);

                                    for(int m = l; m < bars_check - z; m++)
                                      {

                                       if(IsSwingLow(low, m, z) && low[m] < B)
                                         {

                                          D = low[m];
                                          D_time = time[m];
                                          D_letter = StringFormat("C B%d",m);

                                          c_d_bars = Bars(_Symbol,PERIOD_CURRENT,C_time,D_time);
                                          c_highest_index = ArrayMaximum(high,l,c_d_bars);
                                          c_d_hh = high[c_highest_index];
                                          c_d_hh_t = time[c_highest_index];

                                          b_c_bars = Bars(_Symbol, PERIOD_CURRENT, B_time, c_d_hh_t);  
                                          b_lowest_index = ArrayMinimum(low, k, b_c_bars);  
                                          b_c_ll = low[b_lowest_index];  
                                          b_c_ll_t = time[b_lowest_index];  

                                          a_b_bars = Bars(_Symbol,PERIOD_CURRENT,A_time,b_c_ll_t);
                                          a_highest_index = ArrayMaximum(high,j,a_b_bars);
                                          a_b_hh = high[a_highest_index];
                                          a_b_hh_t = time[a_highest_index];

                                          x_a_bars = Bars(_Symbol, PERIOD_CURRENT, X_time, a_b_hh_t);  
                                          x_lowest_index = ArrayMinimum(low, a, x_a_bars);  
                                          x_a_ll = low[x_lowest_index];  
                                          x_a_ll_t = time[x_lowest_index]; 

                                          lvl_min_b = a_b_hh - ((b_xa_min / 100) * (a_b_hh - x_a_ll));
                                          lvl_max_b = a_b_hh - ((b_xa_max / 100) * (a_b_hh - x_a_ll));

                                          lvl_min_c = b_c_ll + ((c_ab_min / 100) * (a_b_hh - b_c_ll));
                                          lvl_max_c = b_c_ll + ((c_ab_max / 100) * (a_b_hh - b_c_ll));


                                          lvl_min_d = a_b_hh - ((d_xa_min / 100) * (a_b_hh - x_a_ll));
                                          lvl_max_d = a_b_hh - ((d_xa_max / 100) * (a_b_hh - x_a_ll));

                                          if(b_c_ll <= lvl_min_b && b_c_ll >= lvl_max_b && c_d_hh >= lvl_min_c && c_d_hh <= lvl_max_c
                                             && D <= lvl_min_d && D >= lvl_max_d)
                                            {

                                             xa_line = StringFormat("XA Line  B %d",i);
                                             ab_line = StringFormat("AB Line B %d",i);
                                             bc_line = StringFormat("BC Line B %d",i);
                                             cd_line = StringFormat("CD Line B %d",i);

                                             ObjectCreate(chart_id,xa_line,OBJ_TREND,0,x_a_ll_t,x_a_ll, a_b_hh_t,a_b_hh);
                                             ObjectCreate(chart_id,ab_line,OBJ_TREND,0, a_b_hh_t,a_b_hh, b_c_ll_t,b_c_ll);
                                             ObjectCreate(chart_id,bc_line,OBJ_TREND,0, b_c_ll_t,b_c_ll, c_d_hh_t,c_d_hh);
                                             ObjectCreate(chart_id,cd_line,OBJ_TREND,0, c_d_hh_t,c_d_hh, D_time,D);

                                             ObjectSetInteger(chart_id,xa_line,OBJPROP_COLOR,clrBlue);
                                             ObjectSetInteger(chart_id,bc_line,OBJPROP_COLOR,clrYellow);
                                             ObjectSetInteger(chart_id,cd_line,OBJPROP_COLOR,clrPink);


                                             b_zone = StringFormat("B ZONE B %d",i);

                                             ObjectCreate(chart_id,b_zone,OBJ_RECTANGLE,0,x_a_ll_t,lvl_max_b,b_c_ll_t,lvl_min_b);
                                             ObjectSetInteger(chart_id,b_zone,OBJPROP_COLOR,clrBlue);

                                             c_zone = StringFormat("C ZONE B %d",i);
                                             ObjectCreate(chart_id,c_zone,OBJ_RECTANGLE,0,a_b_hh_t,lvl_max_c,c_d_hh_t,lvl_min_c);
                                             ObjectSetInteger(chart_id,c_zone,OBJPROP_COLOR,clrBlue);

                                             d_zone = StringFormat("D ZONE B %d",i);
                                             ObjectCreate(chart_id,d_zone,OBJ_RECTANGLE,0,x_a_ll_t,lvl_max_d,D_time,lvl_min_d);
                                             ObjectSetInteger(chart_id,d_zone,OBJPROP_COLOR,clrBlue);

                                             XAB = StringFormat("XAB TRIANGLE B %d", i);
                                             BCD = StringFormat("BCD TRIANGLE B %d", i);



                                             ObjectCreate(chart_id,XAB,OBJ_TRIANGLE,0,x_a_ll_t,x_a_ll,a_b_hh_t,a_b_hh,b_c_ll_t,b_c_ll);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_FILL,true);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_COLOR,clrDarkSlateGray);
                                             ObjectSetInteger(chart_id,XAB,OBJPROP_BACK,true);

                                             ObjectCreate(chart_id,BCD,OBJ_TRIANGLE,0,b_c_ll_t,b_c_ll,c_d_hh_t,c_d_hh,D_time,D);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_FILL,true);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_COLOR,clrDarkSlateGray);
                                             ObjectSetInteger(chart_id,BCD,OBJPROP_BACK,true);

                                             xd_line = StringFormat("XD LINE B%d", i);
                                             ac_line = StringFormat("AC B%d", i);

                                             ObjectCreate(chart_id,xd_line,OBJ_TREND,0,x_a_ll_t,x_a_ll,D_time,D);
                                             ObjectSetInteger(chart_id,xd_line,OBJPROP_COLOR,clrDarkSlateGray);
                                             ObjectSetInteger(chart_id,xd_line,OBJPROP_WIDTH,2);

                                             ObjectCreate(chart_id,ac_line,OBJ_TREND,0,a_b_hh_t,a_b_hh,c_d_hh_t,c_d_hh);
                                             ObjectSetInteger(chart_id,ac_line,OBJPROP_COLOR,clrDarkSlateGray);
                                             ObjectSetInteger(chart_id,ac_line,OBJPROP_WIDTH,2);
                                             
                                             
                                             if(time[m+z] == time_price[1])
                                               {
                                               
                                               take_p = ask_price + (MathAbs(ask_price - D) * 3);
                                               trade.Buy(lot_size,_Symbol,ask_price,D,take_p);

                                               
                                               }






                                            }





                                          break;
                                         }
                                      }



                                    break;
                                   }
                                }


                              break;
                             }
                          }


                        break;
                       }
                    }

                  break;
                 }

              }

           }

        }


      lastTradeBarTime = currentBarTime;

     }



  }
  



//+------------------------------------------------------------------+
//| FUNCTION FOR SWING LOW                                           |
//+------------------------------------------------------------------+
bool IsSwingLow(const double &low_price[], int index, int lookback)
  {
   for(int i = 1; i <= lookback; i++)
     {
      if(low_price[index] > low_price[index - i] || low_price[index] > low_price[index + i])
         return false;
     }
   return true;
  }


//+------------------------------------------------------------------+
//| FUNCTION FOR SWING HIGH                                          |
//+------------------------------------------------------------------+
bool IsSwingHigh(const double &high_price[], int index, int lookback)
  {
   for(int i = 1; i <= lookback; i++)
     {
      if(high_price[index] < high_price[index - i] || high_price[index] < high_price[index + i])
         return false; // If the current high is not the highest, return false.
     }
   return true;
  }
//+------------------------------------------------------------------+
