//+------------------------------------------------------------------+
//|                                       SSA_Decomposition_Demo.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include<np.mqh>
#include<ssa.mqh>
//--- input parameters
input ulong    SizeOfSeries=100;
input double   Period_1=20.0;
input double   Period_2=30.0;
input ulong    WindowLen = 40;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   MathSrand(123);
   matrix series = matrix::Zeros(SizeOfSeries,5);
   vector trend,periodic1,periodic2,noise;
//---
   vector t = np::arange(SizeOfSeries);
   noise.Resize(t.Size());
//---
   trend = 0.001* pow(t-100.0,2.0);
   periodic1 = 3.2*sin(2.0*M_PI*t/Period_1);
   periodic2 = 1.75*sin(2.0*M_PI*t/Period_2);
//---
   
   noise.Random(0.0,1.0);
   noise -= 0.5;
   noise *= 2.0;
//---
   series.Col(trend,0);
   series.Col(periodic1,1);
   series.Col(periodic2,2);
   series.Col(noise,3);
//---
   vector full_process = series.Sum(1);
   series.Col(full_process,4);
   string colnames;
//---
   matrix components;
   vector eigvalues;
   if(!full_process.SingularSpectrumAnalysisReconstructComponents(WindowLen,components,eigvalues))
     {
      Print( " error ", GetLastError());
      return;
     }
//---
   colnames = NULL;
   for(ulong i = 0; i<components.Rows(); i++)
       {
        colnames+= "Row_"+string(i);
        if(i!=components.Rows()-1)
           colnames+= ",";
       }
   
   CGraphic* plot = np::plotMatrix(components.Transpose(),"Decomposed Components",colnames,"time","series values",false,0,0,0,0,550,500,true,2);
//---
   if(plot!=NULL)
     {
      Sleep(15000);
      plot.Destroy();
      delete plot;
     }   
//----
  
  }
//+------------------------------------------------------------------+
