//+------------------------------------------------------------------+
//|                                             SignalML_SAR_RVI.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/70_1.onnx" as uchar __70_1[]
#resource "Python/70_2.onnx" as uchar __70_2[]
#resource "Python/70_6.onnx" as uchar __70_6[]
#define __PATTERNS 3
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with SAR and RVI                             |
//| Type=SignalAdvanced                                              |
//| Name=SAR and RVI                                                 |
//| ShortName=ML_SAR_RVI                                             |
//| Class=CSignalML_SAR_RVI                                          |
//| Page=signal_sar_rvi                                              |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalML_SAR_RVI.                                         |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of ML with SAR and RVI                          |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalML_SAR_RVI : public CExpertSignal
{
protected:
   CiSAR             m_sar;
   CiRVI             m_rvi;
   CiStdDev          m_stddev;
   int               m_patterns_used;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_1;      // model 1
   int               m_pattern_2;      // model 2
   int               m_pattern_6;      // model 6
   //
   //int               m_patterns_usage;   //

public:
   CSignalML_SAR_RVI(void);
   ~CSignalML_SAR_RVI(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitML_SAR_RVI(CIndicators *indicators);
   //--- methods of getting data
   double            SAR(int ind)
   {  //
      m_sar.Refresh(-1);
      return(m_sar.Main(ind));
   }
   double            RVI(int ind)
   {  //
      m_rvi.Refresh(-1);
      return(m_rvi.GetData(0, ind));
   }
   double            RVI_SIGNAL(int ind)
   {  //
      m_rvi.Refresh(-1);
      return(m_rvi.GetData(1, ind));
   }
   double            STD_DEV(int ind)
   {  //
      m_stddev.Refresh(-1);
      return(m_stddev.Main(ind));
   }
   bool            RVI_UP(int ind)
   {  //
      return(RVI(ind) > RVI_SIGNAL(ind) && RVI(ind + 1) < RVI_SIGNAL(ind + 1));
   }
   bool            RVI_DN(int ind)
   {  //
      return(RVI(ind) < RVI_SIGNAL(ind) && RVI(ind + 1) > RVI_SIGNAL(ind + 1));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   long              Volume(int ind)
   {  //
      m_tick_volume.Refresh(-1);
      return(m_tick_volume.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalML_SAR_RVI::CSignalML_SAR_RVI(void) : m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_6(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__70_1, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__70_2, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__70_6, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalML_SAR_RVI::~CSignalML_SAR_RVI(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const ulong _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const ulong _in_shape[] = {1, 1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitML_SAR_RVI(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::InitML_SAR_RVI(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_sar)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object

   if(!m_sar.Create(m_symbol.Name(), m_period, 0.02, 0.2))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_rvi.Create(m_symbol.Name(), m_period, __PERIOD))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_stddev.Create(m_symbol.Name(), m_period, __PERIOD, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalML_SAR_RVI::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalML_SAR_RVI::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_1;
         results++;
      }
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_2;
         results++;
      }
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalML_SAR_RVI::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 1 is used
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_1;
         results++;
      }
   }
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_2;
         results++;
      }
   }
//--- if the model 6 is used
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_6;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::IsPattern_1(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Low(X() + 1) > SAR(X() + 1) && SAR(X()) < Low(X()) && RVI(X()) > RVI(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && High(X() + 1) < SAR(X() + 1) && SAR(X()) > High(X()) && RVI(X()) < RVI(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && High(X() + 1) <= SAR(X() + 1) && SAR(X()) <= Low(X()) && RVI(X()) > RVI(X() + 1) && Close(X()) < Close(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Low(X() + 1) >= SAR(X() + 1) && SAR(X()) >= High(X()) && RVI(X()) < RVI(X() + 1) && Close(X()) > Close(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalML_SAR_RVI::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Low(X() + 1) > SAR(X() + 1) && SAR(X()) < Low(X()) && RVI_UP(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && High(X() + 1) < SAR(X() + 1) && SAR(X()) > High(X()) && RVI_DN(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network, to Get Forecast State.                     |
//+------------------------------------------------------------------+
double CSignalML_SAR_RVI::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   printf(__FUNCSIG__ + " pre y is: "+DoubleToString(_y[0],5));
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   printf(__FUNCSIG__ + " post y is: ", DoubleToString(_y[0],5));
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
