//+------------------------------------------------------------------+
//|                                                    EA Wave 1.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Wave.ex5"
#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

enum type {Triangle,Saw,TriangleI,SawI};
input type Type=Triangle;
input ushort iPeriod=20,
             NumWave=4;

int handle;
double lot,ind[];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Wave.ex5",Type,iPeriod,NumWave,0);
   if(handle==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }

   ArrayResize(ind,iPeriod);

   CalcSignal();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;

   if(CopyBuffer(handle,0,0,iPeriod,ind)==iPeriod)
     {
      bool max=true,min=true;
      
      for(int i=1;i<iPeriod;i++)
        {
         if(ind[0]<ind[i])
            max=false;
         if(ind[0]>ind[i])
            min=false;
         if(max==false && min==false)
            break;
        }

      if(min==true)
         signal=0;

      if(max==true)
         signal=1;
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
