//+------------------------------------------------------------------+
//|                                        EA New Function Lin 2.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\New Function Lin.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

enum type {Rademacher,Walsh,RadSmooth,Hartley};

input type Type1=RadSmooth;
input uchar N1=2,
            P1=2;

input type Type2=Rademacher;
input uchar N2=8,
            P2=3;

int handle1,handle2;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle1=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\New Function Lin.ex5",Type1,N1,P1);
   handle2=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\New Function Lin.ex5",Type2,N2,P2);
   if(handle1==INVALID_HANDLE || handle2==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }

   CalcSignal();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   static double last_res;
   char signal=-1;
   double a[],b[];

   if(CopyBuffer(handle1,0,0,1,a)>0 && CopyBuffer(handle2,0,0,1,b)>0)
     {
      a[0]=b[0]-a[0];

      if(a[0]>0 && last_res<0)
         signal=0;

      if(a[0]<0 && last_res>0)
         signal=1;

      last_res=a[0];
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
