//+------------------------------------------------------------------+
//|                                 script_Statistics_candles_V2.mq4 |
//|                              Copyright  2009, Igor Aleksandrov  |
//|                                                sydiya@rambler.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Igor Aleksandrov"
#property link      "sydiya@rambler.ru"
#property show_inputs
//---- Input parameters

extern string  Open_session ="2009.11.20";   //Date of the opening of the studied session 
extern string  Close_session = "2009.11.26"; //Date of the closing of the studied session
extern int     Period_time = 60;             //Period of the graph on which the Expert Advisor will be working,
                                             //can take the value of 5;15;30;60;240
//-----------------------------------------------------------------
int 
    Day_bars_i;                      //Number for i bar in session
double
    Mas_vira_maina[24,60]={0,0 0,0}, //Declare an array for bars with an equal opening-closing price
    Mas_vira[24,60]={0,0 0,0},       //Declare an array for calculating bullish bars
    Mas_maina[24,60]={0,0 0,0},      //Declare an array for calculating bearish bars
    Mas_kol_vo[24,60]={0,0 0,0},     //Declare an array for calculating the number of the counted bars
    Mas_profit[24,60]={0,0 0.0},     //Declare an array of the calculation of profit by open-close
    Mas_H_L[24,60]={0,0 0.0};        //Declare an array of calculating the profit by high-low

string Symb;                         //Name of the financial. instrument on which the script is executed
bool New_day = false;                //Flag of the new day
//--------------------------------------------------------------------

//----------------------------Starting--------------------------------

int start()
  {                                  //-general opening bracket
  
  Print("----------------------------------------------------------------------");
  Print("  Results of the script's work- Statistics_candles- ",TimeToStr(TimeCurrent()) );
  Print("  Calculations completed from ",Open_session," to ",Close_session);

//------------------------Declare the variables ----------------------
  int  
       Hour_open_bars,                  //Number of the hour of opening the i bar in session
       Minute_open_bars,                //Number of the minute of opening  i bar in session
       Shift_open,                      //Number of bar with opening time Open_session               
       Shift_close,                     //Number of bar with opening time Close_session
       Shift_open_close,                //Number of bars in session
       Total_day=0;                     //Counter of counted days     
                    
  double Open_bars_price,               //Price of opening i bar of the session
         Close_bars_price,              //Price of closing the i bar of the session
         Low_bars_price,                //Minimum price of the i bar of the session
         High_bars_price,               //Maximum price of the i bar of the session
         Total_bars=0;                  //Number of studied bars at the start of the script
         
  datetime Time_open_session,           //Opening time of the first bar of the studied session 
                                        //in datatime format          
           Time_close_session,          //Opening time of the last bar of the studying 
                                        //session in datatime format 
           Time_open_bars;              //Opening time of bars in datatime format 
                       
  bool  Session_vira=false,             //Flag of the bullish session
        Session_maina=false;            //Flag of the bearish session 
//-----------------------End of the variables declaration ------------------
                   
  Symb=Symbol();                        //Name of the financial instrument
  
  //Request the starting time of the studied session in datatime format
  Time_open_session= StrToTime(Open_session); 

  //Request the closing time of the studied session in datatime format
  Time_close_session= StrToTime(Close_session); 

  //Request the number of the bar, opening the session
  Shift_open=iBarShift( Symb,Period_time, Time_open_session,false);

  //Request the number of the bar, which closes the session 
  Shift_close=iBarShift( Symb,Period_time, Time_close_session,false);

//---------------------------------------------------------------------  
for(int i = Shift_open; i>=Shift_close; i --)        //Cycle of bar searching in the session
{ //Opening bracket of the search cycle of bars
    Total_bars++;                                    //Counter of the number of studied bars
    static int New_day_shift=0;                      //Number of the day of starting the Expert Advisor

    //Request the opening of the i bar in session
    Time_open_bars=iTime( Symb,Period_time,Shift_open-Total_bars);

    //Request the opening hour of the i bar in session
    Hour_open_bars=TimeHour(Time_open_bars); 

    //Request the opening minute of the i bar in session 
    Minute_open_bars=TimeMinute(Time_open_bars);

    //Request the day number for the i bar in session
    Day_bars_i=TimeDayOfYear( Time_open_bars);
    
    //If the number for the first bar in session is not equal to the i-th bar of the day,then
    if(New_day_shift!=Day_bars_i)  
      {                                    
         New_day = true;               //flag for the new day is true
         New_day_shift=Day_bars_i;     //and assign the number for the number of the i bar
         Total_day++;                  //Increase the day counter by one
      }  
      else                             //otherwise,
      {
      New_day = false;                 //Flag for the new day is false
      }      
       //Request the opening price of the i-th bar
       Open_bars_price= iOpen( Symb, Period_time,i);

       //Request the closing price of the i-th bar
       Close_bars_price=iClose( Symb, Period_time,i);

       //Request the minimum price of the i-th bar
       Low_bars_price=iLow( Symb, Period_time,i);

       //Request the maximum price of the i-th bar
       High_bars_price=iHigh( Symb, Period_time,i);
        
       //If the opening price of the bar is lower than the closing price, then the session is bullish
       if(Open_bars_price<Close_bars_price) 
          {                                      
          //Increase by one the values of the corrsponding element
          Mas_vira[Hour_open_bars,Minute_open_bars]=Mas_vira[Hour_open_bars,Minute_open_bars]+1;

          //Increase by one the values of the corrsponding element
          Mas_kol_vo[Hour_open_bars,Minute_open_bars]=Mas_kol_vo[Hour_open_bars,Minute_open_bars]+1; 

          //Save the difference between the opening and closing price in points
          Mas_profit[Hour_open_bars,Minute_open_bars]=
          Mas_profit[Hour_open_bars,Minute_open_bars]+(Close_bars_price-Open_bars_price)/Point;

          //Save the difference between the maximum and minimum price in points
          Mas_H_L[Hour_open_bars,Minute_open_bars]=
          Mas_H_L[Hour_open_bars,Minute_open_bars]+(High_bars_price-Low_bars_price)/Point;
          }          

       //If the opening price of the bar is higher than the closing price, then the session is bearish
       if(Open_bars_price>Close_bars_price)
          {
           //Increase by one the values of the corrsponding element
           Mas_maina[Hour_open_bars,Minute_open_bars]=Mas_maina[Hour_open_bars,Minute_open_bars]+1;

           //Increase by one the values of the corrsponding element
           Mas_kol_vo[Hour_open_bars,Minute_open_bars]=Mas_kol_vo[Hour_open_bars,Minute_open_bars]+1; 

          //Save the difference between the opening and closing price in points
           Mas_profit[Hour_open_bars,Minute_open_bars]=
           Mas_profit[Hour_open_bars,Minute_open_bars]+(Open_bars_price-Close_bars_price)/Point;

          //Save the difference between the maximum and minimum price in points
           Mas_H_L[Hour_open_bars,Minute_open_bars]=
           Mas_H_L[Hour_open_bars,Minute_open_bars]+(High_bars_price-Low_bars_price)/Point;
          }

        //If the opening price is equal to the closing price, then session is undefined
        if(Open_bars_price==Close_bars_price)
          {
           ///Increase by one the corresponding array elements
           Mas_vira_maina[Hour_open_bars,Minute_open_bars]=Mas_vira_maina[Hour_open_bars,Minute_open_bars]+1;

           //Increase by one the corresponding array elements
           Mas_kol_vo[Hour_open_bars,Minute_open_bars]=Mas_kol_vo[Hour_open_bars,Minute_open_bars]+1; 
           
           //Leave the value of the array as is
           Mas_profit[Hour_open_bars,Minute_open_bars]=
           Mas_profit[Hour_open_bars,Minute_open_bars]+0;

           //Save the difference between maximum and minimum bar prices in points
           Mas_H_L[Hour_open_bars,Minute_open_bars]=
           Mas_H_L[Hour_open_bars,Minute_open_bars]+(High_bars_price-Low_bars_price)/Point;
          }                                                                          
      
} //Closing bracket of the bar search cycle
//--------------------------Print the information to the Expert Advisor Journal-------------------

Print("Processed - ",Total_day," days; ",Total_bars," bars, period ",Period_time," minutes");

for (int h=0; h<=23; h++) //Hours cycle
{
  for (int m=0; m<=60; m++) //Minutes cycle
   {
    if (Mas_kol_vo[h,m]!=0) //If the value of array is not equal to zero, then we continue counting
    {     
  Print("For the period there are ",Mas_kol_vo[h,m],
       " bars with the time of the opening ",h,":",m,
       " .Bullish- ",Mas_vira[h,m],
       ".Bearish- ",Mas_maina[h,m],
       ".Equal - ",Mas_vira_maina[h,m]);
  Print("For the bars with the opening time ",h,":",m,
       " ,average distance between the Open-Close prices - ",Mas_profit[h,m]/Mas_kol_vo[h,m],
       " points. Between the High-Low prices - ",Mas_H_L[h,m]/Mas_kol_vo[h,m]," points.");   
     }
           Mas_vira_maina[h,m]=0;  //set to zero
           Mas_vira[h,m]=0;        //set to zero
           Mas_maina[h,m]=0;       //set to zero
           Mas_kol_vo[h,m]=0;      //set to zero
           Mas_profit[h,m]=0;      //set to zero
           Mas_H_L[h,m]=0;         //set to zero
   } //End of the minute cycle
} //End of the hour cycle
             
Print("-------------- Script completed the work --------------------");

   return(0);    
  }                                        //-general closing bracket