//+------------------------------------------------------------------+
//|                                                    1-Session.mq4 |
//|                                Copyright  2009, Igor Alexandrov |
//|                                                sydiya@rambler.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Igor Alexandrov"
#property link      "sydiya@rambler.ru"

//---- Input parameters
extern string  Open_session =  "01:00"; //Opening time of the session to study
extern string  Close_session = "10:00"; //Closing time of the session to study
extern int Day_kol_vo = 50;             //Number of days to study
extern int Hour_kol_vo = 15;            //Number of hours to study after the session
extern int Profit = 20;                 //Take Profit value to verify

//----------------------------------------------------------------------------
string Symb;                            //Trade symbol of the expert attached
//----------------------------Starting----------------------------------------

int start()
  { //the main bracket begins
   int  Shift_open_H1,       //Number of hourly bar with the same opening time as daily bar
   Shift_open_bars_session,  //Number of hourly bar, that opens the session     
   Shift_close_bars_session, //Number of hourly bar, that closes the session
   STOP_LEVER=0;             //Minimal distance for TP and SL

   double Open_bars_session, //Opening price of the first bar of the session
   Close_bars_session,       //Closing price of the last bar of the session
   Vira_session,             //Maximal price of the session
   Total_TP=0,               //Counter of Take Profit executions
   Total_SL=0,               //Counter of Stop Loss executions
   Total_day=0,              //Number of days to study
   Total_SL_TP=0,            //Counter of neutral sessions
   Maina_session;            //Minimal price of the session

   datetime Time_open_day,   //Opening time of the i-th daily bar
   Time_open_session,        //Opening time of the session (datetime format)
   Time_close_session;       //Closing time of the session (datetime format)

   string String_open_H1;    //Opening time of the first hourly bar of the day to study
                             //as string format "yyyy.mm.dd"
   bool   Session_buy=false, //Bullish session flag
   Session_sell=false;       //Bearish session flag
   Symb=Symbol();            //Symbol name

   //Minimal distance for TP and SL
   STOP_LEVER=MarketInfo(Symb,MODE_STOPLEVEL);

   // daily bars cycle
   for(int i=Day_kol_vo;i>0;i --)
     { //bracket for daily bars cycle

      //Counter for days studied
      Total_day++;

      //opening time of the i-th daily bar
      Time_open_day=iTime(Symb,PERIOD_D1,i);

      //number of hourly bar with the same opening time as daily bar
      Shift_open_H1=iBarShift(Symb,PERIOD_H1,Time_open_day,false);

      //convert opening time of the first hourly bar to the string like "yyyy.mm.dd"
      String_open_H1=TimeToStr(Time_open_day,TIME_DATE);

      //opening time for the session to study (in the datetime format)
      Time_open_session=StrToTime(String_open_H1+" "+Open_session);

      //number of hourly bar from which session begins
      Shift_open_bars_session=iBarShift(Symb,PERIOD_H1,Time_open_session,false);

      //closing time of the session to study (in datetime format)
      Time_close_session=StrToTime(String_open_H1+" "+Close_session);

      //number of last hourly bar of the session
      Shift_close_bars_session=iBarShift(Symb,PERIOD_H1,Time_close_session,false);

      //opening price of the first bar of the session
      Open_bars_session=iOpen(Symb,PERIOD_H1,Shift_open_bars_session);

      //closing price of the last bar of the session
      Close_bars_session=iClose(Symb,PERIOD_H1,Shift_close_bars_session);

      //finding the maximal price of the session
      Vira_session=iHigh(Symb,PERIOD_H1,iHighest(Symb,PERIOD_H1,MODE_HIGH,(Shift_open_bars_session-Shift_close_bars_session),Shift_close_bars_session));

      //finding the minimal price of the session
      Maina_session=iLow(Symb,PERIOD_H1,iLowest(Symb,PERIOD_H1,MODE_LOW,(Shift_open_bars_session-Shift_close_bars_session),Shift_close_bars_session));

      // the opening price is greater than closing price, session is Bearish
      if(Open_bars_session>Close_bars_session)
        {
         Session_buy=false;
         Session_sell=true;
        }

      //The opening price is lower than closing price, session is bullish      
      if(Open_bars_session<Close_bars_session)
        {
         Session_buy=true;
         Session_sell=false;
        }

      //The opening price is equal to closing price, session is Neutral
      if(Open_bars_session==Close_bars_session)
        {
         Session_buy=false;
         Session_sell=false;
        }
      // hours counter for checking
      int PEREBOR=0;

      //Cycle for hourly bars in the i-th day
      for(int j=Shift_close_bars_session;j>Shift_close_bars_session-Hour_kol_vo;j --)
        {//Opening bracket for the hourly bars cycle

         //hours counter (for checking)
         PEREBOR++;

         //if session is bullish
         if(Session_buy==true && Session_sell==false)
           {
            //if maximal price of the hourly bar
            //is greater than (closing price of the session+Profit+Minimal distance)
            if(iHigh(Symb,PERIOD_H1,j-PEREBOR)>(Close_bars_session+(Profit+STOP_LEVER)*Point))
              {
               Total_TP++;     //Take Profit executed
               break;          //break the cycle(hourly bars)
              }
            //if minimal price of the hourly bar
            //is lower than minimal price of the session
            if(iLow(Symb,PERIOD_H1,j-PEREBOR)<Maina_session)
              {
               Total_SL++;     //Stop Loss executed
               break;          //break the cycle(hourly bars)
              }
           }
         //if session is bearish
         if(Session_buy==false && Session_sell==true)
           {
            //if maximal price of the hourly bar 
            //is greater than maximal price of the session
            if(iHigh(Symb,PERIOD_H1,j-PEREBOR)>Vira_session)
              {
               Total_SL++;      //Stop Loss executed
               break;           //break the cycle(hourly bars)
              }
            //if minimal price of the hourly bar 
            //is lower than (closing price of the session-(Profit + Minimal distance))
            if(iLow(Symb,PERIOD_H1,j-PEREBOR)<(Close_bars_session-(Profit+STOP_LEVER)*Point))
              {
               Total_TP++;      //Take Profit executed              
               break;           //break the cycle(hourly bars)
              }
           }
         //if session is neutral
         if(Session_buy==false && Session_sell==false)
           {
            Total_SL_TP++;      //Increase the counter
            break;              //break the cycle(hourly bars)
           }

        } // closing bracket for the hourly bars cycle

      double Pro_Total_TP=(Total_TP/Total_day)*100, //Probablity of TP execution
      Pro_Total_SL=(Total_SL/Total_day)*100,        //Probablity of SL execution
      Pro_Total_SL_TP=(Total_SL_TP/Total_day)*100;  //Probablity of neutral sessions
      int Total_no=Total_day-Total_SL-Total_TP-Total_SL_TP; //TP and SL hasn't executed
      double Pro_Total_no =(Total_no/Total_day)*100;        //Probablity that TP and SL will not executed
      Comment("Checked ",Total_day," days","\n",
              "Session Opening time  ",Open_session," Session Closing time ",
              Close_session," Number of hours to check after the session ",Hour_kol_vo," Profit ",Profit,"\n",
              "Take profit has executed ",Total_TP," times","\n",
              "Stop Loss has executed ",Total_SL," times","\n",
              "The neutral sessions was ",Total_SL_TP," times","\n",
              "Neither SL/TP executed ",Total_no," times","\n",
              "Probablity for Take Profit execution ",Pro_Total_TP," %","\n",
              "Probablity for Stop Loss execution ",Pro_Total_SL," %","\n",
              "Probablity for neutral sessions ",Pro_Total_SL_TP," %","\n",
              "Probablity that SL and TP will not executed ",Pro_Total_no," %");

     } //Closing bracket for the daily bars

   return(0);

  } //-the main bracket ends 

    
   Comment (" ",Total_day," ","\n",
   "    ",Open_session,"    ",
   Close_session, " -     ",Hour_kol_vo,"  ",Profit,"\n",      
  "     ",Total_TP," ","\n",
  "     ",Total_SL," ","\n",
  "     ",Total_SL_TP," ","\n",
  "    ,    ",Total_no," ","\n",
  "    ",Pro_Total_TP," %","\n",
  "    ",Pro_Total_SL," %","\n",
  "   ",Pro_Total_SL_TP," %","\n",
  "    ,   ",Pro_Total_no," %");   
      
  } //     
 
   return(0);
    
  }                                        //-  
  