//+------------------------------------------------------------------+
//|                                        RSI_Directions_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_buffers 3

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red
#property indicator_color3  Red

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

// buffers
double Values[];           // values
double Growing1[];         // 1st marking buffer
double Growing2[];         // 2nd marking buffer

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   IndicatorBuffers(3);
   
   SetIndexBuffer(0, Values);

   SetIndexBuffer(1, Growing1);
   SetIndexBuffer(2, Growing2);
   
   // buffer settings
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();

   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
   
   // mark growing
   for (i = toCount - 1; i >=0; i--)
   {
      // to check we need at least 1 older bars
      // if they are not available, there is no reason to continue
      if (i + 1 >= Bars)
      {
         continue;
      }

      // check empty values
      if (
            Values[i]      == EmptyValueUsed || 
            Values[i + 1]  == EmptyValueUsed ||
            Values[i]      == EMPTY_VALUE    || 
            Values[i + 1]  == EMPTY_VALUE
      )
      {
         continue;
      }
      
      // clean current marks
      Growing1[i] = EMPTY_VALUE;
      Growing2[i] = EMPTY_VALUE;
      
      // if is growing
      if (Values[i] > Values[i + 1])
      {
         // and was growing at previous bar
         if (Values[i + 1] > Values[i + 2])
         {
            // mark in current buffer
            if (Growing1[i + 1] != EMPTY_VALUE) Growing1[i] = Values[i];
            else                                Growing2[i] = Values[i];
         }
         // and was not growing at previous bar
         else
         {
            // mark in free buffer
            if (Growing2[i + 2] == EMPTY_VALUE) 
            {
               Growing2[i] = Values[i];
               Growing2[i + 1] = Values[i + 1];
            }
            else
            {
               Growing1[i] = Values[i];
               Growing1[i + 1] = Values[i + 1];
            }
         }
      }
      // cleaning tail if necessary
      else if (i == 0)
      {
         if (Growing1[i + 1] != EMPTY_VALUE && Growing1[i + 2] == EMPTY_VALUE)
         {
            Growing1[i + 1] = EMPTY_VALUE;
         }

         if (Growing2[i + 1] != EMPTY_VALUE && Growing2[i + 2] == EMPTY_VALUE)
         {
            Growing2[i + 1] = EMPTY_VALUE;
         }
      }
   }

   return(0);
}