//+------------------------------------------------------------------+
//|                                    RSI_Shifted_Levels_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_buffers 3

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  Blue
#property indicator_color2  Red
#property indicator_color3  Yellow

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

extern int HigherLevel     = 70;
extern int LowerLevel      = 30;

// buffers
double Higher[];           // overbuy
double Lower[];            // oversell
double Values[];           // values

int DigitsUsed = 5;
int EmptyValueUsed = 0;
int Depth = 0;

int init()
{
   Depth = 2;

   SetIndexBuffer(0, Higher);
   SetIndexBuffer(1, Lower);
   
   SetIndexBuffer(2, Values); 
   
   // buffers settings
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 3);    
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 3);    
   SetIndexStyle(2, DRAW_LINE);                    
   
   IndicatorDigits(DigitsUsed);
   
   SetIndexDrawBegin(0, RSIPeriod + 1);
   SetIndexDrawBegin(1, RSIPeriod + 1);
   SetIndexDrawBegin(2, RSIPeriod);
   
   SetLevelValue(0, HigherLevel);
   SetLevelValue(1, LowerLevel);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   
   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
   
   // check 1 bar more in order to get rid of garbage at previous bars
   toCount = MathMax(toCount, Depth);
      
   // mark levels -- upper
   for (i = toCount - 1; i >=0; i--)
   {
      if (Values[i] == EMPTY_VALUE || Values[i] == EmptyValueUsed)
      {
         continue;
      }
      
      Higher[i] = EMPTY_VALUE;
   
      // higher
      if (Values[i] >= HigherLevel)
      {
         Higher[i] = Values[i];
      }
   }
   
   return(0);
}